/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.swing;

import com.installshield.util.MD5;
import com.installshield.wizard.swing.JFlowLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class SwingText
extends JPanel
implements KeyListener {
    public static final int HTML = 1;
    public static final int PLAIN_TEXT = 2;
    private String text;
    private boolean showBorder;
    private int contentType;
    private JComponent ui;

    public SwingText() {
        this("", 2, false);
    }

    public SwingText(String string) {
        this(string, 2, false);
    }

    public SwingText(String string, int n, boolean bl) {
        this.text = string;
        this.verifyContentType(n);
        this.contentType = n;
        this.showBorder = bl;
        this.setLayout(new BorderLayout());
        this.ui = null;
    }

    public void addNotify() {
        super.addNotify();
        this.ui = this.createUI();
        this.add((Component)this.ui, "Center");
        this.setTextImpl(this.text);
    }

    private JComponent createUI() {
        if (this.contentType == 1) {
            JTextPane jTextPane = new JTextPane(){

                public boolean isFocusTraversable() {
                    return true;
                }
            };
            JScrollPane jScrollPane = new JScrollPane(jTextPane);
            jTextPane.setEditable(false);
            jTextPane.addKeyListener(this);
            jTextPane.setContentType("text/html");
            jTextPane.setBackground(this.findBackground());
            jTextPane.setForeground(this.findForeground());
            StyleSheet styleSheet = ((HTMLEditorKit)jTextPane.getEditorKit()).getStyleSheet();
            Font font = this.findFont();
            styleSheet.addRule("body {font-size: " + font.getSize() + "pt; }");
            styleSheet.addRule("body {font-family: " + font.getFamily() + "; }");
            if (font.isPlain()) {
                styleSheet.addRule("body {font-style: normal; }");
            } else {
                if (font.isItalic()) {
                    styleSheet.addRule("body {font-style: italic; }");
                }
                if (font.isBold()) {
                    styleSheet.addRule("body {font-weight: bold; }");
                }
            }
            if (!this.showBorder) {
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            }
            return jScrollPane;
        }
        if (this.showBorder) {
            JTextArea jTextArea = new JTextArea();
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jTextArea.setEditable(false);
            jTextArea.addKeyListener(this);
            jTextArea.setLineWrap(true);
            jTextArea.setFont(this.findFont());
            jTextArea.setWrapStyleWord(true);
            jTextArea.setForeground(this.findForeground());
            jTextArea.setBackground(this.findBackground());
            jTextArea.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
            return jScrollPane;
        }
        return new JFlowLabel();
    }

    private Color findBackground() {
        Color color = this.getBackground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getBackground();
            container = container.getParent();
        }
        if (color != null) {
            return color;
        }
        return Color.white;
    }

    private Font findFont() {
        Font font = this.getFont();
        Container container = this.getParent();
        while (font == null && container != null) {
            font = container.getFont();
            container = container.getParent();
        }
        return font;
    }

    private Color findForeground() {
        Color color = this.getForeground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getForeground();
            container = container.getParent();
        }
        if (color != null) {
            return color;
        }
        return Color.black;
    }

    private String formatColor(Color color) {
        return "#" + MD5.toHex(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public String getText() {
        return this.text;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t') {
            if ((keyEvent.getModifiers() & 1) != 0) {
                FocusManager.getCurrentManager().focusPreviousComponent(keyEvent.getComponent());
            } else {
                FocusManager.getCurrentManager().focusNextComponent(keyEvent.getComponent());
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.ui != null) {
            this.remove(this.ui);
            this.ui = null;
        }
    }

    private void reset() {
        if (this.ui != null) {
            this.remove(this.ui);
            this.ui = this.createUI();
            this.add((Component)this.ui, "Center");
            this.validate();
            this.repaint();
        }
    }

    public void setContentType(int n) {
        this.verifyContentType(n);
        this.contentType = n;
        this.reset();
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
        this.reset();
    }

    public void setText(String string) {
        this.text = string;
        this.setTextImpl(string);
    }

    private void setTextImpl(String string) {
        if (this.ui instanceof JScrollPane) {
            Component component = ((JScrollPane)this.ui).getViewport().getView();
            if (component instanceof JTextPane) {
                JTextPane jTextPane = (JTextPane)component;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><body text=\"");
                stringBuffer.append(this.formatColor(this.findForeground()));
                stringBuffer.append("\">");
                stringBuffer.append(string);
                stringBuffer.append("</body></html>");
                jTextPane.setText(stringBuffer.toString());
                jTextPane.setCaretPosition(1);
                jTextPane.getAccessibleContext().setAccessibleName(this.getAccessibleContext().getAccessibleName());
            } else if (component instanceof JTextArea) {
                ((JTextArea)component).setText(string);
                ((JTextArea)component).setCaretPosition(1);
                ((JTextArea)component).getAccessibleContext().setAccessibleName(this.getAccessibleContext().getAccessibleName());
            }
        } else if (this.ui instanceof JFlowLabel) {
            ((JFlowLabel)this.ui).setText(string);
        }
    }

    private void verifyContentType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal content type: " + n);
        }
    }
}

