/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;
import java.util.Vector;

public class DeleteLinesBetween
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private String[] tokens = new String[0];
    private boolean includeSearchLines = true;
    public static final String TYPE_DESCRIPTION = "Delete Lines Between";

    public Object clone() {
        DeleteLinesBetween deleteLinesBetween = (DeleteLinesBetween)super.clone();
        deleteLinesBetween.tokens = this.tokens;
        return deleteLinesBetween;
    }

    public boolean execute(ModifyFile modifyFile) {
        boolean bl = false;
        if (this.getTokens() == null || !this.validTokens()) {
            modifyFile.getLogAdd().addElement("Delete Lines Between requires Tokens have at least one valid token.");
        } else if (modifyFile.getASCIISearchResults() != null && modifyFile.getASCIISearchResults().length > 0) {
            int n = modifyFile.getASCIISearchResults()[0].getLineNum();
            modifyFile.setMatch(this.getResolvedTokens(modifyFile));
            modifyFile.setOccurrenceFrequency(1);
            modifyFile.setReturnPosition(0);
            modifyFile.setTokensNotFound(2);
            modifyFile.searchMultipleStrings();
            if (modifyFile.getASCIISearchResults() != null && modifyFile.getASCIISearchResults().length == 1) {
                int n2 = modifyFile.getASCIISearchResults()[0].getLineNum();
                modifyFile.setIncludeSearchLines(this.getIncludeSearchLines());
                modifyFile.deleteLinesBetween(n, n2);
                bl = true;
                modifyFile.setASCIISearchResults(null);
            }
        }
        return bl;
    }

    private String formatTokens() {
        String[] stringArray = this.getTokens();
        if (stringArray == null || stringArray.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 30;
        int n2 = 0;
        while (n > 0 && n2 < stringArray.length) {
            String string;
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            if ((string = stringArray[n2]).length() > n) {
                stringBuffer.append(String.valueOf(string.substring(0, n)) + "...");
            } else {
                stringBuffer.append(string);
            }
            n -= string.length();
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean getIncludeSearchLines() {
        return this.includeSearchLines;
    }

    private Vector getResolvedTokens(ModifyFile modifyFile) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.getTokens().length) {
            if (this.getTokens()[n] != null && this.getTokens()[n].length() > 0) {
                vector.addElement(modifyFile.resolveString(this.getTokens()[n]));
            }
            ++n;
        }
        return vector;
    }

    public String getShortDescription() {
        return "Delete Lines Between Search Result and: " + this.formatTokens();
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public void setIncludeSearchLines(boolean bl) {
        this.includeSearchLines = bl;
    }

    public void setTokens(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("tokens cannot be null");
        }
        this.tokens = stringArray;
    }

    private boolean validTokens() {
        int n = 0;
        while (n < this.getTokens().length) {
            if (this.getTokens()[n] != null && this.getTokens()[n].length() > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void verify(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        if (this.getTokens() == null || !this.validTokens()) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Delete Lines Between requires Tokens have at least one valid token.");
        }
    }
}

