/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.jobs;

import com.ibm.etools.fa.jobs.FAJob;
import com.ibm.etools.fa.jobs.IFAJobPostAction;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class DownloadMinidumpJob
extends FAJob {
    private String systemName = null;
    private String histFileName = null;
    private String faultID = null;
    private IFile miniDumpFile = null;
    private IFile reportFile = null;
    private IFAJobPostAction action = null;

    public DownloadMinidumpJob(String systemName, String histFileName, String faultID, IFile miniDumpFile, IFile reportFile, IFAJobPostAction action) {
        this.systemName = systemName;
        this.histFileName = histFileName;
        this.faultID = faultID;
        this.miniDumpFile = miniDumpFile;
        this.reportFile = reportFile;
        this.action = action;
    }

    public void runJob() throws CoreException {
        Job downloadFaultEntryJob = new Job(String.valueOf(NLS.getString("BrowseMiniDumpAction.BrowseMiniDumpJobName")) + " " + this.histFileName + "(" + this.faultID + ")"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("", 4);
                    FASubSystem faSubSystem = RSESystemManagement.getFASubSystem(DownloadMinidumpJob.this.systemName);
                    if (faSubSystem == null) {
                        DownloadMinidumpJob.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + DownloadMinidumpJob.this.systemName);
                        DownloadMinidumpJob.this.jobStatus = Status.OK_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownloadMinidumpJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    if (!faSubSystem.readHistoryFileMemberReportAndDump(DownloadMinidumpJob.this.histFileName, DownloadMinidumpJob.this.faultID, FAPlugin.getDefault().getConfigProject().getLocation() + File.separator + DownloadMinidumpJob.this.systemName + File.separator + DownloadMinidumpJob.this.histFileName + File.separator + DownloadMinidumpJob.this.faultID + File.separator, DownloadMinidumpJob.this.reportFile.exists() ? null : String.valueOf(DownloadMinidumpJob.this.faultID) + ".far", String.valueOf(DownloadMinidumpJob.this.faultID) + ".md")) {
                        DownloadMinidumpJob.this.openErrorThreadSafe(NLS.getString("ReadHistMemTitle"), NLS.getString("ReadHistMemMsg"));
                        DownloadMinidumpJob.this.jobStatus = Status.OK_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownloadMinidumpJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    DownloadMinidumpJob.this.reportFile.refreshLocal(1, monitor);
                    DownloadMinidumpJob.this.miniDumpFile.refreshLocal(1, monitor);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownloadMinidumpJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    if (!DownloadMinidumpJob.this.miniDumpFile.exists()) {
                        DownloadMinidumpJob.this.openErrorThreadSafe(NLS.getString("BrowseMiniDumpAction.BrowseFailureTitle"), NLS.getString("BrowseMiniDumpAction.BrowseFailureMsg"));
                        DownloadMinidumpJob.this.jobStatus = Status.OK_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    EditorManagement em = new EditorManagement();
                    em.openEditorFromWorkerThread(DownloadMinidumpJob.this.miniDumpFile, monitor);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        DownloadMinidumpJob.this.jobStatus = Status.CANCEL_STATUS;
                        DownloadMinidumpJob.this.jobSuccessful = false;
                        return Status.CANCEL_STATUS;
                    }
                    DownloadMinidumpJob.this.jobStatus = Status.OK_STATUS;
                    DownloadMinidumpJob.this.jobSuccessful = true;
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    DownloadMinidumpJob.this.openErrorThreadSafe(NLS.getString("BrowseMiniDumpAction.BrowseFailureTitle"), NLS.getString("BrowseMiniDumpAction.BrowseFailureMsg"));
                    FAPlugin.getDefault().log(4, NLS.getString("BrowseMiniDumpAction.BrowseFailureMsg"), e, false);
                    DownloadMinidumpJob.this.jobStatus = Status.OK_STATUS;
                    DownloadMinidumpJob.this.jobSuccessful = false;
                    return Status.OK_STATUS;
                }
            }
        };
        downloadFaultEntryJob.setPriority(30);
        downloadFaultEntryJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        downloadFaultEntryJob.addJobChangeListener(new IJobChangeListener(){

            public void done(IJobChangeEvent event) {
                if (DownloadMinidumpJob.this.action != null) {
                    DownloadMinidumpJob.this.action.actionUponCompletion();
                }
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        downloadFaultEntryJob.schedule();
    }
}

