/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.ISPFProfileInformation;
import com.ibm.etools.fa.util.NLS;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddNewHistoryFilePage
extends TitleAreaDialog {
    private final String HIST_FILE_COMBO = "com.ibm.etools.fa.pages.AddNewHistoryFilePage.histFileNameCombo";
    private Combo rseConnectionCombo;
    private Combo historyFileNameCombo;
    private String[] systemNames;
    private String selectedSystemName;
    private String historyFileName;
    private boolean cancelButtonPressed = false;
    ISPFProfileInformation ispfProfInfo = null;

    public AddNewHistoryFilePage(Shell parentShell, String[] systemNames) {
        super(parentShell);
        this.systemNames = systemNames;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.getString("AddNewHistoryFilePage.Title"));
        this.setMessage(NLS.getString("AddNewHistoryFilePage.Msg"));
        Composite composite = GUIUtility.createComposite(parent, 2);
        GUIUtility.createLabel(composite, NLS.getString("AddNewHistoryFilePage.curRSECon"), 1);
        this.rseConnectionCombo = GUIUtility.createCombo(composite);
        this.rseConnectionCombo.setItems(this.systemNames);
        this.rseConnectionCombo.select(0);
        GUIUtility.createLabel(composite, NLS.getString("AddNewHistoryFilePage.HistFileName"), 1);
        this.historyFileNameCombo = GUIUtility.createEditableCombo(composite);
        String[] prevValues = FAPlugin.getDefault().getDialogValues("com.ibm.etools.fa.pages.AddNewHistoryFilePage.histFileNameCombo");
        this.historyFileNameCombo.setItems(prevValues);
        this.historyFileNameCombo.select(0);
        this.historyFileNameCombo.setFocus();
        return super.createDialogArea(parent);
    }

    protected void okPressed() {
        this.selectedSystemName = this.rseConnectionCombo.getText();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cancelButtonPressed = true;
        super.cancelPressed();
    }

    private boolean validateHistoryFileName() {
        String value = this.historyFileNameCombo.getText().trim();
        if (value.length() > 0) {
            this.historyFileName = value.toUpperCase();
            this.setMessage(NLS.getString("AddNewHistoryFilePage.Msg"));
            return true;
        }
        this.setMessage(NLS.getString("AddNewHistoryFilePage.InvalidHistFileName"), 3);
        return false;
    }

    public boolean close() {
        if (this.cancelButtonPressed) {
            return super.close();
        }
        if (!this.validateHistoryFileName()) {
            return false;
        }
        FAPlugin.getDefault().addNewDialogValueIfNew("com.ibm.etools.fa.pages.AddNewHistoryFilePage.histFileNameCombo", this.historyFileName);
        return super.close();
    }

    public String getSelectedSystemName() {
        return this.selectedSystemName;
    }

    public String getHistoryFileName() {
        return this.historyFileName.toUpperCase();
    }
}

