/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.common.Address;
import com.ibm.etools.fa.common.MiniDumpRecord;
import com.ibm.etools.fa.dump.editor.DumpBrowser;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDialog
extends Dialog {
    private final String SEARCH_VALUES_COMBO_KEY = String.valueOf(SearchDialog.class.getName()) + ".searchValues";
    private Text msgText;
    private Combo searchTextCombo;
    private Button findButton;
    Button forwardButton;
    Button backwardButton;
    Button strSearchButton;
    Button hexSearchButton;
    private DumpBrowser browser;
    private ArrayList<Address> addresses;
    private Address startAddress;

    public SearchDialog(Shell parentShell, DumpBrowser browser, ArrayList<Address> addresses, Address startAddress) {
        super(parentShell);
        this.browser = browser;
        this.addresses = addresses;
        this.startAddress = startAddress;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 1);
        this.createMessageArea(composite);
        this.createFindComposite(composite);
        Composite optionsComposite = GUIUtility.createComposite(composite, 2);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        optionsComposite.setLayoutData((Object)gridData);
        this.searchDirectionComposite(optionsComposite);
        this.searchModeComposite(optionsComposite);
        this.createButtons(composite);
        return composite;
    }

    private void createMessageArea(Composite parent) {
        Composite msgAreaComposite = GUIUtility.createComposite(parent, 1);
        msgAreaComposite.setBackground(parent.getBackground());
        this.msgText = new Text(msgAreaComposite, 4);
        this.msgText.setBackground(msgAreaComposite.getBackground());
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 300;
        this.msgText.setLayoutData((Object)data);
        this.setDefaultText();
    }

    private void setDefaultText() {
        this.setMessage(NLS.getString("SearchDialog.SearchDefaultMsg"));
    }

    private void setMessage(String msg) {
        this.msgText.setText(msg);
    }

    private void createFindComposite(Composite parent) {
        Composite findTextComposite = GUIUtility.createComposite(parent, 2);
        GUIUtility.createLabel(findTextComposite, NLS.getString("Find"), 1);
        this.searchTextCombo = GUIUtility.createEditableCombo(findTextComposite);
        this.searchTextCombo.setFocus();
        this.searchTextCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    FAPlugin.getDefault().addNewDialogValueIfNew(SearchDialog.this.SEARCH_VALUES_COMBO_KEY, SearchDialog.this.searchTextCombo.getText().trim());
                    SearchDialog.this.performSearch();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        String[] previousValues = FAPlugin.getDefault().getDialogValues(this.SEARCH_VALUES_COMBO_KEY);
        this.searchTextCombo.setItems(previousValues);
    }

    private void searchDirectionComposite(Composite parent) {
        Group searchDirGroup = GUIUtility.createGroup(parent, 2, NLS.getString("SearchDialog.SearchDirectionGrp"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        searchDirGroup.setLayoutData((Object)gridData);
        this.forwardButton = GUIUtility.createRadioButton((Composite)searchDirGroup, NLS.getString("Forward"), 2);
        this.forwardButton.setSelection(true);
        this.backwardButton = GUIUtility.createRadioButton((Composite)searchDirGroup, NLS.getString("Backward"), 2);
    }

    private void searchModeComposite(Composite parent) {
        Group searchModeGroup = GUIUtility.createGroup(parent, 2, NLS.getString("SearchDialog.SearchModeGrp"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        searchModeGroup.setLayoutData((Object)gridData);
        this.hexSearchButton = GUIUtility.createRadioButton((Composite)searchModeGroup, NLS.getString("Hexadecimal"), 2);
        this.hexSearchButton.setSelection(true);
        this.strSearchButton = GUIUtility.createRadioButton((Composite)searchModeGroup, NLS.getString("String"), 2);
    }

    private void createButtons(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 2);
        this.findButton = new Button(composite, 8);
        this.findButton.setText(NLS.getString("Find"));
        this.findButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FAPlugin.getDefault().addNewDialogValueIfNew(SearchDialog.this.SEARCH_VALUES_COMBO_KEY, SearchDialog.this.searchTextCombo.getText().trim());
                SearchDialog.this.performSearch();
            }
        });
        Button closeButton = new Button(composite, 8);
        closeButton.setText(NLS.getString("Close"));
        closeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FAPlugin.getDefault().addNewDialogValueIfNew(SearchDialog.this.SEARCH_VALUES_COMBO_KEY, SearchDialog.this.searchTextCombo.getText().trim());
                SearchDialog.this.close();
            }
        });
    }

    private void performSearch() {
        this.setDefaultText();
        byte[] searchPattern = this.getSearchPattern();
        if (searchPattern != null) {
            Address searchResult = this.forwardButton.getSelection() ? this.searchNext(this.startAddress, searchPattern) : this.searchPrev(this.startAddress, searchPattern);
            if (searchResult != null) {
                System.out.println("Moving to " + searchResult.toString());
                this.browser.moveToAddress(searchResult);
                this.startAddress = this.forwardButton.getSelection() ? new Address(searchResult.getAddress64(), searchResult.getAddress31() + 1L) : new Address(searchResult.getAddress64(), searchResult.getAddress31() - 1L);
            } else {
                this.setMessage(NLS.getString("SearchDialog.NoMatchFound"));
            }
        } else {
            this.setMessage(NLS.getString("SearchDialog.InvalidSearchValue"));
        }
    }

    private byte[] getSearchPattern() {
        block4: {
            try {
                if (this.searchTextCombo.getText().trim().length() != 0) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.hexSearchButton.getSelection()) {
            return this.hexToByteArray(this.searchTextCombo.getText().trim());
        }
        return this.strToByteArray(this.searchTextCombo.getText().trim());
    }

    private Address searchNext(Address currentStart, byte[] searchValue) {
        int i = 0;
        while (i < this.addresses.size()) {
            Address result;
            Address currentAddr = this.addresses.get(i);
            if (currentAddr.getAddress31() == 0L && currentAddr.getAddress64() == 0L) {
                if (currentStart.getAddress31() < currentAddr.getAddress31() + 2048L) {
                    result = this.searchWithinRecord(this.browser.readRecord(currentAddr), currentStart, searchValue);
                    if (result != null) {
                        return result;
                    }
                    currentStart = new Address(currentStart.getAddress64(), currentAddr.getAddress31() + 4096L);
                }
            } else if (currentStart.getAddress31() < currentAddr.getAddress31() + 4096L) {
                result = this.searchWithinRecord(this.browser.readRecord(currentAddr), currentStart, searchValue);
                if (result != null) {
                    return result;
                }
                currentStart = new Address(currentStart.getAddress64(), currentAddr.getAddress31() + 4096L);
            }
            ++i;
        }
        return null;
    }

    private Address searchPrev(Address currentStart, byte[] searchValue) {
        int i = this.addresses.size() - 1;
        while (i >= 0) {
            Address currentAddr = this.addresses.get(i);
            if (currentStart.getAddress31() >= currentAddr.getAddress31()) {
                Address result = this.searchWithinRecordPrev(this.browser.readRecord(currentAddr), currentStart, searchValue);
                if (result != null) {
                    return result;
                }
                currentStart = new Address(currentStart.getAddress64(), currentAddr.getAddress31() - 1L);
            }
            --i;
        }
        return null;
    }

    private Address searchWithinRecord(MiniDumpRecord record, Address startAddress, byte[] pattern) {
        long start = startAddress.getAddress31();
        if (record.getDDirMdAddr31() > start) {
            start = record.getDDirMdAddr31();
        }
        int startOffset = (int)(start - record.getDDirMdAddr31());
        int foundOffset = this.search(record.getDDirMdData(), startOffset, pattern);
        if (foundOffset != -1) {
            return new Address(startAddress.getAddress64(), record.getDDirMdAddr31() + (long)foundOffset);
        }
        return null;
    }

    private Address searchWithinRecordPrev(MiniDumpRecord record, Address startAddress, byte[] pattern) {
        long start = startAddress.getAddress31();
        if (record.getDDirMdAddr31() == 0L && record.getDDirMdAddr64() == 0L) {
            if (record.getDDirMdAddr31() + 2048L - 1L < start) {
                start = record.getDDirMdAddr31() + 2048L - 1L;
            }
        } else if (record.getDDirMdAddr31() + 4096L - 1L < start) {
            start = record.getDDirMdAddr31() + 4096L - 1L;
        }
        int startOffset = (int)(start - record.getDDirMdAddr31());
        int foundOffset = this.searchPrev(record.getDDirMdData(), startOffset, pattern);
        if (foundOffset != -1) {
            return new Address(startAddress.getAddress64(), record.getDDirMdAddr31() + (long)foundOffset - (long)pattern.length + 1L);
        }
        return null;
    }

    private int search(byte[] buffer, int startOffset, byte[] pattern) {
        if (buffer.length - startOffset < pattern.length) {
            return -1;
        }
        if (this.startWith(buffer, startOffset, pattern)) {
            return startOffset;
        }
        return this.search(buffer, startOffset + 1, pattern);
    }

    private int searchPrev(byte[] buffer, int startOffset, byte[] pattern) {
        if (pattern.length - 1 > startOffset) {
            return -1;
        }
        if (this.endWith(buffer, startOffset, pattern)) {
            return startOffset;
        }
        return this.searchPrev(buffer, startOffset - 1, pattern);
    }

    private boolean startWith(byte[] buffer, int startOffset, byte[] pattern) {
        int i = 0;
        while (i < pattern.length) {
            if (pattern[i] != buffer[startOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean endWith(byte[] buffer, int startOffset, byte[] pattern) {
        int i = pattern.length - 1;
        while (i >= 0) {
            if (pattern[i] != buffer[startOffset--]) {
                return false;
            }
            --i;
        }
        return true;
    }

    private byte[] hexToByteArray(String hexStr) {
        block4: {
            if (hexStr.length() % 2 == 0) break block4;
            return null;
        }
        try {
            byte[] result = new byte[hexStr.length() / 2];
            int i = 0;
            int index = 0;
            while (i < hexStr.length()) {
                result[index] = (byte)(Integer.parseInt(String.valueOf(hexStr.charAt(i)), 16) << 4 | Integer.parseInt(String.valueOf(hexStr.charAt(i + 1)), 16));
                i += 2;
                ++index;
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] strToByteArray(String string) {
        try {
            return string.getBytes("Cp1047");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

