/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.common.Address;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserNotePage
extends TitleAreaDialog {
    private Address address;
    private Text addressText;
    private Text userNoteText;
    private String userNoteValue;
    private boolean cancelButtonPressed = false;

    public UserNotePage(Shell parentShell, Address address, String initialUserNoteValue) {
        super(parentShell);
        this.address = address;
        this.userNoteValue = initialUserNoteValue;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.getString("UserNotePage.Title"));
        this.setMessage(NLS.getString("UserNotePage.Msg"));
        Composite mainComposite = GUIUtility.createComposite(parent, 1);
        Composite addrComp = GUIUtility.createComposite(mainComposite, 2);
        GUIUtility.createLabel(addrComp, NLS.getString("Address"), 1);
        this.addressText = GUIUtility.createTextField(addrComp);
        this.addressText.setText(this.address.toString());
        this.userNoteText = GUIUtility.createTextArea(mainComposite, 20, false, true);
        this.userNoteText.setText(this.userNoteValue);
        this.userNoteText.setFocus();
        return mainComposite;
    }

    protected void okPressed() {
        this.cancelButtonPressed = false;
        this.userNoteValue = this.userNoteText.getText().trim();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cancelButtonPressed = true;
        this.userNoteValue = "";
        super.cancelPressed();
    }

    public boolean close() {
        if (this.cancelButtonPressed) {
            return super.close();
        }
        if (!this.validateUserNote()) {
            this.setMessage(NLS.getString("UserNotePage.EmptyUserNote"), 3);
            return false;
        }
        return super.close();
    }

    private boolean validateUserNote() {
        String value = this.userNoteText.getText().trim();
        if (value.length() == 0) {
            return false;
        }
        this.userNoteValue = value;
        return true;
    }

    public String getUserNote() {
        return this.userNoteValue;
    }
}

