/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.report.editor;

import com.ibm.etools.fa.common.Address;
import com.ibm.etools.fa.common.XMSegmentElement;
import com.ibm.etools.fa.dump.editor.DumpBrowser;
import com.ibm.etools.fa.jobs.DownloadMinidumpJob;
import com.ibm.etools.fa.jobs.IFAJobPostAction;
import com.ibm.etools.fa.jobs.ProcessLangxFileJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.report.editor.MainReportPage;
import com.ibm.etools.fa.report.editor.MiscInfoPage;
import com.ibm.etools.fa.report.editor.SystemWideInfoPage;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.MiniDumpRecordReader;
import com.ibm.etools.fa.util.NLS;
import com.ibm.ftt.ui.os390editors.Os390SolutionsEditor;
import com.ibm.lpex.core.LpexView;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.part.FileEditorInput;

public class FAReportBrowser
extends FormEditor {
    public static final String ID = "com.ibm.etools.fa.report.editor.FAReportBrowser";
    public static final String ABEND_JOB_INFO = "<AbendJobInfo";
    public static final String EVENT_DETAILS = "<EventDetails";
    public static final String EVENT_NUMBER = "<Event number";
    public static final String EVENT_SUMMARY = "<EventSummary";
    public static final String SUMMARY = "<Summary";
    public static final String SYNOPSIS = "<Synopsis";
    public static final String SYSTEM_WIDE_INFO = "<SystemWideInfo";
    public static final String OPEN_FILES = "<OpenFiles";
    public static final String CICS_INFO = "<CICSInfo";
    public static final String DB2_INFO = "<DB2Info";
    public static final String IMS_INFO = "<IMSInfo";
    public static final String MESSAGES = "<Messages";
    public static final String STORAGE_AREAS = "<StorageAreas";
    public static final String LE_HEAP_ANALYSIS = "<LEHeapAnalysis";
    public static final String EPILOG = "<Epilog";
    public static final String OPTIONS_IN_EFFECT = "<OptionsInEffect";
    public static final String PROLOG = "<Prolog";
    public static final String ADDRESS_TAG_PREFIX = "ADDR:";
    public static final String ABEND_CODE_TAG_PREFIX = "AbendCode:";
    public static final String SRC_LINE_TAG_PREFIX = "SrcLine:";
    public static final String SRC_STMT_TAG_PREFIX = "SrcStmt:";
    public static final String SRC_STMT_TAG_PROG = "Program=";
    public static final String SRC_STMT_TAG_OFFSET = "Offset=";
    public static final String SRC_STMT_TAG_LINE = "RLinen=";
    public static final String SRC_STMT_TAG_FILE = "File=";
    public static final String SRC_STMT_TAG_TYPE = "Type=";
    private XMSegmentElement xmSegmentElement = null;

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(FAPlugin.getDefault().getFormColors(display));
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new MainReportPage(this, this.getXMSegmentElement()));
            this.addPage((IFormPage)new SystemWideInfoPage(this, this.getXMSegmentElement()));
            this.addPage((IFormPage)new MiscInfoPage(this, this.getXMSegmentElement()));
            this.setPartName(this.getFile().getName());
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("FAReportBrowser.addPagesErr"), e, true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private XMSegmentElement getXMSegmentElement() {
        if (this.xmSegmentElement == null) {
            this.xmSegmentElement = MiniDumpRecordReader.getXMSegmentElement(this.getFile().getLocation().toFile());
        }
        return this.xmSegmentElement;
    }

    public IFile getFile() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return file;
    }

    public void createBrowseDumpHyperLink(Composite parent, FormToolkit toolkit) {
        Hyperlink link = toolkit.createHyperlink(parent, NLS.getString("FAReportBrowser.BrowseDumpLink"), 131136);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IFile reportFile = FAReportBrowser.this.getFile();
                    String miniDumpFileName = String.valueOf(reportFile.getName().toString().substring(0, reportFile.getName().lastIndexOf(46))) + ".md";
                    IFolder parent = (IFolder)reportFile.getParent();
                    IFile dumpFile = parent.getFile(miniDumpFileName);
                    if (!dumpFile.exists()) {
                        String systemName = parent.getParent().getParent().getName();
                        String histFileName = parent.getParent().getName();
                        String faultID = parent.getName();
                        DownloadMinidumpJob downloadMinidumpJob = new DownloadMinidumpJob(systemName, histFileName, faultID, dumpFile, reportFile, null);
                        downloadMinidumpJob.runJob();
                    } else {
                        EditorManagement.openEditor(dumpFile);
                    }
                }
                catch (Exception e1) {
                    FAPlugin.getDefault().log(4, NLS.getString("FAReportBrowser.OpenDumpEditorErr"), e1, true);
                    return;
                }
            }
        });
    }

    public void createSectionWithLabel(Composite parent, String title, String description, String bodyText, boolean expanded, FormToolkit toolkit, final ScrolledForm form) {
        Section section = toolkit.createSection(parent, 450);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        toolkit.createCompositeSeparator((Composite)section);
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Label client = toolkit.createLabel((Composite)section, bodyText, 64);
        client.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        section.setClient((Control)client);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        section.setExpanded(expanded);
    }

    public void createExpandable(Composite parent, String title, String bodyText, boolean expanded, FormToolkit toolkit, final ScrolledForm form, Color backgroundColor) {
        ExpandableComposite ec = toolkit.createExpandableComposite(parent, 20);
        ec.setText(title);
        if (backgroundColor != null) {
            ec.setBackground(backgroundColor);
        }
        Label client = toolkit.createLabel((Composite)ec, bodyText, 64);
        client.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        ec.setClient((Control)client);
        ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        ec.setExpanded(expanded);
    }

    public void createExpandableWithRichText(Composite parent, String title, String bodyText, boolean expanded, FormToolkit toolkit, final ScrolledForm form, Color backgroundColor) {
        ExpandableComposite ec = toolkit.createExpandableComposite(parent, 20);
        ec.setText(title);
        if (backgroundColor != null) {
            ec.setBackground(backgroundColor);
        }
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        ec.setLayoutData((Object)td);
        FormText formText = toolkit.createFormText((Composite)ec, true);
        formText.setLayoutData((Object)new TableWrapData(128));
        formText.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        StringBuffer contents = new StringBuffer(bodyText.length());
        contents.append("<form><p>");
        StringTokenizer st = new StringTokenizer(this.replaceHTMLSpecialChars(this.checkXMLTags(bodyText)), "\n");
        while (st.hasMoreElements()) {
            contents.append(String.valueOf(st.nextToken()) + "<BR/>");
        }
        contents.append("</p></form>");
        formText.setWhitespaceNormalized(false);
        formText.setText(contents.toString(), true, false);
        formText.addHyperlinkListener(this.createHyperlinkListener());
        ec.setClient((Control)formText);
        ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        ec.setExpanded(expanded);
    }

    public void createRichTextFormSection(Composite parent, String title, String description, String bodyText, boolean expanded, FormToolkit toolkit, final ScrolledForm form) {
        Section section = toolkit.createSection(parent, 450);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        toolkit.createCompositeSeparator((Composite)section);
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        FormText formText = toolkit.createFormText((Composite)section, true);
        formText.setLayoutData((Object)new TableWrapData(128));
        formText.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        StringBuffer contents = new StringBuffer(bodyText.length());
        contents.append("<form><p>");
        StringTokenizer st = new StringTokenizer(this.replaceHTMLSpecialChars(this.checkXMLTags(bodyText)), "\n");
        while (st.hasMoreElements()) {
            contents.append(String.valueOf(st.nextToken()) + "<BR/>");
        }
        contents.append("</p></form>");
        formText.setWhitespaceNormalized(false);
        formText.setText(contents.toString(), true, false);
        formText.addHyperlinkListener(this.createHyperlinkListener());
        section.setClient((Control)formText);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        section.setExpanded(expanded);
    }

    public void createRichTextFormSectionWithoutExpansion(Composite parent, String title, String description, String bodyText, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        toolkit.createCompositeSeparator((Composite)section);
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        FormText formText = toolkit.createFormText((Composite)section, true);
        formText.setLayoutData((Object)new TableWrapData(128));
        formText.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.defaultFont"));
        StringBuffer contents = new StringBuffer(bodyText.length());
        contents.append("<form><p>");
        StringTokenizer st = new StringTokenizer(this.replaceHTMLSpecialChars(this.checkXMLTags(bodyText)), "\n");
        while (st.hasMoreElements()) {
            contents.append(String.valueOf(st.nextToken()) + "<BR/>");
        }
        contents.append("</p></form>");
        formText.setWhitespaceNormalized(false);
        formText.setText(contents.toString(), true, false);
        formText.addHyperlinkListener(this.createHyperlinkListener());
        section.setClient((Control)formText);
    }

    private IHyperlinkListener createHyperlinkListener() {
        return new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                String url = e.getHref().toString();
                System.out.println("Activating " + url);
                if (url.startsWith(FAReportBrowser.ADDRESS_TAG_PREFIX)) {
                    FAReportBrowser.this.handleAddressLink(url);
                } else if (url.startsWith(FAReportBrowser.ABEND_CODE_TAG_PREFIX)) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Not Yet!", (String)("ABEND lookup is not implemented yet! value = " + url));
                } else if (url.startsWith(FAReportBrowser.SRC_LINE_TAG_PREFIX)) {
                    System.out.println("linkActivated with SRC_LINE_TAG_PREFIX");
                    FAReportBrowser.this.handleSourceLink(url);
                } else if (url.startsWith(FAReportBrowser.SRC_STMT_TAG_PREFIX)) {
                    System.out.println("linkActivated with SRC_STMT_TAG_PREFIX");
                    FAReportBrowser.this.handleSourceLink(url);
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Not Yet!", (String)("Unknown URL [" + url + "]"));
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        };
    }

    private void handleAddressLink(String url) {
        try {
            final long address = Long.parseLong(url.substring(ADDRESS_TAG_PREFIX.length(), url.length()).trim(), 16);
            System.out.println("Moving to " + address);
            IFile file = this.getFile();
            String miniDumpFileName = String.valueOf(file.getName().toString().substring(0, file.getName().lastIndexOf(46))) + ".md";
            IFolder parent = (IFolder)file.getParent();
            final IFile dumpFile = parent.getFile(miniDumpFileName);
            if (dumpFile.exists()) {
                IEditorPart editor = EditorManagement.openEditor(dumpFile);
                if (editor instanceof DumpBrowser) {
                    DumpBrowser dumpBrowser = (DumpBrowser)editor;
                    dumpBrowser.moveToAddress(new Address(0L, address));
                }
            } else {
                String systemName = file.getParent().getParent().getParent().getName();
                String histFileName = file.getParent().getParent().getName();
                String faultID = file.getParent().getName();
                DownloadMinidumpJob job = new DownloadMinidumpJob(systemName, histFileName, faultID, dumpFile, file, new IFAJobPostAction(){

                    public void actionUponCompletion() {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                try {
                                    IEditorPart editor = EditorManagement.openEditor(dumpFile);
                                    if (editor instanceof DumpBrowser) {
                                        DumpBrowser dumpBrowser = (DumpBrowser)editor;
                                        dumpBrowser.moveToAddress(new Address(0L, address));
                                    }
                                }
                                catch (Exception e) {
                                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("FAReportBrowser.OepnDumpPageErrTitle"), (String)NLS.getString("FAReportBrowser.OepnDumpPageErrMsg"));
                                    FAPlugin.getDefault().log(4, NLS.getString("FAReportBrowser.OepnDumpPageErrMsg"), e, false);
                                    return;
                                }
                            }
                        });
                    }
                });
                job.runJob();
            }
        }
        catch (Exception e1) {
            FAPlugin.getDefault().log(1, NLS.getString("FAReportBrowser.ErrAddrDisp"), e1, false);
            return;
        }
    }

    private String checkXMLTags(String contents) {
        StringBuffer newContents = new StringBuffer(contents.length());
        StringTokenizer st = new StringTokenizer(contents, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            if (this.noOpenedXMLTag(line)) {
                newContents.append(String.valueOf(line) + "\n");
                continue;
            }
            newContents.append(line);
        }
        return newContents.toString();
    }

    private boolean noOpenedXMLTag(String line) {
        int i = line.length() - 1;
        while (i >= 0) {
            if (line.charAt(i) == '>') {
                return true;
            }
            if (line.charAt(i) == '<') {
                return false;
            }
            --i;
        }
        return true;
    }

    private String replaceHTMLSpecialChars(String contents) {
        StringBuffer sb = new StringBuffer(contents.length());
        int i = 0;
        while (i < contents.length()) {
            char c = contents.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private void handleSourceLink(String url) {
        try {
            String prog = null;
            String offset = null;
            int linen = -1;
            String file = null;
            String type = null;
            String langxMemberName = null;
            StringTokenizer urlToken = new StringTokenizer(url);
            while (urlToken.hasMoreTokens()) {
                String next = urlToken.nextToken();
                if (next.startsWith(SRC_STMT_TAG_PROG)) {
                    prog = next.substring(next.indexOf("=") + 1);
                    continue;
                }
                if (next.startsWith(SRC_STMT_TAG_OFFSET)) {
                    offset = next.substring(next.indexOf("=") + 1);
                    continue;
                }
                if (next.startsWith(SRC_STMT_TAG_LINE)) {
                    linen = new Integer(next.substring(next.indexOf("=") + 1));
                    continue;
                }
                if (next.startsWith(SRC_STMT_TAG_FILE)) {
                    file = next.substring(next.indexOf("=") + 1);
                    continue;
                }
                if (!next.startsWith(SRC_STMT_TAG_TYPE)) continue;
                type = next.substring(next.indexOf("=") + 1);
            }
            System.out.println("Program = " + prog);
            System.out.println("File = " + file);
            System.out.println("Line Number= " + linen);
            System.out.println("Offset = " + offset);
            if (!type.equalsIgnoreCase("X")) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("FAReportBrowser.NonLangxErrTitle"), (String)NLS.getString("FAReportBrowser.NonLangxErrMsg"));
                return;
            }
            langxMemberName = file.substring(file.indexOf(40) + 1, file.lastIndexOf(41));
            System.out.println("LANGX member name is " + langxMemberName);
            IFile reportFile = this.getFile();
            String systemName = reportFile.getParent().getParent().getParent().getName();
            String srcFileName = String.valueOf(langxMemberName) + ".cbl";
            IFolder parent = (IFolder)reportFile.getParent();
            IFile srcFile = parent.getFile(srcFileName);
            if (srcFile.exists()) {
                IEditorPart editor = EditorManagement.openEditor(srcFile);
                if (editor instanceof Os390SolutionsEditor && linen != -1) {
                    System.out.println("Moving to " + linen);
                    LpexView view = ((Os390SolutionsEditor)editor).getActiveLpexView();
                    view.doDefaultCommand("locate line " + linen);
                }
            } else {
                ProcessLangxFileJob job = new ProcessLangxFileJob(systemName, file, langxMemberName, linen, srcFile);
                job.runJob();
            }
            System.out.println("Finshed copying the file!");
        }
        catch (Exception e) {
            e.printStackTrace();
            FAPlugin.getDefault().log(4, NLS.getString(""), e, true);
        }
    }
}

