/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.report.editor;

import com.ibm.etools.fa.common.XMSegmentElement;
import com.ibm.etools.fa.report.editor.FAReportBrowser;
import com.ibm.etools.fa.util.NLS;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SystemWideInfoPage
extends FormPage {
    private XMSegmentElement rootElement;
    private XMSegmentElement systemWideInfoElement = null;
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;

    public SystemWideInfoPage(FormEditor editor, XMSegmentElement xmSegmentElement) {
        super(editor, SystemWideInfoPage.class.getName(), NLS.getString("SystemWideInfoPage.Title"));
        this.rootElement = xmSegmentElement;
    }

    private void initXMElements() {
        if (this.systemWideInfoElement == null) {
            this.systemWideInfoElement = new XMSegmentElement();
            this.systemWideInfoElement.appendContent(NLS.getString("n/a"));
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.searchRequiredElement(this.rootElement);
        this.initXMElements();
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        ((FAReportBrowser)this.getEditor()).createBrowseDumpHyperLink(this.form.getBody(), this.toolkit);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        this.form.getBody().setLayout((Layout)layout);
        ArrayList children = this.systemWideInfoElement.getChildren();
        int i = 0;
        while (i < children.size()) {
            XMSegmentElement child = (XMSegmentElement)children.get(i);
            if (child.getStartTag().startsWith("<OpenFiles")) {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.OpenFiles"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            } else if (child.getStartTag().startsWith("<CICSInfo")) {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.CICSInfo"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            } else if (child.getStartTag().startsWith("<DB2Info")) {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.DB2Info"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            } else if (child.getStartTag().startsWith("<IMSInfo")) {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.IMSInfo"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            } else if (child.getStartTag().startsWith("<Messages")) {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.Messages"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            } else if (child.getStartTag().startsWith("<StorageAreas")) {
                System.out.println("Skipping storage areas" + child.getContents().toString());
            } else if (child.getStartTag().startsWith("<LEHeapAnalysis")) {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.LEHeapAnalysis"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            } else {
                ((FAReportBrowser)this.getEditor()).createRichTextFormSection(this.form.getBody(), NLS.getString("SystemWideInfoPage.Unknown"), null, this.removeStorageDisplay(child.getContents()).toString(), false, this.toolkit, this.form);
            }
            ++i;
        }
    }

    private String removeStorageDisplay(StringBuffer contents) {
        if (contents.equals(NLS.getString("n/a"))) {
            return contents.toString();
        }
        StringBuffer newStr = new StringBuffer(1000);
        int ignoreStartIndex = contents.indexOf("STORAGE AREAS");
        if (ignoreStartIndex == -1) {
            return contents.toString();
        }
        newStr.append(contents.substring(0, ignoreStartIndex));
        ignoreStartIndex = contents.indexOf("LANGUAGE ENVIRONMENT HEAP ANALYSIS");
        if (ignoreStartIndex != -1) {
            newStr.append(contents.substring(ignoreStartIndex + "LANGUAGE ENVIRONMENT HEAP ANALYSIS".length(), contents.length()));
        }
        return newStr.toString();
    }

    private void searchRequiredElement(XMSegmentElement root) {
        if (root.getStartTag().startsWith("<SystemWideInfo")) {
            this.systemWideInfoElement = root;
        }
        ArrayList children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            this.searchRequiredElement((XMSegmentElement)children.get(i));
            ++i;
        }
    }
}

