/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.details.actions;

import com.ibm.etools.fa.common.HistoryIndexFileEntry;
import com.ibm.etools.fa.jobs.DownlodReportJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.actions.DetailedViewAction;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;

public class BrowseReportActionForDetailedView
extends DetailedViewAction {
    public void run(IAction action) {
        try {
            HistoryIndexFileEntry entry = (HistoryIndexFileEntry)this.currentSelection.get(this.currentSelection.size() - 1);
            String faultID = entry.DDirHdCFaultID();
            String projPath = String.valueOf(this.detailedView.getSystemAliasName()) + File.separator + entry.getHistoryFileName() + File.separator + faultID + File.separator;
            String fileName = String.valueOf(projPath) + faultID + ".far";
            IFile reportFile = FAPlugin.getDefault().getFile(fileName);
            if (!reportFile.exists()) {
                DownlodReportJob downloadReportJob = new DownlodReportJob(this.detailedView.getSystemAliasName(), entry.getHistoryFileName(), faultID, reportFile, projPath);
                downloadReportJob.runJob();
            } else {
                EditorManagement em = new EditorManagement();
                em.openEditorFromWorkerThread(reportFile, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("BrowseReportActionForDetailedView.ErrMsg"), e, true);
        }
    }
}

