/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary;

import com.ibm.etools.fa.util.FAImages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class TreeElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String label;
    protected TreeElement parent;
    protected ArrayList<TreeElement> children;
    static transient Image defaultImage;

    public TreeElement(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setParent(TreeElement parent) {
        this.parent = parent;
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public void addChild(TreeElement child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public TreeElement addIfNew(TreeElement newChild) {
        List<Object> list = Arrays.asList(this.getChildren());
        int i = 0;
        while (i < list.size()) {
            TreeElement child = (TreeElement)list.get(i);
            if (child.equals(newChild)) {
                return child;
            }
            ++i;
        }
        this.addChild(newChild);
        return newChild;
    }

    public void removeChild(TreeElement child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public void removeAllChildren() {
        this.children = new ArrayList();
    }

    public Object[] getChildren() {
        if (this.hasChildren()) {
            return this.children.toArray();
        }
        return new Object[0];
    }

    public boolean hasChildren() {
        return this.children == null ? false : this.children.size() > 0;
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }

    public Image getImage() {
        if (defaultImage == null) {
            defaultImage = FAImages.getSharedImage("IMG_TOOL_UP");
        }
        return defaultImage;
    }
}

