/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary.actions;

import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.HistoryFilesContainerElement;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.TreeElement;
import com.ibm.etools.fa.view.summary.ViewElement;
import com.ibm.etools.fa.view.summary.ViewsContainerElement;
import com.ibm.etools.fa.view.summary.actions.HistoryFileViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteFromViewAction
extends HistoryFileViewAction {
    public void run(IAction action) {
        try {
            if (this.selectedElement instanceof HistoryFileElement) {
                HistoryFileElement histFileEle = (HistoryFileElement)this.selectedElement;
                FAPlugin.getDefault().stopMonitor(histFileEle.getHistoryFileData().getSystemAliasName(), histFileEle.getHistoryFileData().getHistFileName());
                DetailedHistoryFileView view = this.getDetailedHistoryFileView();
                view.clearTableEntriesIfAppropriate(histFileEle.getHistoryFileData().getSystemAliasName(), this.selectedElement);
                this.removeSelected(this.selectedElement);
                return;
            }
            if (this.selectedElement instanceof HistoryFilesContainerElement) {
                this.stopAllHistFileMonitorForHistFileContainer((HistoryFilesContainerElement)this.selectedElement);
                this.clearDetailedViewForHistFileContainer((HistoryFilesContainerElement)this.selectedElement);
                this.removeSelected(this.selectedElement);
                return;
            }
            if (this.selectedElement instanceof ViewsContainerElement) {
                this.stopAllHistFileMonitorForViewContainer((ViewsContainerElement)this.selectedElement);
                this.clearDetailedViewForViewContainer((ViewsContainerElement)this.selectedElement);
                this.removeSelected(this.selectedElement);
                return;
            }
            if (this.selectedElement instanceof ViewElement) {
                this.stopAllHistFileMonitorForView((ViewElement)this.selectedElement);
                this.clearDetailedViewForView((ViewElement)this.selectedElement);
                this.removeSelected(this.selectedElement);
                return;
            }
            if (this.selectedElement instanceof SystemElement) {
                this.stopAllHistFileMonitorForSystem((SystemElement)this.selectedElement);
                this.clearDetailedViewForSystem((SystemElement)this.selectedElement);
                this.removeSelected(this.selectedElement);
                return;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("DeleteFromViewAction.ErrTitle"), (String)NLS.getString("DeleteFromViewAction.ErrMsg"));
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("DeleteFromViewAction.ErrMsg"), e, true);
        }
    }

    private void removeSelected(TreeElement element) {
        TreeElement parent = element.getParent();
        parent.removeChild(element);
        this.refreshView();
    }

    private void stopAllHistFileMonitorForHistFileContainer(HistoryFilesContainerElement histFilesContainerElement) {
        Object[] children = histFilesContainerElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof HistoryFileElement) {
                HistoryFileElement histFileEle = (HistoryFileElement)children[i];
                FAPlugin.getDefault().stopMonitor(histFileEle.getHistoryFileData().getSystemAliasName(), histFileEle.getHistoryFileData().getHistFileName());
            }
            ++i;
        }
    }

    private void clearDetailedViewForHistFileContainer(HistoryFilesContainerElement histFilesContainerElement) throws Exception {
        Object[] children = histFilesContainerElement.getChildren();
        int i = 0;
        while (i < children.length) {
            HistoryFileElement histFileEle = (HistoryFileElement)children[i];
            DetailedHistoryFileView view = this.getDetailedHistoryFileView();
            view.clearTableEntriesIfAppropriate(histFileEle.getHistoryFileData().getSystemAliasName(), histFileEle);
            ++i;
        }
    }

    private void stopAllHistFileMonitorForView(ViewElement viewElement) {
        Object[] children = viewElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof HistoryFileElement) {
                HistoryFileElement histFileEle = (HistoryFileElement)children[i];
                FAPlugin.getDefault().stopMonitor(histFileEle.getHistoryFileData().getSystemAliasName(), histFileEle.getHistoryFileData().getHistFileName());
            }
            ++i;
        }
    }

    private void clearDetailedViewForView(ViewElement viewElement) throws Exception {
        DetailedHistoryFileView view = this.getDetailedHistoryFileView();
        ViewsContainerElement container = (ViewsContainerElement)viewElement.getParent();
        SystemElement systemElement = (SystemElement)container.getParent();
        view.clearTableEntriesIfAppropriate(systemElement.getLabel(), viewElement);
    }

    private void stopAllHistFileMonitorForViewContainer(ViewsContainerElement viewContainerElement) {
        Object[] children = viewContainerElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof ViewElement) {
                this.stopAllHistFileMonitorForView((ViewElement)children[i]);
            }
            ++i;
        }
    }

    private void clearDetailedViewForViewContainer(ViewsContainerElement viewContainerElement) throws Exception {
        Object[] children = viewContainerElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof ViewElement) {
                this.clearDetailedViewForView((ViewElement)children[i]);
            }
            ++i;
        }
    }

    private void stopAllHistFileMonitorForSystem(SystemElement systemElement) {
        Object[] children = systemElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof ViewsContainerElement) {
                this.stopAllHistFileMonitorForViewContainer((ViewsContainerElement)children[i]);
            } else if (children[i] instanceof HistoryFilesContainerElement) {
                this.stopAllHistFileMonitorForHistFileContainer((HistoryFilesContainerElement)children[i]);
            } else {
                System.out.println("Not sure about " + ((TreeElement)children[i]).getLabel());
            }
            ++i;
        }
    }

    private void clearDetailedViewForSystem(SystemElement systemElement) throws Exception {
        Object[] children = systemElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof ViewsContainerElement) {
                this.clearDetailedViewForViewContainer((ViewsContainerElement)children[i]);
            } else if (children[i] instanceof HistoryFilesContainerElement) {
                this.clearDetailedViewForHistFileContainer((HistoryFilesContainerElement)children[i]);
            }
            ++i;
        }
    }
}

