/* Common assembler subroutine prototypes ****************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2005. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/*******************************************************************************
/* Documentation of the functions in IDICASUB.ASSEMBLE and           */
/* IDICADYN.ASSEMBLE are done here with their declarations.          */
/*********************************************************************/
/*|:h3.IDICHSUB.H                                                    */
 
#include <stdarg.h>
 
/*|:p.                                                                        */
/*|.fo off                                                                    */
/*|EnqHistOpenWrite() - Enqueue on history file member prior to write.        */
/*|                                                                           */
/*|Arguments:                                                                 */
/*|histdsn         - History file data set name.                              */
/*|member          - History file member name.                                */
/*|.fo on                                                                     */
/*|:xmp.*/
int EnqHistOpenWrite(char *histdsn, char *member);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|.fo off                                                                    */
/*|IDICENQT() - Enqueue on history file member with timeout prior to write.   */
/*|                                                                           */
/*|Arguments:                                                                 */
/*|histdsn         - History file data set name.                              */
/*|member          - History file member name.                                */
/*|.fo on                                                                     */
/*|:xmp.*/
int IDICENQT(char *qname, char *rname, int rnamel, int sec);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|.fo off                                                                    */
/*|HistOpenWrite() - Open history file member for write.                      */
/*|                                                                           */
/*|Arguments:                                                                 */
/*|histdsn         - History file data set name.                              */
/*|member          - History file member name.                                */
/*|The return char* is OK if positive and passed on to the DDfwrite()         */
/*|is zero the open failed, if negative the open abended and the              */
/*|middle two bytes contain the abend code, low order byte the return code.   */
/*|.fo on                                                                     */
/*|:xmp.*/
char *HistOpenWrite(char *histdsn, char *member);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|.fo off                                                                    */
/*|HistWrite() - Write history file member records.                           */
/*|                                                                           */
/*|Arguments:                                                                 */
/*|segpointer      - History file data segment pointer.                       */
/*|pDDfwHist       - the pointer returned from HistOpenWrite.                 */
/*|Returns the length written, or zero if an error has occurred.              */
/*|.fo on                                                                     */
/*|:xmp.*/
int HistWrite(struct DDIR_SHDR *segpointer, char *pDDfwHist);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|.fo off                                                                    */
/*|HistCloseWrite() - Close history file member after write.                  */
/*|returnes 0 for OK, otherwise the ABXERROR word from the DDfopen/write/close*/
/*|                                                                           */
/*|Arguments:                                                                 */
/*|fp              - wa pointer returned by HistOpenWrite().                  */
/*|histdsn         - History file data set name.                              */
/*|member          - History file member name.                                */
/*|.fo on                                                                     */
/*|:xmp.*/
int HistCloseWrite(char *fp, char *histdsn, char *member);
/*|:exmp.*/
 
/**********************************************************************/
/*|:p.                                                                */
/*|.fo off                                                            */
/*|PDSMemberDelete() - Delete one or more members from a PDS(e)       */
/*|Returns zero if OK or 4 if one or more members failed to delete.   */
/*|Note: we use share enqueue because we do not c-runtime exclusive.  */
/*|Arguments:                                                         */
/*|pDSN            - PDS Data Set Name                                */
/*|pMembers        - Space (one or more) delimited null terminated.   */
/**********************************************************************/
/*|.fo on                                                             */
/*|:xmp.*/
int PDSMemberDelete(char *pDSN, char *pMembers) ;
/*|:exmp.*/
 
 
/*|:p.printf-style WTO                                                        */
/*|:xmp.*/
int wtoprtf(char *formatstr, ...);
/*|:exmp.*/
 
/*|:p.printf-style WTO (var-arg)                                              */
/*|:xmp.*/
int vwtoprtf(char *formatstr, va_list arg_ptr);
/*|:exmp.*/
 
/*|:p.Replacement of the C run-time library function 'toupper' that can       */
/*|be used in the SPC environment also.                                       */
/*|:nt.This function does not have all the 'smarts' of the real               */
/*|toupper function, such as locale sensitivity.                              */
/*|:ent.*/
/*|:xmp.*/
#pragma map(spcupper,"SPCUPPER")
int spcupper(int c);
/*|:exmp.*/
 
/*|:p.Replacement of the C run-time library function 'isprint' that can       */
/*|be used in the SPC environment also.                                       */
/*|:nt.This function does not have all the 'smarts' of the real               */
/*|isprint function, such as locale sensitivity.                              */
/*|:ent.*/
/*|:xmp.*/
int spcisprt(int c);
/*|:exmp.*/
 
/*|:p.Product version/release/modification/PTF level                          */
/*|:xmp.*/
#pragma map(prodver,"PRODVER")
char *prodver(void);
/*|:exmp.*/
 
/*|:p.Allocate logical PARMLIB concatenation                                  */
/*|:xmp.*/
#pragma linkage(idicprma,OS)
#pragma     map(idicprma,"IDICPRMA")
int idicprma(char *ddname, char *caller_name, int *reason_code);
/*|:exmp.*/
 
/*|:p.Free logical PARMLIB concatenation                                      */
/*|:xmp.*/
#pragma linkage(idicprmf,OS)
#pragma     map(idicprmf,"IDICPRMF")
int idicprmf(char *ddname, char *caller_name, int *reason_code);
/*|:exmp.*/
 
/*|:p.Read member from logical PARMLIB concatenation                          */
/*|:xmp.*/
#pragma linkage(idicprmr,OS)
#pragma     map(idicprmr,"IDICPRMR")
int idicprmr(char *ddname, char *member, void *buffer,
         char *caller_name, int *reason_code);
/*|:exmp.*/
 
/*|:p.List all data sets in the logical PARMLIB concatenation                 */
/*|:xmp.*/
#pragma linkage(idicprml,OS)
#pragma     map(idicprml,"IDICPRML")
int idicprml(void *buffer, char *caller_name,
         int *reason_code);
/*|:exmp.*/
 
/*|:p.Allocate temporary partitioned data set and return DDname               */
/*|:xmp.*/
#pragma linkage(pdsretdd,OS)
#pragma     map(pdsretdd,"PDSRETDD")
int pdsretdd(char *ddname, char *dsname, char *recfm, int lrecl,
             int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate temporary partitioned data set to specified DDname             */
/*|:xmp.*/
#pragma linkage(pdsalloc,OS)
int pdsalloc(char *ddname, char *dsname, char *recfm, int lrecl,
             int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate Data Set to DDname                                             */
/*|:xmp.*/
#pragma linkage(idicdsna,OS)
#pragma     map(idicdsna,"IDICDSNA")
int idicdsna(char *ddname, char *dsname, int *error_code,
             int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate PDS Member                                                     */
/*|:xmp.*/
#pragma linkage(idicmbra,OS)
#pragma     map(idicmbra,"IDICMBRA")
int idicmbra(char *ddname, char *dsname, char *member, int release,
         int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate Data Set and Return DDname                                     */
/*|:xmp.*/
#pragma linkage(idicdsnr,OS)
#pragma     map(idicdsnr,"IDICDSNR")
int idicdsnr(char *ddname, char *dsname, char *member, int *error_code,
             int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate a SYSOUT=* JES Data Set to DDname */
/*|:xmp.*/
#pragma linkage(idicdout,OS)
#pragma     map(idicdout,"IDICDOUT")
int idicdout(char *ddname, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate a SYSOUT=<class> JES Data Set to DDname */
/*|:xmp.*/
int IDICCOUT(char *ddname, char *class, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Get SYSOUT class for a DDname */
/*|:xmp.*/
int GETSOUTC(char *ddname);
/*|:exmp.*/
 
/*|:p.Check for the existance of a member in a PDS */
/*|:xmp.*/
#pragma linkage(checkmbr,OS)
#pragma     map(checkmbr,"CHECKMBR")
int checkmbr(char *ddname, char *member, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Allocate a DDname to DUMMY */
/*|:xmp.*/
#pragma linkage(idicdumy,OS)
#pragma     map(idicdumy,"IDICDUMY")
int idicdumy(char *ddname,int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Inquire on Data Set and Return DDname                                   */
/*|:xmp.*/
#pragma linkage(idicdsni,OS)
int idicdsni(char *ddname, char *dsname, char *volid,
             int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Inquire on DDname                                                       */
/*|:xmp.*/
#pragma linkage(idicdsnd,OS)
#pragma     map(idicdsnd,"IDICDSND")
int idicdsnd(char *ddname, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Deconcatenate DDname                                                    */
/*|:xmp.*/
#pragma linkage(idicdsnu,OS)
#pragma     map(idicdsnu,"IDICDSNU")
int idicdsnu(char *ddname, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Inquire on DDname returning DSN or PATH and other info                  */
/*|:xmp.*/
#pragma linkage(idicdsnx,OS)
#pragma     map(idicdsnx,"IDICDSNX")
int idicdsnx(char *ddname, char *DSN, char *Path, char *member, char *dsorg,
             char *volser, int *error_code,int *info_code);
/*|:exmp.*/
 
/*|:p.Concatenate Data Sets via DDnames                                       */
/*|:xmp.*/
#pragma linkage(idicdsnc,OS)
#pragma     map(idicdsnc,"IDICDSNC")
int idicdsnc(char *to_dd, char *from_dd, int *error_code,
             int *info_code);
/*|:exmp.*/
 
/*|:p.Free (Deallocate) Data Set via DDname                                   */
/*|:xmp.*/
#pragma linkage(idicdsnf,OS)
#pragma     map(idicdsnf,"IDICDSNF")
int idicdsnf(char *ddname, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Serialize Resource (ENQ)                                                */
/*|:xmp.*/
#pragma map(idicenq,"IDICENQ")
int idicenq(char *qname, char *rname, int rnamel, enum ENQDEQ_SCOPE, enum ENQDEQ_REQUEST);
/*|:exmp.*/
 
/*|:p.Release Serialized Resource (DEQ)                                       */
/*|:xmp.*/
#pragma map(idicdeq,"IDICDEQ")
int idicdeq(char *qname, char *rname, int rnamel, enum ENQDEQ_SCOPE);
/*|:exmp.*/
 
/*|:p.Open Data Set via DDname (for read) */
/*|:xmp.*/
#pragma linkage(DDfopenr,OS)
#pragma     map(DDfopenr,"DDFOPENR")
char *DDfopenr(char *ddname);
/*|:exmp.*/
 
/*|:p.Read a record from a DDfopenr data set */
/*|:xmp.*/
#pragma linkage(DDfread,OS)
#pragma     map(DDfread,"DDFREAD")
int DDfread(char *buffer, char *dcb_ptr);
/*|:exmp.*/
 
/*|:p.Test end of file on a DDfopenr data set */
/*|:xmp.*/
#pragma linkage(DDfeof,OS)
#pragma     map(DDfeof,"DDFEOF")
int DDfeof(char *dcb_ptr);
/*|:exmp.*/
 
/*|:p.Close a DDfopenr data set */
/*|:xmp.*/
#pragma linkage(DDfclose,OS)
#pragma     map(DDfclose,"DDFCLOSE")
int DDfclose(char *dcb_ptr);
/*|:exmp.*/
 
/*|:p.Close a DDfopenw data set */
/*|:xmp.*/
#pragma linkage(DDfclosw,OS)
#pragma     map(DDfclosw,"DDFCLOSW")
int DDfclosw(char *dcb_ptr);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|DDfopenw() opens a datset via DDname for write.                            */
/*|:xmp.*/
#pragma linkage(DDfopenw,OS)
#pragma     map(DDfopenw,"DDFOPENW")
char *DDfopenw(char *ddname);
/*|:exmp.*/
 
/*|:p.Close a DDfopens STOW data set */
/*|:xmp.*/
#pragma linkage(DDfcloss,OS)
#pragma     map(DDfcloss,"DDFCLOSS")
int DDfcloss(char *dcb_ptr);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|DDfopens() opens a STOW datset via DDname for member delete.               */
/*|:xmp.*/
#pragma linkage(DDfopens,OS)
#pragma     map(DDfopens,"DDFOPENS")
char *DDfopens(char *ddname);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|DDfwrite() writes a record to a DDfopenw data set.                         */
/*|:xmp.*/
#pragma linkage(DDfwrite,OS)
#pragma     map(DDfwrite,"DDFWRITE")
int DDfwrite(char *buffer, char *wa_ptr);
/*|:exmp.*/
 
/*|:p.                                                                        */
/*|DDfMdelt() deletes a member of a DDfopenw data set.                        */
/*|:xmp.*/
#pragma linkage(DDfMdelt,OS)
#pragma     map(DDfMdelt,"DDFMDELT")
int DDfMdelt(char *buffer, char *wa_ptr);
/*|:exmp.*/
 
/*|:p.Check if a Dataset is migrated                                          */
/*|:xmp.*/
#pragma linkage(migcheck,OS)
#pragma     map(migcheck,"MIGCHECK")
int migcheck(char *dsname);
/*|:exmp.*/
 
/*|:p.Convert TOD clock value to character format timestamp          */
/*|:p.Input is a 64-bit STCK time-of-day value.                      */
/*|:p.Output is a 21-character string in the format:                 */
/*|:xmp.                                                             */
/*|YYYYMMDDHHMMSSthmiju0                                             */
/*|:exmp.                                                            */
/*|:p.(Last char is a C null).                                       */
/*|:p.Output buffer is mapped by TOD2CHAR_TS.                        */
/*|:p.Returns the rc from STCKCONV (0 = success).                    */
/*|:xmp.*/
#pragma linkage(Tod2Char,OS)
#pragma     map(Tod2Char,"TOD2CHAR")
int Tod2Char(void *todbuf, void *timestamp);
/*|:exmp.*/
 
/*|:p.Get TOD clock adjusted for local time */
/*|:xmp.*/
#pragma linkage(LoclTime,OS)
#pragma     map(LoclTime,"LOCLTIME")
void LoclTime(void *todbuf, int RetLength);
/*|:exmp.*/
 
/*|:p.Get data set name associated with SVA token from TIOT entry */
/*|:xmp.*/
#pragma linkage(TIOTDSN,OS)
int TIOTDSN(char *token, char *dsn);
/*|:exmp.*/
 
/*|:p.General data set allocation using SVC 99                                */
/*|:xmp.*/
#pragma linkage(dsnalloc,os)
#pragma     map(dsnalloc,"DSNALLOC")
int dsnalloc(char *ddname, char *dsname, char *recfm,
         int lrecl, int prim, int sec, int dir, char *status,
         char *ndisp, char *unit, char *mbr, char *sysout,
         char *pgmname, char *dest, int dummy, int close, char *retdd,
         int release, int *error_code, int *info_code);
/*|:exmp.*/
 
/*|:p.Check for READ access to a non-VSAM data set                            */
/*|Returns the SAF return code in R15 and RACF return and reason code in      */
/*|racf_rc and racf_reason respectively.                                      */
/*|:xmp.*/
#pragma linkage(CHKRDACC,OS)
int CHKRDACC(char *dsn, char *volser, int *racf_rc, int *racf_reason);
/*|:exmp.*/
 
/*|:p.Text string DBCS mapping                                                */
/*|:xmp.*/
int DBCSMAP(int *i_state, char *pstr, char *pbuf, int len);
/*|:exmp.*/
 
