/* User exit mappings ************************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006.  All rights reserved.       */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
struct uexitcom;
struct ENV;
struct CTL;
struct REP;
struct XPL;
struct LST;
struct NFY;
struct EPC;
struct UTL;
struct UFM;
struct argtable_entry;
struct compgmtb_header;
struct compgmtb_entry;
struct dsib_info;
struct efpl;
struct envblock;
struct evalblock;
struct execblk;
struct irxexte;
struct fpckdir_header;
struct fpckdir_entry;
struct instblk;
struct instblk_entry;
struct statement;
struct modnamet;
struct packtb_header;
struct packtb_entry;
struct parmblock;
struct shvblock;
struct subcomtb_header;
struct subcomtb_entry;
struct workblok_ext;
typedef struct uexitcom        UEXITCOM;
typedef struct ENV             ENV;
typedef struct CTL             CTL;
typedef struct REP             REP;
typedef struct XPL             XPL;
typedef struct LST             LST;
typedef struct NFY             NFY;
typedef struct EPC             EPC;
typedef struct UTL             UTL;
typedef struct UFM             UFM;
typedef struct argtable_entry  ARGTABLE_ENTRY;
typedef struct compgmtb_header COMPGMTB_HEADER;
typedef struct compgmtb_entry  COMPGMTB_ENTRY;
typedef struct dsib_info       DSIB_INFO;
typedef struct efpl            EFPL;
typedef struct envblock        ENVBLOCK;
typedef struct evalblock       EVALBLOCK;
typedef struct execblk         EXECBLK;
typedef struct irxexte         IRXEXTE;
typedef struct fpckdir_header  FPCKDIR_HEADER;
typedef struct fpckdir_entry   FPCKDIR_ENTRY;
typedef struct instblk         INSTBLK;
typedef struct instblk_entry   INSTBLK_ENTRY;
typedef struct statement       STATEMENT;
typedef struct modnamet        MODNAMET;
typedef struct packtb_header   PACKTB_HEADER;
typedef struct packtb_entry    PACKTB_ENTRY;
typedef struct parmblock       PARMBLOCK;
typedef struct shvblock        SHVBLOCK;
typedef struct subcomtb_header SUBCOMTB_HEADER;
typedef struct subcomtb_entry  SUBCOMTB_ENTRY;
typedef struct workblok_ext    WORKBLOK_EXT;
 
struct EVENT_DETAILS;
typedef struct EVENT_DETAILS EVENT_DETAILS;
struct EVENT_DETAILS {
  int event_no;
  int next_event_no;
  int previous_event_no;
  char *szEventType;
  char szSrcLoc[64];
  char *szModNm;
  int ModAddr;
  int ModLen;
  char *szPgmNm;
  int PgmAddr;
  int PgmLen;
  char *szEPNm;
  int EPAddr;
  char *szFrom;
  int instruction_address;
  unsigned int pof : 1;
  int amode;
  int psw_ok     : 1,
      gpregs_ok  : 1,
      aregs_ok   : 1,
      num_fpregs : 2;
  int psw[2];
  int gpregs[16];
  int aregs[16];
  int fpregs[32];
};
 
/* This structure is pointed to by uexitcom.wa_ptr during the execution of a
   Formatting user exit */
struct UFM_WRK;
typedef struct UFM_WRK UFM_WRK;
struct UFM_WRK {
  void *ppToken;
  char *execname;  /* Name of REXX exec to be run from command line of interactive reanalysis report */
};
 
struct UFM_FREE;
typedef struct UFM_FREE UFM_FREE;
struct UFM_FREE {
  int free_max;
  int free_cur;
  int *free_arr;
};
 
#define VALID_PARMBLOCK_ID      "IRXPARMS"
#define VALID_PARMBLOCK_VERSION "0200"
 
#define XTYPE_DYNAMIC_EXEC          "DYNEXEC"
#define XTYPE_COMPILER_LISTING_READ "LISTING"
#define XTYPE_BATCH_REPORT          "REPORT"
#define XTYPE_END_PROCESSING        "END"
#define XTYPE_ANALYSIS_CONTROL      "CONTROL"
#define XTYPE_NOTIFICATION          "NOTIFY"
#define XTYPE_MESSAGE_EXPLANATION   "MSGXPL"
#define XTYPE_IDIUTIL_IMPORT        "IMPORT"
#define XTYPE_IDIUTIL_DELETE        "DELETE"
#define XTYPE_IDIUTIL_LISTHF        "LISTHF"
#define XTYPE_REGISTRATION_CONTROL  "REGCNTL"
#define XTYPE_REGISTRATION_NOTIFY   "REGNFY"
#define XTYPE_REFRESH_END_PROC      "REFEND"
#define XTYPE_FORMATTING            "FORMAT"
 
#define XTYPE_CHAR_COMPILER_LISTING_READ 'L'
#define XTYPE_CHAR_BATCH_REPORT          'R'
#define XTYPE_CHAR_END_PROCESSING        'E'
#define XTYPE_CHAR_ANALYSIS_CONTROL      'C'
#define XTYPE_CHAR_NOTIFICATION          'N'
#define XTYPE_CHAR_MESSAGE_EXPLANATION   'M'
#define XTYPE_CHAR_IDIUTIL_IMPORT        'I'
#define XTYPE_CHAR_IDIUTIL_DELETE        'D'
#define XTYPE_CHAR_IDIUTIL_LISTHF        'H'
#define XTYPE_CHAR_REGISTRATION_CONTROL  'X'
#define XTYPE_CHAR_REGISTRATION_NOTIFY   'Y'
#define XTYPE_CHAR_REFRESH_END_PROC      'Z'
#define XTYPE_CHAR_FORMATTING            'F'
 
#define TRACELBLSZ 36
#define TRACELRECL 132
#define UFMLRECL 1024
 
#define Check_ENVBLOCK(uexitcom_ptr) \
  (Check_ENVBLOCK)(uexitcom_ptr, __FILE__, __LINE__)
 
int rexx_init(void);
int rexx_run(char *execname);
int rexx_term(void);
int CALLEXIT(char *exittype, void *parmptr, char *ret_xname, void *pHD);
int UserExit(char *exittype, void *parmptr, char *ret_xname, void *pHD);
int IsREXXexit(char *exittype);
#pragma map(add_dynstmt,"ADD@DYNS")
void add_dynstmt(UEXITCOM *uexitcom_ptr, char *stmt);
#pragma map(run_dynexec,"RUN@DYNE")
int run_dynexec(UEXITCOM *uexitcom_ptr);
#pragma map(Copy_ENVBLOCK, "CPENVBLK")
void Copy_ENVBLOCK(UEXITCOM *uexitcom_ptr);
#pragma map(Check_ENVBLOCK, "CKENVBLK")
void (Check_ENVBLOCK)(UEXITCOM *uexitcom_ptr, char *file, int line);
 
#pragma map(xtrace_msg,"XTRACE@M")
void xtrace_msg(ENVBLOCK *envblock_ptr, int indent, char *text);
 
typedef void exit_T(ENV *, void *);
#pragma linkage(exit_T,OS)
 
typedef int F_IRXEXCOM(char *,          /* "IRXEXCOM" */
                       int *,           /* 0 */
                       int *,           /* 0 */
                       SHVBLOCK *,      /* address of first shared variable (request) block */
                       ENVBLOCK **);    /* address of environment block */
#pragma linkage (F_IRXEXCOM, OS)
 
typedef int F_IRXEXEC(EXECBLK **,
                      ARGTABLE_ENTRY **,
                      int *,
                      INSTBLK **,
                      void *,
                      EVALBLOCK **,
                      void *,
                      void *,
                      ENVBLOCK **,
                      int *);
#pragma linkage (F_IRXEXEC, OS)
 
int CRXLE(F_IRXEXEC *ep_irxexec,
          EXECBLK **,
          ARGTABLE_ENTRY **,
          int *,
          INSTBLK **,
          void *,
          EVALBLOCK **,
          void *,
          void *,
          ENVBLOCK **,
          int *);
#pragma linkage(CRXLE, OS)
 
typedef int F_IDICUXWR(UEXITCOM *);
#pragma linkage (F_IDICUXWR, OS)
 
int SPCFETCH(char *);
#pragma linkage (SPCFETCH, OS)
 
int SPCREL(char *);
#pragma linkage (SPCREL, OS)
 
#define VAR_BEGIN(varix) { \
  varix = 0; \
  maxvars = 10; \
  pshvb = (SHVBLOCK *)malloc(sizeof(SHVBLOCK)*maxvars); \
}
 
#define VAR_STORE(varix, varnm, varptr) {                                 \
  if (varix == maxvars) {                                                 \
    maxvars += 10;                                                        \
    pshvb = realloc(pshvb, sizeof(SHVBLOCK)*maxvars);                     \
  }                                                                       \
  pshvb[varix].shvcode = 'S';                                             \
  pshvb[varix].shvnama = varnm;                                           \
  pshvb[varix].shvnaml = strlen(varnm);                                   \
  pshvb[varix].shvvala = &varptr;                                         \
  pshvb[varix].shvvall = sizeof(varptr);                                  \
  ++varix;                                                                \
}
 
/* Same as VAR_STORE, but with trailing blanks stripped off */
#define VAR_STORE_STRIP(varix, varnm, varptr) {                           \
  int z;                                                                  \
  if (varix == maxvars) {                                                 \
    maxvars += 10;                                                        \
    pshvb = realloc(pshvb, sizeof(SHVBLOCK)*maxvars);                     \
  }                                                                       \
  pshvb[varix].shvcode = 'S';                                             \
  pshvb[varix].shvnama = varnm;                                           \
  pshvb[varix].shvnaml = strlen(varnm);                                   \
  pshvb[varix].shvvala = &varptr;                                         \
  for (z = sizeof(varptr) - 1; z >= 0 && (varptr)[z] == ' '; --z);        \
  pshvb[varix].shvvall = ++z;                                             \
  ++varix;                                                                \
}
 
/* This is a special version of VAR_STORE to handle the situation where a field
   might contain a FLDBUFINFO structure. */
#define VAR_STORE_BUF(varix, varnm, varptr) {                             \
  int z;                                                                  \
  if (varix == maxvars) {                                                 \
    maxvars += 10;                                                        \
    pshvb = realloc(pshvb, sizeof(SHVBLOCK)*maxvars);                     \
  }                                                                       \
  pshvb[varix].shvcode = 'S';                                             \
  pshvb[varix].shvnama = varnm;                                           \
  pshvb[varix].shvnaml = strlen(varnm);                                   \
  if (*varptr == 0xff) {                                                  \
    pshvb[varix].shvvala = ((FLDBUFINFO *)varptr)->buf_addr;              \
    pshvb[varix].shvvall = ((FLDBUFINFO *)varptr)->buf_len;               \
    for (z = ((FLDBUFINFO *)varptr)->buf_len - 1;                         \
         z >= 0 && ((FLDBUFINFO *)varptr)->buf_addr[z] == ' ';            \
         --z);                                                            \
    pshvb[varix].shvvall = ++z;                                           \
  }                                                                       \
  else {                                                                  \
    pshvb[varix].shvvala = &varptr;                                       \
    for (z = sizeof(varptr) - 1; z >= 0 && (varptr)[z] == ' '; --z);      \
    pshvb[varix].shvvall = ++z;                                           \
  }                                                                       \
  ++varix;                                                                \
}
 
#define VAR_FETCH(varix, varnm, varptr) {                                 \
  memset((char *)&varptr, ' ', sizeof(varptr));                           \
  if (varix == maxvars) {                                                 \
    maxvars += 10;                                                        \
    pshvb = realloc(pshvb, sizeof(SHVBLOCK)*maxvars);                     \
  }                                                                       \
  pshvb[varix].shvcode = 'F';                                             \
  pshvb[varix].shvnama = varnm;                                           \
  pshvb[varix].shvnaml = strlen(varnm);                                   \
  pshvb[varix].shvvala = &varptr;                                         \
  pshvb[varix].shvbufl = sizeof(varptr);                                  \
  ++varix;                                                                \
}
 
/* This is a special version of VAR_FETCH to handle the situation where a field
   might contain a FLDBUFINFO structure. */
#define VAR_FETCH_BUF(varix, varnm, varptr) {                          \
  SHVBLOCK *pshvb_buf;                                                 \
  pshvb_buf = (SHVBLOCK *)malloc(sizeof(SHVBLOCK));                    \
  pshvb_buf->shvcode = 'F';                                            \
  pshvb_buf->shvnama = varnm;                                          \
  pshvb_buf->shvnaml = strlen(varnm);                                  \
  if (*varptr == 0xff) {                                               \
    pshvb_buf->shvvala = ((FLDBUFINFO *)varptr)->buf_addr;             \
    pshvb_buf->shvbufl = ((FLDBUFINFO *)varptr)->buf_len;              \
  }                                                                    \
  else {                                                               \
    pshvb_buf->shvvala = &varptr;                                      \
    pshvb_buf->shvbufl = sizeof(varptr);                               \
  }                                                                    \
  memset(pshvb_buf->shvvala, ' ', pshvb_buf->shvbufl);                 \
  pshvb_buf->shvnext = 0;                                              \
  rc = uexitcom_ptr->ep_irxexcom("IRXEXCOM",                           \
                   &zero,                                              \
                   &zero,                                              \
                   pshvb_buf,                                          \
                   &penvblock                                          \
                   );                                                  \
  if (rc) {                                                            \
    dprintf("ERROR: IRXEXCOM rc=%d\n", rc);                            \
  }                                                                    \
  if (pshvb_buf->shvret == 0x04) {  /* Value truncated? (SHVTRUNC) */  \
    FLDBUFINFO *pFBI;                                                  \
    pFBI = (FLDBUFINFO *)varptr;                                       \
    pFBI->flag1 = 0xff;                                                \
    pFBI->flag2 = 0x80;  /* Indicate FREEMAIN necessary */             \
    pFBI->buf_addr = (char *)IDIGETM(pshvb_buf->shvvall);              \
    if (pFBI->buf_addr) {                                              \
/*  dprintf("GETMAIN of %d byte buffer at address %8.8X ok\n", pshvb_buf->shvvall, (int)pFBI->buf_addr); */ \
      pFBI->buf_len = pshvb_buf->shvvall;                              \
      memset(pFBI->buf_addr, ' ', pFBI->buf_len);                      \
      if (varix == maxvars) {                                          \
        maxvars += 10;                                                 \
        pshvb = realloc(pshvb, sizeof(SHVBLOCK)*maxvars);              \
      }                                                                \
      pshvb[varix].shvcode = 'F';                                      \
      pshvb[varix].shvnama = varnm;                                    \
      pshvb[varix].shvnaml = strlen(varnm);                            \
      pshvb[varix].shvvala = pFBI->buf_addr;                           \
      pshvb[varix].shvbufl = pFBI->buf_len;                            \
      ++varix;                                                         \
    }                                                                  \
  }                                                                    \
  else if (pshvb_buf->shvvall < pshvb_buf->shvbufl)                    \
    ((char *)(pshvb_buf->shvvala))[pshvb_buf->shvvall] = '\0';         \
  free(pshvb_buf);                                                     \
}
 
#define VAR_END(varix, action) {                                                                  \
  if (varix) {                                                                                    \
    int z;                                                                                        \
    char *zzp;                                                                                    \
    for (z = 0; z < varix-1; ++z)                                                                 \
      pshvb[z].shvnext = &pshvb[z+1];                                                             \
    pshvb[z].shvnext = NULL;                                                                      \
    Check_ENVBLOCK(uexitcom_ptr);                                                                 \
    rc = uexitcom_ptr->ep_irxexcom("IRXEXCOM",                                                    \
                     &zero,                                                                       \
                     &zero,                                                                       \
                     pshvb,                                                                       \
                     &penvblock                                                                   \
                     );                                                                           \
    Copy_ENVBLOCK(uexitcom_ptr);                                                                  \
    if (rc) {                                                                                     \
      dprintf("ERROR: IRXEXCOM rc=%d\n", rc);                                                     \
    }                                                                                             \
    for (z = 0; z < varix; ++z) {                                                                 \
      if (pshvb[z].shvret) {                                                                      \
        if (strcmp(action, "FETCH") == 0 ||                                                       \
            (strcmp(action, "STORE") == 0 && pshvb[z].shvret > 1)) {                              \
          dprintf("ERROR: %s %s rc=%X\n", action, pshvb[z].shvnama, pshvb[z].shvret);             \
        }                                                                                         \
      }                                                                                           \
      /* If the returned value is shorter than the field width, indicate                          \
         truncation by inserting a null (0x00) character */                                       \
      zzp = strchr((char *)(pshvb[z].shvnama), '.');                                              \
      if (strcmp(action, "FETCH") == 0 && pshvb[z].shvvall < pshvb[z].shvbufl && zzp &&           \
          strcmp(zzp, ".DATA_BUFFER") != 0 &&                                                     \
          strcmp(zzp, ".USER_1") != 0 &&                                                          \
          strcmp(zzp, ".USER_2") != 0)                                                            \
        ((char *)(pshvb[z].shvvala))[pshvb[z].shvvall] = '\0';                                    \
    }                                                                                             \
    free(pshvb);                                                                                  \
  }                                                                                               \
}
 
#define VALIDATE_CHAR1FLD(wrkbuf, fldptr, fldname, okvals, dflt) {                \
  char tmpval[6];                                                                 \
  if (fldptr == '\0' || !strchr(okvals, fldptr)) {                                \
    if (opts.exittrace) {                                                         \
      if (isprint(fldptr))                                                        \
        sprintf(tmpval, "'%c'", fldptr);                                          \
      else                                                                        \
        sprintf(tmpval, "X'%2.2X'", fldptr);                                      \
      sprintf(wrkbuf, "WARNING: Field %s was incorrectly set to %s - "            \
              "it will be changed to '%c'.", fldname, tmpval, dflt);              \
      xtrace_msg(uexitcom.c_envblock, 2, wrkbuf);                                 \
    }                                                                             \
    fldptr = dflt;                                                                \
  }                                                                               \
  fldptr = toupper(fldptr);                                                       \
}
 
/* FA user exit environment information structure                        */
/* $$SYNC keep these structures up to UTL in sync with IDISXPLA XSAMPLES */
/* $$SYNC keep these structures up to UTL in sync with IDISXPLC XSAMPLES */
/* $$SYNC keep these structures up to UTL in sync with IDISXPLP XSAMPLES */
#define ENV_VERSION 3
struct ENV {
  char VERSION[4];                  /* (R) ENV structure version (ENV_VERSION) */
  char EXIT_CALL_TYPE;              /* (R) Exit call type:              */
                                    /*       C = Analysis Control       */
                                    /*       L = Compiler Listing Read  */
                                    /*       R = Batch Report tailoring */
                                    /*       M = Message and Abend Code Explanation */
                                    /*       E = End Processing         */
                                    /*       N = Notification           */
                                    /*       I = IDIUTIL Import         */
                                    /*       D = IDIUTIL Delete         */
                                    /*       H = IDIUTIL ListHf         */
                                    /*       F = Formatting             */
  char FAULT_ID[8];                 /* (R) Fault ID */
  char ABEND_DATE[10];              /* (R) Date of abend in the format YYYY/MM/DD */
  char ABEND_TIME[8];               /* (R) Time of abend in the format HH:MM:SS */
  char REALTIME;                    /* (R) Real-time execution (Y/N) */
  char SYSTEM_NAME[8];              /* (R) System name */
  char JOB_NAME[8];                 /* (R) Job/started task name */
  char EXEC_PGM_NAME[8];            /* (R) EXEC program name */
  char USER_ID[8];                  /* (R) User ID */
  char Reserved_1[4];               /* (-) Reserved for future use */
  char ABEND_MODULE_NAME[8];        /* (R) ABEND module name */
  char CICS_TRANSACTION_ID[4];      /* (R) CICS transaction ID */
  char CICS_TASK_NUMBER[5];         /* (R) CICS task number */
  char JOB_TYPE;                    /* (R) Batch job (B), started task (S), TSO (T), or CICS (C) */
  char JOB_CLASS;                   /* (R) Job execution class */
  char ACCOUNTING_FIELDS[3];        /* (R) Number of job accounting fields (nnn) (from JCT ACTJNFLD) */
  char ACCOUNTING_INFO[144];        /* (R) Job accounting information (from JCT ACTACCNT) */
  char USER_1[4];                   /* (W) User field 1 */
  char USER_2[4];                   /* (W) User field 2 */
  char LOCK_FLAG;                   /* (W) Fault entry lock flag */
  char LOOPPROTECTION_OPT;          /* (W) LoopProtection option (Y/N) */
  UEXITCOM *uexitcom_ptr;           /* (-) Reserved (address of user exit common area) */
  F_IDICUXWR *ep_idicuxwr;          /* (R) IDICUXWR module EP address */
  char Reserved_zero[4];            /* (-) Reserved (always X'00000000' - necessary for COBOL invocation) */
  char INVOCATION_EXIT;             /* (R) Invocation exit used:        */
                                    /*       C = IDIXCX52/IDIXCX53      */
                                    /*       E = IDIXCCEE               */
                                    /*       L = IDIXCEE                */
                                    /*       M = IDIXDCAP               */
                                    /*       S = IDISNAP                */
  char STEP_NAME[8];                /* (R) Job/started task step name */
  char JOB_ID[8];                   /* (R) Job ID */
  char IMS_PROGRAM_NAME[8];         /* (R) IMS program name */
  char USER_NAME[8];                /* (W) User name */
  char USER_TITLE[40];              /* (W) User title */
  char APPLID[8];                   /* (R) Application identifier */
  char TERMID[4];                   /* (R) CICS Terminal ID       */
  char NETNAME[8];                  /* (R) CICS Terminal Netname  */
  char TCB_ADDRESS[8];              /* (R) Analyzed TCB address */
  char CSA_ADDRESS[8];              /* (R) CICS CSA address */
  char TCA_ADDRESS[8];              /* (R) CICS TCA address */
  char IDIHIST[44];                 /* (B) Fault history file name */
  char ABEND_CODE[6];               /* (R) ABEND code */
  char CPU_HSECONDS[6];             /* (R) CPU time in 1/100s of a second at report end */
  char Reserved_2[8];               /* (-) Reserved for future use */
};
 
/* The FLDBUFINFO structure is used to provide information about a buffer that
   is used to hold data when the field is too short. */
struct FLDBUFINFO;
typedef struct FLDBUFINFO FLDBUFINFO;
struct FLDBUFINFO {
  unsigned char flag1;           /* Set to X'FF' when the field contains this structure */
  unsigned char flag2;           /* Set to X'80' if a buffer has been GETMAIN'ed for a returned REXX
                                    variable whose length exceeds the field length and no buffer
                                    was malloc'ed when initializing the field.  The flag indicates that
                                    the buffer address must be FREEMAIN'ed. */
  unsigned char unused[2];
  char *buf_addr;
  int buf_len;
};
 
/* ANALYSIS CONTROL exit parameter list */
#define CTL_VERSION 2
struct CTL {
  char VERSION[4];              /* (R) CTL structure version (CTL_VERSION) */
  char EXCLUDE;                 /* (B) Exclude from analysis (Y/N) */
  char DETAIL_OPT;              /* (B) DETAIL option (S/M/L) */
  char DEFERREDREPORT_OPT;      /* (B) DEFERREDREPORT option (Y/N) */
  char Reserved_1[11];          /* (-) Reserved */
  char RETAINDUMP_OPT[10];      /* (B) RETAINDUMP option */
  char Reserved_2[44];          /* (-) Reserved */
  char INCLUDE_CRITERION[120];  /* (R) Last matching INCLUDE criterion */
  char EXCLUDE_CRITERION[120];  /* (R) Last matching EXCLUDE criterion */
  char Reserved_3[5];           /* (-) Reserved */
  char SOURCE_OPT;              /* (B) SOURCE option (Y/N) */
  char Reserved_4[6];           /* (-) Reserved */
  char PRINTINACTIVECOBOL_OPT;  /* (B) PrintInactiveCOBOL option (Y/N) */
  char Reserved_5[51];          /* (-) Reserved */
  char IDIADATA_PRE[45*120];    /* (R) IDIADATA preallocated data sets */
  char IDIADATA_JOB[45*120];    /* (B) IDIADATA data sets specified in IDIOPTS or PARM field */
  char IDIADATA_CFG[45*120];    /* (B) IDIADATA data sets specified in IDICNF00 config member */
  char IDILC_PRE[45*120];       /* (R) IDILC    preallocated data sets */
  char IDILC_JOB[45*120];       /* (B) IDILC    data sets specified in IDIOPTS or PARM field */
  char IDILC_CFG[45*120];       /* (B) IDILC    data sets specified in IDICNF00 config member */
  char IDILCOB_PRE[45*120];     /* (R) IDILCOB  preallocated data sets */
  char IDILCOB_JOB[45*120];     /* (B) IDILCOB  data sets specified in IDIOPTS or PARM field */
  char IDILCOB_CFG[45*120];     /* (B) IDILCOB  data sets specified in IDICNF00 config member */
  char IDILCOBO_PRE[45*120];    /* (R) IDILCOBO preallocated data sets */
  char IDILCOBO_JOB[45*120];    /* (B) IDILCOBO data sets specified in IDIOPTS or PARM field */
  char IDILCOBO_CFG[45*120];    /* (B) IDILCOBO data sets specified in IDICNF00 config member */
  char IDILANGX_PRE[45*120];    /* (R) IDILANGX preallocated data sets */
  char IDILANGX_JOB[45*120];    /* (B) IDILANGX data sets specified in IDIOPTS or PARM field */
  char IDILANGX_CFG[45*120];    /* (B) IDILANGX data sets specified in IDICNF00 config member */
  char IDILPLI_PRE[45*120];     /* (R) IDILPLI  preallocated data sets */
  char IDILPLI_JOB[45*120];     /* (B) IDILPLI  data sets specified in IDIOPTS or PARM field */
  char IDILPLI_CFG[45*120];     /* (B) IDILPLI  data sets specified in IDICNF00 config member */
  char Reserved_6[1024];        /* (-) Reserved */
  char IDILPLIE_PRE[45*120];    /* (R) IDILPLIE preallocated data sets */
  char IDILPLIE_JOB[45*120];    /* (B) IDILPLIE data sets specified in IDIOPTS or PARM field */
  char IDILPLIE_CFG[45*120];    /* (B) IDILPLIE data sets specified in IDICNF00 config member */
  char LOCALE[256];             /* (B) Locale name */
  char FADATE;                  /* (B) Use standard Fault Analyzer date format (Y/N) */
  char IDISYSDB_PRE[45*120];    /* (R) IDISYSDB preallocated data sets */
  char IDISYSDB_JOB[45*120];    /* (B) IDISYSDB data sets specified in IDIOPTS or PARM field */
  char IDISYSDB_CFG[45*120];    /* (B) IDISYSDB data sets specified in IDICNF00 config member */
};
 
/* COMPILER LISTING READ exit parameter list */
#define LST_VERSION 1
struct LST {
  char VERSION[4];              /* (R) LST structure version (LST_VERSION) */
  char MODULE_NAME[8];          /* (R) Module name */
  char CSECT_NAME[8];           /* (R) CSECT name */
  char EP_NAME[256];            /* (R) Entry point name (truncated to 256 chars) */
  char COMPILE_DATE[10];        /* (R) Compile date in the format YYYY/MM/DD */
  char COMPILE_TIME[8];         /* (R) Compile time in the format HH:MM:SS */
  char LISTING_TYPE;            /* (R) Compiler listing (L), SYSADATA file (A), or side file (S) */
  char LANGUAGE_TYPE[12];       /* (R) Language type: - Assembler   */
                                /*                    - C/C++       */
                                /*                    - COBOL       */
                                /*                    - OS/VS COBOL */
                                /*                    - PL/I        */
  char RECFM[4];                /* (R) Record format */
  char LRECL[5];                /* (R) Logical record length */
  char DATA_LENGTH[5];          /* (W) Data length of variable length record */
  char DISREGARD_EXIT_LISTING;  /* (W) Use exit-provided compiler listing or side-file (Y/N) */
  char PROGRAM_NAME[8];         /* (R) Program name */
  char PROGRAM_LENGTH[10];      /* (R) Program length */
  char DATA_BUFFER_DSN;         /* (W) Indicates that DATA_BUFFER contains the name of a data set
                                       instead of a data record (Y/N) */
  char LOAD_MODULE_DSN[44];     /* (R) Load module data set name */
  char Reserved[1];             /* (-) Reserved (not currently used) */
  char rdw[4];                  /* (-) Reserved (used internally as RDW for variable length records and
                                       must immediately preceede DATA_BUFFER) */
  char DATA_BUFFER[8188];       /* (W) Data buffer */
};
 
/* BATCH REPORT exit parameter list */
#define REP_VERSION 1
struct REP {
  char VERSION[4];                  /* (R) REP structure version (REP_VERSION) */
  char DETAIL_OPT;                  /* (R) DETAIL option (S/M/L) */
  char Reserved_1[3];               /* (-) Reserved */
 
  /* General options */
  char EXTRA_SOURCE_LINES[4];       /* (B) Number of additional source code lines to include before and
                                           after the one matching the program offset */
  char Reserved_2[12];              /* (-) Reserved */
 
  /* Report sections */
  char SUMMARY;                     /* (B) SUMMARY section (Y/N) */
  char NON_EVENT;                   /* (B) NON-EVENT-SPECIFIC section (Y/N) */
  char JOB_INFO;                    /* (B) ABEND JOB INFO section (Y/N) */
  char OPTIONS;                     /* (B) OPTIONS section (Y/N) */
  char Reserved_3[4];               /* (-) Reserved */
 
  /* Event details */
 
  /* Pre-point-of-failure events */
  char DETAIL_PRE_POF_INCLUDE;             /* (B) Include this event type in the report (Y/N) */
  char DETAIL_PRE_POF_USER_ONLY;           /* (B) Include only if user code (Y/N) */
  char DETAIL_PRE_POF_STORAGE;             /* (B) Include associated storage areas (Y/N) */
  char DETAIL_PRE_POF_FILE_BUFFERS;        /* (B) Include buffers for all open files (Y/N) */
  char DETAIL_PRE_POF_STORAGE_ALL;         /* (B) Include information from suppressed COBOL copy books in the
                                                  associated storage areas (Y/N) */
  char Reserved_4[11];                     /* (-) Reserved */
 
  /* Point-of-failure events */
  char DETAIL_POF_INCLUDE;                 /* (B) Include this event type in the report (Y/N) */
  char DETAIL_POF_USER_ONLY;               /* (B) Include only if user code (Y/N) */
  char DETAIL_POF_STORAGE;                 /* (B) Include associated storage areas (Y/N) */
  char DETAIL_POF_FILE_BUFFERS;            /* (B) Include buffers for all open files (Y/N) */
  char DETAIL_POF_STORAGE_ALL;             /* (B) Include information from suppressed COBOL copy books in the
                                                  associated storage areas (Y/N) */
  char Reserved_5[11];                     /* (-) Reserved */
 
  /* Pre-first-abend events */
  char DETAIL_PRE_ABEND_INCLUDE;           /* (B) Include this event type in the report (Y/N) */
  char DETAIL_PRE_ABEND_USER_ONLY;         /* (B) Include only if user code (Y/N) */
  char DETAIL_PRE_ABEND_STORAGE;           /* (B) Include associated storage areas (Y/N) */
  char DETAIL_PRE_ABEND_FILE_BUFFERS;      /* (B) Include buffers for all open files (Y/N) */
  char DETAIL_PRE_ABEND_STORAGE_ALL;       /* (B) Include information from suppressed COBOL copy books in the
                                                  associated storage areas (Y/N) */
  char Reserved_6[11];                     /* (-) Reserved */
 
  /* First-abend event */
  char DETAIL_ABEND_INCLUDE;               /* (B) Include this event type in the report (Y/N) */
  char DETAIL_ABEND_USER_ONLY;             /* (B) Include only if user code (Y/N) */
  char DETAIL_ABEND_STORAGE;               /* (B) Include associated storage areas (Y/N) */
  char DETAIL_ABEND_FILE_BUFFERS;          /* (B) Include buffers for all open files (Y/N) */
  char DETAIL_ABEND_STORAGE_ALL;           /* (B) Include information from suppressed COBOL copy books in the
                                                  associated storage areas (Y/N) */
  char Reserved_7[11];                     /* (-) Reserved */
 
  /* Post-first-abend events */
  char DETAIL_POST_ABEND_INCLUDE;          /* (B) Include this event type in the report (Y/N) */
  char DETAIL_POST_ABEND_USER_ONLY;        /* (B) Include only if user code (Y/N) */
  char DETAIL_POST_ABEND_STORAGE;          /* (B) Include associated storage areas (Y/N) */
  char DETAIL_POST_ABEND_FILE_BUFFERS;     /* (B) Include buffers for all open files (Y/N) */
  char DETAIL_POST_ABEND_STORAGE_ALL;      /* (B) Include information from suppressed COBOL copy books in the
                                                  associated storage areas (Y/N) */
  char Reserved_8[11];                     /* (-) Reserved */
};
 
/* MESSAGE AND ABEND CODE EXPLANATION user exit parameter list */
#define XPL_VERSION 1
struct XPL {
  char VERSION[4];              /* (R) XPL structure version (XPL_VERSION) */
  char MESSAGE_TEXT1[125];      /* (R) Single-line WTO or first multi-line WTO message text */
  char MESSAGE_TEXT2[70];       /* (R) Multi-line WTO message text line 2 */
  char MESSAGE_TEXT3[70];       /* (R) Multi-line WTO message text line 3 */
  char MESSAGE_TEXT4[70];       /* (R) Multi-line WTO message text line 4 */
  char MESSAGE_TEXT5[70];       /* (R) Multi-line WTO message text line 5 */
  char MESSAGE_TEXT6[70];       /* (R) Multi-line WTO message text line 6 */
  char MESSAGE_TEXT7[70];       /* (R) Multi-line WTO message text line 7 */
  char MESSAGE_TEXT8[70];       /* (R) Multi-line WTO message text line 8 */
  char MESSAGE_TEXT9[70];       /* (R) Multi-line WTO message text line 9 */
  char MESSAGE_TEXT10[70];      /* (R) Multi-line WTO message text line 10 */
  char ABEND_CODE[4];           /* (R) ABEND code */
  char ABEND_REASON_CODE[8];    /* (R) ABEND reason code */
  char ABEND_MODULE_NAME[8];    /* (R) ABEND module name */
  char ABEND_TYPE;              /* (R) ABEND type:
                                         C = CICS transaction abend
                                         D = CICS dump code
                                         S = system abend
                                         U = user abend */
  char DATA_LENGTH[5];          /* (W) Data length */
  char DATA_BUFFER[256];        /* (W) Data buffer */
  char EXPLANATION_AVAILABLE;   /* (R) Explanation available (Y/N) */
  char Reserved[64];            /* (-) Reserved */
};
 
/* END PROCESSING exit parameter list */
#define EPC_VERSION 2
struct EPC {
  char VERSION[4];              /* (R) EPC structure version (EPC_VERSION) */
  char reserved_1[4];           /* (-) Reserved */
  char IS_DUPLICATE;            /* (B) This is a duplicate fault (Y/N) */
  char SUPPRESS_MINIDUMP;       /* (B) Suppress minidump (Y/N) */
  char Reserved_2;              /* (-) Reserved */
  char SUPPRESS_FAULT_ENTRY;    /* (B) Suppress history file fault entry (Y/N) */
  char reserved_3[9];           /* (-) Reserved */
  char DUPLICATE_COUNT[5];      /* (R) Number of duplicate faults */
  char MINUTES_SINCE_LAST_DUP[5];  /* (R) Number of minutes elapsed since the recording of last duplicate fault (nnnnn) */
  char ANALYSIS_SUCCESSFUL;     /* (R) Successful analysis (Y/N) */
  char POF_MODULE_NAME[8];      /* (R) Point-of-failure module name */
  char POF_MODULE_LKED_DATE[10];/* (R) Point-of-failure module link-edit date (YYYY/MM/DD) */
  char POF_MODULE_LKED_TIME[8]; /* (R) Point-of-failure module link-edit time (HH:MM:SS) */
  char POF_CSECT_NAME[8];       /* (R) Point-of-failure CSECT name */
  char POF_CSECT_OFFSET[10];    /* (R) Point-of-failure CSECT offset (decimal) */
  char Reserved_3[44];          /* (-) Reserved */
  char SUPPRESS_DUMP;           /* (B) Suppress dump (Y/N) */
  char MINIDUMP_PAGES[6];       /* (R) Size of minidump as number of 4K pages */
  char Reserved_4[57];          /* (-) Reserved */
};
 
/* NOTIFICATION exit parameter list */
#define NFY_VERSION 2
struct NFY {
  char VERSION[4];              /* (R) NFY structure version (NFY_VERSION) */
  char Reserved_1[45];          /* (-) Reserved */
  char SYNOPSIS[1024];          /* (R) Analysis synopsis */
  char NFYTYPE;                 /* (R) Reason for NFY call, C=Fault created, N=Normal Duplicate F=Fast Duplicate */
  char DUPCOUNT[8];             /* (R) Number of duplicates for NFYTYPE=N or F */
  char Reserved_2[55];          /* (-) Reserved */
};
 
/* IDIUTIL utility exits parameter list */
#define UTL_VERSION 2
struct UTL {
  char VERSION[4];              /* (R) UTL structure version (UTL_VERSION) */
  char Reserved_1[44];          /* (-) Reserved */
  char PERFORM_ACTION;          /* (B) Perform the utility action on this Fault entry (Y/N) */
  char Reserved_2[64];          /* (-) Reserved */
};
 
/* FORMATTING exit parameter list */
#define UFM_VERSION 1
struct UFM {
  char VERSION[4];              /* (R) UFM structure version (UFM_VERSION) */
  char NUM_EVENTS[5];           /* (R) Number of events */
  char EVENT_NO[5];             /* (W) Event number */
  char NEXT_EVENT_NO[5];        /* (R) Next available event number */
  char PREVIOUS_EVENT_NO[5];    /* (R) Previous available event number */
  char POF;                     /* (R) Point of failure (Y/N) */
  char EVENT_TYPE[30];          /* (R) Event type (buffered data format - must be at least 12 bytes) */
  char MODULE_NAME[12];         /* (R) Module name (buffered data format - must be at least 12 bytes) */
  char MODULE_ADDRESS[8];       /* (R) Module address */
  char MODULE_LENGTH[8];        /* (R) Module length */
  char PROGRAM_NAME[12];        /* (R) Program name (buffered data format - must be at least 12 bytes) */
  char PROGRAM_ADDRESS[8];      /* (R) Program address */
  char PROGRAM_LENGTH[8];       /* (R) Program length */
  char EP_NAME[12];             /* (R) Entry-point name (buffered data format - must be at least 12 bytes) */
  char EP_ADDRESS[8];           /* (R) Entry-point address */
  char EVENT_LOCATION[64];      /* (R) Event location (buffered data format - must be at least 12 bytes) */
  char LOADED_FROM[44];         /* (R) Loaded from (buffered data format - must be at least 12 bytes) */
  char INSTRUCTION_ADDRESS[8];  /* (R) Instruction address */
  char AMODE[2];                /* (R) Addressing mode (24/31) */
  char PSW[16];                 /* (R) Program status word */
  char GPREG0[8];               /* (R) General purpose register 0 */
  char GPREG1[8];               /* (R) General purpose register 1 */
  char GPREG2[8];               /* (R) General purpose register 2 */
  char GPREG3[8];               /* (R) General purpose register 3 */
  char GPREG4[8];               /* (R) General purpose register 4 */
  char GPREG5[8];               /* (R) General purpose register 5 */
  char GPREG6[8];               /* (R) General purpose register 6 */
  char GPREG7[8];               /* (R) General purpose register 7 */
  char GPREG8[8];               /* (R) General purpose register 8 */
  char GPREG9[8];               /* (R) General purpose register 9 */
  char GPREG10[8];              /* (R) General purpose register 10 */
  char GPREG11[8];              /* (R) General purpose register 11 */
  char GPREG12[8];              /* (R) General purpose register 12 */
  char GPREG13[8];              /* (R) General purpose register 13 */
  char GPREG14[8];              /* (R) General purpose register 14 */
  char GPREG15[8];              /* (R) General purpose register 15 */
  char AREG_DATA_ADDRESS[8];    /* (R) Address of access register data area (0 through 16) */
  char NUM_FPREGS[2];           /* (R) Number of floating point registers (4/16) */
  char FPREG_DATA_ADDRESS[8];   /* (R) Address of floating point register data area (0, 2, 4, 8 or 0 through 16) */
  char Reserved[128];           /* (-) Reserved */
  char DATA_LENGTH[5];          /* (W) Data length */
  char DATA_BUFFER[UFMLRECL];   /* (W) Data buffer */
  char null;                    /* (-) Reserved (used internally as NULL-terminator of the
                                       DATA_BUFFER string) */
};
 
struct argtable_entry {
  void          *argtable_argstring_ptr;     /* Address of the argument string */
  int            argtable_argstring_length;  /* Length of the argument string  */
};
 
struct compgmtb_header {
  COMPGMTB_ENTRY *compgmtb_first;   /* Address of the first COMPGMTB entry */
  int            compgmtb_total;    /* Total number of COMPGMTB entries       */
  int            compgmtb_used;     /* Number of used COMPGMTB entries        */
  int            compgmtb_length;   /* Length of each COMPGMTB entry          */
  unsigned char  _filler1[8];       /* Reserved           */
  unsigned char  compgmtb_ffff[8];  /* End marker - hex 'FFFFFFFFFFFFFFFF' */
};
 
struct compgmtb_entry {
  unsigned char  compgmtb_rtproc[8]; /* Name of the Run Time Processor         */
  unsigned char  compgmtb_compinit[8]; /* Name of the Initialization   */
                                       /*                                        Routine */
  unsigned char  compgmtb_compterm[8]; /* Name of the Termination Routine        */
  unsigned char  compgmtb_compload[8]; /* Name of the Load Routine     */
  unsigned char  compgmtb_compvar[8]; /* Name of the Variable Handling          */
                                      /*                                        Routine */
  int            compgmtb_storage[4]; /* Storage for the Compiler     */
};
 
struct dsib_info {
  unsigned char  dsib_id[8];     /* The 'IRXDSIB ' identifier    */
  short int      dsib_length;    /* Length of the DSIB_INFO control        */
                                 /*                                     block        */
  short int      _filler1;       /* Reserved           */
  unsigned char  dsib_ddname[8]; /* Name of DD for which information       */
                                 /*                                     is being returned      */
  unsigned char  dsib_vmask1;    /* Bit mask used to indicate which        */
                                 /*                                     fields contain valid data        */
  unsigned char  dsib_vmask2;    /* ON if LRECL field is set     */
                                 /* ON if BLKSZ field is set     */
                                 /* ON if DSORG field is set     */
                                 /* ON if RECFM field is set     */
                                 /* ON if GET_CNT field is valid           */
                                 /* ON if PUT_CNT field is valid           */
                                 /* ON if MODE field is set      */
                                 /* ON if CC field is set        */
                                 /* Bit mask used to indicate which        */
                                 /*                                     fields contain valid data        */
  unsigned char  _filler2[2];    /* ON if TRC field is set       */
                                 /* Reserved                  @DEI0051     */
  short int      dsib_lrecl;     /* Data set LRECL     */
  short int      dsib_blksz;     /* Data set BLKSIZE   */
  unsigned char  dsib_dsorg[2];  /* Data Set Organization (DSORG) -        */
                                 /* '0200' = Data set is partitioned/ */
                                 /* '0300' = partitioned unmoveable,  */
                                 /* '4000' = Data set is sequential/  */
                                 /* '4100' = sequential unmoveable.   */
  unsigned char  dsib_recfm[2];  /* Record Format Information ==>          */
                                 /* 'F ' = Fixed record format,    */
                                 /* 'FB' = Fixed Blocked format,   */
                                 /* 'V ' = Variable record format,    */
                                 /* 'VB' = Variable Blocked format    */
  int            dsib_get_cnt;   /* Total number of records read           */
                                 /* (by 'GET' macro) for this DCB   */
  int            dsib_put_cnt;   /* Total number of records written        */
                                 /* (by 'PUT' or 'PUTX') for this DCB   */
  unsigned char  dsib_io_mode;   /* Mode in which DCB was opened:          */
                                 /* 'R' = Open for 'READ' (uses GET  */
                                 /* macro), 'X' = Open for 'READX'   */
                                 /* (update uses GET / PUTX macros),    */
                                 /* 'W' = Open for 'WRITE' (uses PUT    */
                                 /* macro), 'L' = Open for Exec LOAD    */
                                 /* (uses 'READ' macro)    */
  unsigned char  dsib_cc;        /* Carriage control information:          */
                                 /* 'A' = ANSI carriage control,   */
                                 /* 'M' = Machine carriage control,   */
                                 /* ' ' = No carriage control      */
  unsigned char  dsib_trc;       /* 3800 TRC information:        */
                                 /* 'Y' = character set control    */
                                 /* characters are present   */
                                 /* 'N' = character set control    */
                                 /* characters are not present  */
  unsigned char  _filler3;       /* Reserved                  @DEI0051     */
  int            _filler4[3];    /* Reserved words     */
};
 
struct efpl {
  void          *efplcom; /* * RESERVED         */
  void          *efplbarg; /* * RESERVED         */
  void          *efplearg; /* * RESERVED         */
  void          *efplfb; /* * RESERVED         */
  ARGTABLE_ENTRY *efplarg; /* * POINTER TO ARGUMENTS TABLE      */
  EVALBLOCK    **efpleval; /* * POINTER TO ADDRESS OF EVALBLOCK */
};
 
struct envblock {
  unsigned char  envblock_id[8];            /* ENVBLOCK identifier 'ENVBLOCK'         */
  unsigned char  envblock_version[4];       /* Version number        @DEI0040         */
  int            envblock_length;           /* Length of ENVBLOCK    @DEI0040         */
  PARMBLOCK     *envblock_parmblock;        /* Address of the PARMBLOCK     */
  void          *envblock_userfield;        /* Address of the user field    */
  WORKBLOK_EXT  *envblock_workblok_ext;     /* Address of the current WORKBLOK_EXT  */
  void          *envblock_irxexte;          /* Address of IRXEXTE           */
  void          *error_call_;               /* Address of the routine in error        */
  int            _filler1;                  /* Reserved           */
  unsigned char  error_msgid[8];            /* Message identifier of first call       */
  unsigned char  primary_error_message[80]; /* Error message      */
  unsigned char  alternate_error_msg[160];  /* Extended error message       */
  void          *envblock_compgmtb;         /* Address of the Compiler Programming Table */
  void          *envblock_attnrout_parmptr; /* Address of a parameter       */
                                            /* passed to the user's ATTNROUT    */
                                            /* routine from the REXX attention  */
                                            /* routine. Used for communication  */
                                            /* between the user's ATTNROUT   */
                                            /* routine and the REXX attention   */
                                            /* routine.                         */
  void          *envblock_ectptr;           /* Address of the ECT under which         */
                                            /* an environment that is        */
                                            /* integrated with TSO/E is      */
                                            /* anchored.                     */
  unsigned char  envblock_info_flag1;       /* Information byte 1                     */
  unsigned char  _filler2[3];               /* Flag to indicate that        */
                                            /* IRXTERMA is in control to     */
                                            /* FREE active execs and possibly   */
                                            /* to cleanup the ENVBLOCK       */
                                            /* itself                  @YA57272 */
                                            /* Reserved                @YA57272       */
  int            _filler3[4];               /* Reserved                @YA57272       */
  /* End of externally documented ENVBLOCK */
  char unknown[20];
  EVALBLOCK *envblock_evalblock;            /* Pointer to EVALBLOCK at offset X'154' */
};
 
struct evalblock {
  int            evalblock_evpad1;  /* Reserved - set to binary zero          */
  int            evalblock_evsize;  /* Size of EVALBLOCK in double words */
  int            evalblock_evlen;   /* Length of data     */
  int            evalblock_evpad2;  /* Reserved - set to binary zero          */
  unsigned char  evalblock_evdata;  /* Result   */
  unsigned char  execb_id[8];
};
 
struct execblk {
  unsigned char  exec_blk_acryn[8]; /* Acronym identifier, must be set        */
                                    /* to 'IRXEXECB' */
  int            exec_blk_length; /* Length of EXECBLK in bytes */
  int            _filler1;       /* Reserved */
  unsigned char  exec_member[8]; /* The member name of the Exec, if        */
                                 /* Exec is from a partitioned data  */
                                 /* set, or blank if from sequential   */
  unsigned char  exec_ddname[8]; /* The DD from which the Exec is          */
                                 /* loaded ('LOAD') or DD to be      */
                                 /* closed ('CLOSEDD').    */
  unsigned char  exec_subcom[8]; /* Name of the initial subcommand environment */
  void          *exec_dsnptr;    /* Pointer to a data set name (DSN)       */
                                 /* to be returned when a REXX Exec  */
                                 /* issues a PARSE SOURCE command.   */
                                 /* Ptr may be 0 to indicate no DSN.   */
                                 /* (Name is up to 44 chars for DSN  */
                                 /* + up to 10 for parenthetical     */
                                 /* member name).          */
  int            exec_dsnlen;    /* Length of DSN pointed to by  */
                                 /* EXEC_DSNPTR, or 0 if none.       */
                                 /* Valid length is 0 to 54          */
  union {
    struct {
      unsigned char  _exec_v1_end; /* End of EXECBLK             @PEI0455    */
      unsigned char  _filler2[3];
    } _execblk_struct1;
    void          *_exec_extname_ptr; /* Length of the EXECBLK Ver1 @WA28404    */
                                      /* Length of the EXECBLK Ver1   */
                                      /* (alias of EXECBLEN)        @WA28404 */
                                      /* Pointer to the extended execname.      */
                                 /* This field can be used to pass an  */
                                 /* execname if >8 chars. For        */
                                 /* example, this field may be used to */
                                 /* pass 'pathname/filename' of HFS  */
                                 /* execname files in OMVS to the    */
                                 /* MVS replaceable load routine.    */
                                 /* (This name is not used by the    */
                                 /* TSO load routine.)        @WA28404 */
  } _execblk_union1;
  int            exec_extname_len; /* Length of the extended name  */
                                 /* pointed to by EXEC_EXTNAME_PTR,  */
                                 /* or 0 if no extended name is      */
                                 /* specified.                @WA28404 */
  int            _filler3[2];   /* RSVD                       @WA28404    */
  unsigned char  exec_v2_end;   /* End of Ver 2 EXECBLK       @WA28404    */
};
 
#define exec_v1_end      _execblk_union1._execblk_struct1._exec_v1_end
#define exec_extname_ptr _execblk_union1._exec_extname_ptr
 
struct irxexte {
  int            irxexte_entry_count; /* Number of entry points in the          */
                                      /*                                        REXX Vector of External Entry   */
                                      /*                                        Points    */
  void          *irxinit;           /* IRXINIT - REXX Initialization          */
                                    /* Routine   */
  void          *load_routine;      /* LOAD_ROUTINE - REXX Load Exec          */
                                    /* Routine   */
  void          *irxload;           /* IRXLOAD - Default REXX Load Exec       */
                                    /* Routine   */
  void          *irxexcom;          /* IRXEXCOM - REXX Variable Access        */
                                    /* Routine   */
  void          *irxexec;           /* IRXEXEC - REXX Run Exec Routine        */
  void          *io_routine;        /* IO_ROUTINE - REXX Input/Output         */
                                    /* Routine   */
  void          *irxinout;          /* IRXINOUT - Default REXX      */
                                    /* Input/Output Routine          */
  void          *irxjcl;            /* IRXJCL - REXX JCL Routine    */
  void          *irxrlt;            /* IRXRLT - REXX Get Result Routine       */
  void          *stack_routine;     /* STACK_ROUTINE - REXX Data Stack        */
                                    /* Handling Routine    */
  void          *irxstk;            /* IRXSTK - Default REXX Data Stack       */
                                    /* Handling Routine    */
  void          *irxsubcm;          /* IRXSUBCM - REXX Subcommand   */
                                    /*                                        Service Routine     */
  void          *irxterm;           /* IRXTERM - REXX Termination   */
                                    /*                                        Routine   */
  void          *irxic;             /* IRXIC - REXX Immediate Commands        */
                                    /*                                        Routine   */
  void          *msgid_routine;     /* MSGID_ROUTINE - REXX Message ID        */
                                    /*                                        Routine   */
  void          *irxmsgid;          /* IRXMSGID - Default REXX Message        */
                                    /*                                        ID Routine          */
  void          *userid_routine;    /* USERID_ROUTINE - REXX User ID          */
                                    /*                                        Routine   */
  void          *irxuid;            /* IRXUID - Default REXX User ID          */
                                    /*                                        Routine   */
  void          *irxterma;          /* IRXTERMA - REXX Abnormal     */
                                    /*                                        Termination Routine           */
  void          *irxsay;            /* IRXSAY - REXX SAY      @E23X2BJ        */
                                    /*                                        Instruction Routine    @E23X2BJ */
  void          *irxers;            /* IRXERS - REXX External @E23X2BJ        */
                                    /*                                        Routine Search Routine @E23X2BJ */
  void          *irxhst;            /* IRXHST - REXX Host     @E23X2BJ        */
                                    /*                                        Command Search Routine @E23X2BJ */
  void          *irxhlt;            /* IRXHLT - REXX Halt     @E23X2BJ        */
                                    /*                                        Condition Routine      @E23X2BJ */
  void          *irxtxt;            /* IRXTXT - REXX Text     @E23X2BJ        */
                                    /*                                        Retrieval Routine      @E23X2BJ */
  void          *irxlin;            /* IRXLIN - REXX LINESIZE @E23X2BJ        */
                                    /*                                        Routine                @E23X2BJ */
  void          *irxrte;            /* IRXRTE - REXX Exit     @E23X2BJ        */
                                    /*                                        Routing Routine        @E23X2BJ */
};
 
struct fpckdir_header {
  unsigned char  fpckdir_id[8];     /* FPCKDIR character id    */
  int            fpckdir_header_length; /* Length of header   */
  int            fpckdir_functions; /* Number of functions     */
  int            _filler1;          /* Reserved           */
  int            fpckdir_entry_length; /* Length of FPCKDIR entry */
};
 
struct fpckdir_entry {
  unsigned char  fpckdir_funcname[8]; /* Name of Function or Subroutine         */
  void          *fpckdir_funcaddr;    /* Address of the entry point of          */
                                      /* of the package code           */
  int            _filler1;            /* Reserved           */
  unsigned char  fpckdir_sysname[8];  /* Name of the entry point      */
                                      /* corresponding to package code */
  unsigned char  fpckdir_sysdd[8];    /* DD name from which the package         */
                                      /* code is loaded      */
};
 
struct instblk {
  unsigned char  instblk_acronym[8];  /* The INSTBLK Identifier       */
  int            instblk_hdrlen;      /* Length of INSTBLK header     */
  int            _filler1;            /* Reserved           */
  INSTBLK_ENTRY *instblk_address;     /* Address of first INSTBLK_ENTRY         */
  int            instblk_usedlen;     /* Total length of all used     */
                                      /* INSTBLK_ENTRYs. (Number of       */
                                      /* entries = INSTBLK_USEDLEN/length   */
                                      /* of each INSTBLK_ENTRY.)          */
  unsigned char  instblk_member[8];   /* Name of member from which exec         */
                                      /* was loaded, or blank if loaded   */
                                      /* from a sequential DD.  */
                                      /* This field should be left */
                                      /* blank if the execname     */
                                      /* loaded is an extended     */
                                      /* name pointed to by        */
                                      /* INSTBLK_EXTNAME_PTR.      */
  unsigned char  instblk_ddname[8];   /* Name of DD representing data set from which exec was loaded       */
  unsigned char  instblk_subcom[8];   /* Name of initial subcommand environment under which exec is run     */
  int            _filler2;            /* Reserved           */
  int            instblk_dsnlen;      /* Length of data set name      */
  unsigned char  instblk_dsname[54];  /* Data set name from which exec was loaded, if known       */
  short int      _filler3;            /* Reserved           */
  void          *instblk_extname_ptr; /* Ptr to the extended execname.          */
                                      /* This field can be used to pass   */
                                      /* an execname if >8 chars. For     */
                                      /* example, this field is used to   */
                                      /* pass 'pathname/filename' of HFS  */
                                      /* execname files in OMVS, since in   */
                                      /* this case the INSTBLK_MEMBER     */
                                      /* field is not sufficient to hold  */
                                      /* the exec name.         */
                                      /* (This name is not currently used by */
                                      /* default TSO load routine)           */
  int            instblk_extname_len; /* Length of the extended name  */
                                      /* pointed to by INSTBLK_EXTNAME_PTR, */
                                      /* or 0 if no extended name is      */
                                      /* specified.                       */
  int            _filler4[2];         /* Reserved - 2 words                */
  unsigned char  instblk_entries[8];  /* The INSTBLK_ENTRY array of entries begins here  */
};
 
struct instblk_entry {
  void          *instblk_stmt;        /* Address of REXX statement    */
  int            instblk_stmtlen;     /* Length of the REXX statement */
};
 
struct statement {
  unsigned char  instblk_acryn[8];
/*  ******************************************************************** */
 /*     Declaration for the In-storage control block acronym     @E23X2BJ */
/*  ******************************************************************** */
                                  /* In-storage control      @E23X2BJ       */
                                  /*                                      block acronym           @E23X2BJ */
};
 
struct modnamet {
  unsigned char  modnamet_indd[8];  /* Name of the input DD and is only       */
                                    /*                                        used in MVS            @DEI0051  */
  unsigned char  modnamet_outdd[8]; /* Name of the output DD and is           */
                                    /*                                        only used in MVS       @DEI0051  */
  unsigned char  modnamet_loaddd[8]; /* Name of the load exec DD     */
  unsigned char  modnamet_iorout[8]; /* Name of the input and output           */
                                     /*                                        routine   */
  unsigned char  modnamet_exrout[8]; /* Name of the exec load routine          */
  unsigned char  modnamet_getfreer[8]; /* Name of the getmain and freemain       */
                                       /*                                        routine   */
  unsigned char  modnamet_execinit[8]; /* Name of the Exec Initialization        */
                                       /*                                        routine                 @YA17590 */
  unsigned char  modnamet_attnrout[8]; /* Name of the attention routine          */
  unsigned char  modnamet_stackrt[8]; /* Name of the stack routine    */
  unsigned char  modnamet_irxexecx[8]; /* Name of the IRXEXEC exit routine       */
  unsigned char  modnamet_idrout[8]; /* Name of the userid routine   */
  unsigned char  modnamet_msgidrt[8]; /* Name of the message id routine         */
/*                                                                @PEI0052 */
  unsigned char  modnamet_execterm[8]; /* Name of the Exec Termination           */
                                       /*                                        routine                 @YA17590 */
  unsigned char  modnamet_ffff[8];  /* End marker - hex   */
                                    /*                                        'FFFFFFFFFFFFFFFF'  */
};
 
struct packtb_header {
  PACKTB_ENTRY  *packtb_user_first;   /* Address of the first user PACKTB entry */
  int            packtb_user_total;   /* Total number of user PACKTB entries */
  int            packtb_user_used;    /* Number of used user PACKTB enties */
  PACKTB_ENTRY  *packtb_local_first;  /* Address of the first local PACKTB entry */
  int            packtb_local_total;  /* Total number of local PACKTB entries */
  int            packtb_local_used;   /* Number of used local PACKTB entries */
  PACKTB_ENTRY  *packtb_system_first; /* Address of the first system PACKTB entry */
  int            packtb_system_total; /* Total number of system PACKTB entries */
  int            packtb_system_used;  /* Number of used system PACKTB entries */
  int            packtb_length;       /* Length of each PACKTB entry  */
  unsigned char  packtb_ffff[8];      /* End marker - hex 'FFFFFFFFFFFFFFFF' */
};
 
struct packtb_entry {
  unsigned char  packtb_name[8];      /* Name of the function package */
  unsigned char  valid_parmblock_id[8];
  unsigned char  valid_parmblock_version[4];
};
 
struct parmblock {
  unsigned char  parmblock_id[8];   /* PARMBLOCK character id       */
                                    /* 'IRXPARMS'          */
  unsigned char  parmblock_version[4]; /* Version number in EBCDIC     */
  unsigned char  parmblock_language[3]; /* Language identifier    @DG10017        */
                /*                    DS  CL1             Reserved               @DG10017  */
  unsigned char  _filler1;
  MODNAMET      *parmblock_modnamet; /* Address of the MODNAMET      */
  SUBCOMTB_HEADER *parmblock_subcomtb; /* Address of the SUBCOMTB header         */
  PACKTB_HEADER *parmblock_packtb;  /* Address of the PACKTB header           */
  unsigned char  parmblock_parsetok[8]; /* Parse source token       */
  unsigned char  parmblock_flags1;  /* First byte of flags          */
                                    /* 1... ....  Integrate with TSO flag */
                                    /* .1.. ....  Reserved               */
                                    /* ..1. ....  Command search order flag */
                                    /* ...1 ....  Function/subroutine search order flag */
                                    /* .... 1...  No data stack flag     */
                                    /* .... .1..  No read flag           */
                                    /* .... ..1.  No write flag          */
                                    /* .... ...1  New data stack flag    */
  unsigned char  parmblock_flags2;  /* Second byte of flags         */
                                    /* 1... ....  User external function package flag */
                                    /* .1.. ....  Local external function package flag */
                                    /* ..1. ....  System external function package flag */
                                    /* ...1 ....  New subcommand table flag    */
                                    /* .... 1...  Close exec data set flag     */
                                    /* .... .1..  No recovery ESTAE flag       */
                                    /* .... ..1.  Reentrant REXX environment flag */
                                    /* .... ...1  No primary messages flag     */
  unsigned char  parmblock_flags3;  /* Third byte of flags          */
                                    /* 1... ....  Issue alternate messages flag */
                                    /* .1.. ....  Subpool storage is shared flag */
                                    /* ..1. ....  STORAGE function flag        */
                                    /* ...1 ....  Do not load from the system-level EXEC DDNAME */
                                    /* .... 1...  MVS, do not issue error messages with the WTO service */
                                    /* .... .1..  MVS, do not issue error messages with I/O to the OUTDD */
                                    /* .... ..11  (not used) */
  unsigned char  _filler2;          /* Reserved */
  unsigned char  parmblock_masks1;  /* First byte of masks          */
                                    /* 1... ....  Integrate with TSO flag mask           */
                                    /* .1.. ....  Reserved flag mask  */
                                    /* ..1. ....  Command search order flag mask         */
                                    /* ...1 ....  Function/subroutine search order flag mask */
                                    /* .... 1...  No data stack flag mask      */
                                    /* .... .1..  No read flag mask  */
                                    /* .... ..1.  No write flag mask           */
                                    /* .... ...1  New data stack flag mask     */
  unsigned char  parmblock_masks2;  /* Second byte of masks         */
                                    /* 1... ....  User external function package flag mask */
                                    /* .1.. ....  Local external function package flag mask */
                                    /* ..1. ....  System external function package flag mask */
                                    /* ...1 ....  New subcommand table flag mask         */
                                    /* .... 1...  Close exec data set flag mask          */
                                    /* .... .1..  No recovery ESTAE flag mask  */
                                    /* .... ..1.  Reentrant REXX environment flag mask */
                                    /* .... ...1  No primary messages flag mask          */
  unsigned char  parmblock_masks3;  /* Third byte of masks          */
                                    /* 1... ....  Issue alternate messages flag mask */
                                    /* .1.. ....  Subpool storage is shared flag mask    */
                                    /* ..1. ....  STORAGE function flag mask */
                                    /* ...1 ....  Mask for do not load from the system-level EXEC DDNAME */
                                    /* .... 1...  MVS, do not issue error messages with the WTO service mask */
                                    /* .... .1..  MVS, do not issue error messages with I/O to the OUTDD mask */
                                    /* .... ..11  (not used) */
  unsigned char  _filler3;          /* Reserved           */
  int            parmblock_subpool; /* Subpool number     */
  unsigned char  parmblock_addrspn[8]; /* Name of the address space    */
  unsigned char  parmblock_ffff[8]; /* End marker - hex   */
                                    /*                                        'FFFFFFFFFFFFFFFF'  */
};
 
struct shvblock {
  SHVBLOCK      *shvnext;          /* Chain pointer to next SHVBLOCK         */
  int            shvuser;          /* Used during "FETCH NEXT"     */
                                   /* Contains length of buffer  */
                                   /* pointed to by SHVNAMA      */
  union {
    int            _shvcodes;
    struct {
      unsigned char  _shvcode;     /* Function code - indicates type         */
                                   /* of variable access request */
      unsigned char  _shvret;      /* Return codes       */
      short int      _filler1;     /* Reserved (should be 0)       */
    } _shvblock_struct1;
  } _shvblock_union1;
  int            shvbufl;          /* Length of fetch value buffer           */
  void          *shvnama;          /* Address of variable name     */
  int            shvnaml;          /* Length of variable name      */
  void          *shvvala;          /* Address of value buffer      */
  int            shvvall;          /* Length of value buffer       */
                                   /* (Set on fetch)      */
};
 
#define shvcodes          _shvblock_union1._shvcodes
#define shvcode           _shvblock_union1._shvblock_struct1._shvcode
#define shvret            _shvblock_union1._shvblock_struct1._shvret
 
struct subcomtb_header {
  SUBCOMTB_ENTRY *subcomtb_first;    /* Address of the first SUBCOMTB          */
                                    /*                                        entry     */
  int            subcomtb_total;    /* Total number of SUBCOMTB entries       */
  int            subcomtb_used;     /* Number of used SUBCOMTB entries        */
  int            subcomtb_length;   /* Length of each SUBCOMTB entry          */
  unsigned char  subcomtb_initial[8]; /* Name of the initial subcommand         */
  unsigned char  _filler1[8];       /* Reserved           */
  unsigned char  subcomtb_ffff[8];  /* End marker - hex   */
                                    /* 'FFFFFFFFFFFFFFFF' */
};
 
struct subcomtb_entry {
  unsigned char  subcomtb_name[8];  /* Name of the subcommand       */
  unsigned char  subcomtb_routine[8]; /* Name of the subcommand routine */
  unsigned char  subcomtb_token[16]; /* Subcommand token   */
};
 
struct workblok_ext {
  EXECBLK       *workext_execblk;   /* Address of the EXECBLK       */
  ARGTABLE_ENTRY *workext_argtable; /* Address of the first ARGTABLE          */
                                    /* entry     */
  unsigned char  workext_flags1;    /* First byte of flags          */
  unsigned char  _filler1[3];       /* Exec is a command  */
                                    /* Exec is a function           */
                                    /* Exec is a subroutine         */
                                    /* Reserved           */
  INSTBLK       *workext_instblk;   /* Address of the INSTBLK header          */
  void          *workext_cpplptr;   /* Address of the CPPL     @PEI0853       */
  void          *workext_evalblock; /* Address of the REXX user     */
                                    /* EVALBLOCK           */
  void          *workext_workarea;  /* Address of the workarea header         */
                                    /* containing the address and    */
                                    /* length of a workarea containing */
                                    /* the storage to be used for the  */
                                    /* new WORKBLOK and WORKBLOK_EXT   */
  void          *workext_userfield; /* Address of a user field @PEI0853       */
  int            workext_rtproc;    /* A fullword for use by  @E23X2BJ        */
                                    /* a Compilers Runtime    @E23X2BJ */
                                    /* Processor              @E23X2BJ */
  void          *workext_source_address; /* The address of the     @E23X2BJ        */
                                         /* PARSE SOURCE string    @E23X2BJ */
  int            workext_source_length; /* The length of the      @E23X2BJ        */
                                        /* PARSE SOURCE string    @E23X2BJ */
  int            _filler2;          /* Reserved               @E23X2BJ        */
};
 
struct uexitcom {           /* User exit common area                                              */
  int ledsa_addr;           /* Last LE DSA address for user exit callback support                 */
                            /* <<< DO NOT MOVE THIS FIELD WITHOUT UPDATING THE IDICRXLE CSECT >>> */
  char *exittype;           /* Exit type                                                          */
  ENV *penv;                /* Pointer to ENV structure                                           */
  ENVBLOCK *c_envblock;     /* REXX ENVBLOCK address                                              */
  ENVBLOCK *c_envblock_copy;/* Address of ENVBLOCK copy for overlay detection                     */
  void *parmptr;            /* Pointer to exit-specific structure (LST, XPL, etc.)                */
  F_IRXEXCOM *ep_irxexcom;  /* IRXEXCOM module EP address                                         */
  F_IRXEXEC *ep_irxexec;    /* IRXEXEC module EP address                                          */
  void *wa_ptr;             /* Compiler Listing Read user exit:                                   */
                            /*   Temporary compiler listing file workarea address (if open)       */
                            /* Message and Abend Code Explanation user exit:                      */
                            /*   Address of udata buffer                                          */
                            /* Formatting user exit:                                              */
                            /*   Address of UFM_WRK data area                                     */
  int write_disabled : 1;   /* Write (data pass-back) disabled                                    */
  int xtrace_noprint : 1;   /* Exit tracing disabled                                              */
  int debug : 1,            /* Debug mode                                                         */
      trace : 1,            /* Trace mode                                                         */
      first_write : 1;      /* Flag used to determine if performing the first write (IDIWRITE)    */
                            /* for an exit that passes back record data (Listing or Explanation). */
                            /* If 0, first write has not been performed.                          */
  INSTBLK instblk;          /* INSTBLK used when creating dynamic EXECs for exit trace            */
  int instent_alloclen;     /* Allocated length of INSTBLK_ENTRY section                          */
  int dynexec_alloclen;     /* Allocated length of in-storage REXX exec buffer                    */
  char ddtempy[9];          /* Temporary PDS data set allocation DDname                           */
  char ddtempz[9];          /* Temporary PDS member allocation DDname                             */
  int zzrexxdbg : 1;        /* ZZREXXDBG option setting                                           */
};
