/*********************************************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2005. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDIPH.H                                                       */
 
struct PAGEHDR;
typedef struct PAGEHDR PAGEHDR;
 
#define REPORTWIDTH    pPcom->linewidth     /* Current report width  */
#define STDREPORTWIDTH opts.pfw             /* Standard report width */
#define MAXREPORTWIDTH pPcom->report_lrecl  /* Maximum report width  */
#define LIMREPORTWIDTH 132                  /* Report width limit    */
 
/*********************************************************************/
/*   API Structure Definitions                                       */
/*********************************************************************/
 
struct PAGEHDR {
  char hdr[81];
};
 
char FastPathCommand[50];
int  FastPathEntered = 0;
 
/*********************************************************************/
/*   API Function Definitions                                        */
/*********************************************************************/
 
/******************************************************************************/
/*|:h4.ShowCicsTrace()                                                        */
/*|:p.This function is used to select and display entries in the internal     */
/*|CICS trace. It may be passed a task number in which case this task         */
/*|will default into the task selection.                                      */
/*|:xmp.*/
void ShowCicsTrace(int task);
/*|:exmp.*/
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.task                                                          */
/*|:dd.CICS task number.                                             */
/*|:edl.                                                             */
 
/******************************************************************************/
/*|:h4.pBatchReport()                                                         */
/*|:p.This function is used to print a batch analysis report.                 */
/*|If pDDfHist is not NULL during real-time processing, the report is written */
/*|to the history file using HistWrite and this DDf work area pointer.        */
/*|:xmp.*/
void pBatchReport(char *pDDfHist);
/*|:exmp.*/
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.pDDfHist                                                      */
/*|:dd.File pointer.                                                 */
/*|:edl.                                                             */
 
/******************************************************************************/
/*|:h4.pConfirmOpen()                                                         */
/*|:p.This function is used to prompt the user during interactive reanalysis  */
/*|whether or not to open the SYSMDUMP.  A zero return code indicates that no */
/*|open should be performed.                                                  */
/*|:xmp.*/
int pConfirmOpen(void);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.pISPFreport()                                                 */
/*|:p.This function is used to produce the interactve dump analysis  */
/*|report.                                                           */
/*|:xmp.                                                             */
void pISPFreport(void);
/*|:exmp.                                                            */
 
/*********************************************************************/
/*|:h4.ListingPrompt()                                               */
/*|:p.Prompt the user to supply missing compiler listing or side     */
/*|file.                                                             */
/*|:xmp.                                                             */
char *ListingPrompt(XCSECT *pxc, char *pgmname,int POFProgram,int pofflag);
/*|:exmp.                                                            */
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.pxc                                                           */
/*|:dd.Pointer to XCSECT structure.                                  */
/*|:dt.pgmname                                                       */
/*|:dd.Null-terminated program name.                                 */
/*|:edl.                                                             */
/*|:h5.Return values:                                                */
/*|:dl break=fit.                                                    */
/*|:dt.NULL                                                          */
/*|:dd.Continue without listing                                      */
/*|:dt."" (NULL string)                                              */
/*|:dd.Search again                                                  */
/*|:dt."tDD:ddname(mbrname)"                                         */
/*|:dd.DDname of temporary dataset containing listing or side file   */
/*|member.                                                           */
/*|:p.:pv.t:epv. is L for a listing (os SYSADATA file) or X for a    */
/*|side file.                                                        */
/*|:nt.The DDname must be unallocated by the caller.                 */
/*|:ent.                                                             */
/*|:dt."tdsname(mbrname)"                                            */
/*|:dd.Data set and member name containing listing or side file.     */
/*|:p.:pv.t:epv. is L for a listing (os SYSADATA file) or X for a    */
/*|side file.                                                        */
/*|:edl.                                                             */
/*|:nt.The caller is responsible for free'ing the returned buffer.   */
/*|:ent.                                                             */
 
/*********************************************************************/
/*|:h4.ListingMismatchPopup()                                        */
/*|:p.Follows ListingPrompt() if compiler listing or sidefile fails  */
/*|any signature check. The user may press ENTER to continue with    */
/*|listing/sidefile, or F12 to return to the listing prompt.         */
/*|:xmp.                                                             */
int ListingMismatchPopup(XCSECT *pxc, char *pgmname, void *foundp);
/*|:exmp.                                                            */
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.pxc                                                           */
/*|:dd.Pointer to XCSECT structure.                                  */
/*|:dt.pgmname                                                       */
/*|:dd.Null-terminated program name.                                 */
/*|:edl.                                                             */
 
/*********************************************************************/
/*|:h4.program_name()                                                */
/*|:p.This function is used to return the program name based on an   */
/*|XCSECT structure.                                                 */
/*|:xmp.                                                             */
char *program_name(XCSECT *pxc);
/*|:exmp.                                                            */
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.pxc                                                           */
/*|:dd.XCSECT structure pointer.                                     */
/*|:edl.                                                             */
 
/*********************************************************************/
/*|:h4.ppStart()                                                     */
/*|:p.Start a dynamic panel.                                         */
/*|:xmp.                                                             */
PPTOKEN *ppStart(char *keyName);
/*|:exmp.                                                            */
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.keyName                                                       */
/*|:dd.Name of key data item containing the panel definition, or     */
/*|NULL.                                                             */
/*|:edl.                                                             */
 
/*********************************************************************/
/*|:h4.ppAdd()                                                       */
/*|:p.Add text to a dynamic panel.                                   */
/*|:xmp.                                                             */
void ppAdd(PPTOKEN *ppToken, char *psz);
/*|:exmp.                                                            */
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.ppToken                                                       */
/*|:dd.Pointer to PPTOKEN.                                           */
/*|:dt.psz                                                           */
/*|:dd.Null-terminated string containing text and/or tags.           */
/*|:edl.                                                             */
 
/*********************************************************************/
/*|:h4.ppEnd()                                                       */
/*|:p.End a dynamic panel.                                           */
/*|:xmp.                                                             */
KANCHOR *ppEnd(PPTOKEN *ppToken);
/*|:exmp.*/
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.ppToken                                                       */
/*|:dd.Pointer to PPTOKEN.                                           */
/*|:edl.                                                             */
 
/*********************************************************************/
/*|:h4.PointsTo()                                                    */
/*|:p.PointsTo() returns a malloc'ed string containing information   */
/*|about what a pointer points to.                                   */
/*|:xmp.*/
char *PointsTo(int ptr,
               int *bytes_before,
               int *bytes_after,
               int *line,
               int *stmt,
               int *inMod,
               int relno,
               int addAvail,
               int symInfo,
               int check,
               int pp_style,
               IANCHOR **ret_pIA);
/*|:exmp.*/
/*|:p.Arguments:                                                     */
/*|:dl break=fit.                                                    */
/*|:dt.ptr                                                           */
/*|:dd.Logical address.                                              */
/*|:dt.bytes_before                                                  */
/*|:dd.If not NULL, the offset from the start of the item pointed to */
/*|by ptr is returned.                                               */
/*|:dt.bytes_after                                                   */
/*|:dd.If not NULL, the remaining length of the item pointed to by   */
/*|ptr is returned.                                                  */
/*|:dt.line                                                          */
/*|:dd.If not NULL, the line number (if available) matching a source */
/*|code line is returned.                                            */
/*|:dt.stmt                                                          */
/*|:dd.If not NULL, the statement number (if available) matching a   */
/*|compiler listing statement is returned.                           */
/*|:dt.inMod                                                         */
/*|:dd.If not NULL, the integer pointed to will be set to 1 if the   */
/*|passed address is within a load module.                           */
/*|:dt.addAvail                                                      */
/*|:dd.If set to 1, the amount of available/addressable storage is   */
/*|appended unconditionally to the returned string.                  */
/*|:dt.symInfo                                                       */
/*|:dd.If set to 1, then symbol resolution will be provided.         */
/*|:dt.check                                                         */
/*|:dd.If set to 1, then the number of bytes of invalid or           */
/*|addressable storage is returned in the description.               */
/*|:dt.pp_style                                                      */
/*|:dd.If set to 1, then the returned string will contain tags       */
/*|suitable for use with PP panels (ppAdd).                          */
/*|:dt.ret_pIA                                                       */
/*|:dd.If not NULL, then the IANCHOR address used when determining   */
/*|source line or statement number is returned.                      */
/*|:edl.                                                             */
/*|:nt.It is the caller's responsibility to free the returned        */
/*|pointer.                                                          */
/*|:ent.                                                             */
 
/*********************************************************************/
/*|:h4.RefreshPrompt()                                               */
/*|:p.Display panel to ISPF user for fault entry save options.       */
/* void RefreshPrompt(EPC *pEPC);  \* *SW* using typecasting for now... */
/*|:xmp.                                                             */
void RefreshPrompt(void *pEPC, char *panel);
/*|:exmp.*/
/*|:h5.Arguments:                                                    */
/*|:dl break=fit.                                                    */
/*|:dt.pEPC                                                          */
/*|:dd.Pointer to EPC structure.                                     */
/*|:dt.panel                                                         */
/*|:dd.ISPF panel to use.                                            */
/*|:edl.                                                             */
 
/*********************************************************************/
/*|:h4.TocOpt5()                                                     */
/*|:p.Create "Abend Job Information" display                         */
/*|:xmp.                                                             */
int TocOpt5(void);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.Toc_Options_in_Effect()                                       */
/*|:p.Create "Options in Effect" display.                            */
/*|:xmp.                                                             */
int Toc_Options_in_Effect(void);
/*|:exmp.*/
 
/*********************************************************************/
/*|:h4.Uexit_Fmt()                                                   */
/*|:p.Call the User Formatting Exits.                                */
/*|:xmp.                                                             */
int Uexit_Fmt(char *execname);
/*|:exmp.*/
 
void pInit(void);
void ReportCopyrightNotice(char *pDDfwH);
void ReportDeferredInfo(char *pDDfwH);
void DisplayIPVInitialPanel(void);
char* ISIPV(void);
char *CallformatSummary( void);
