/* Fault History record SEGMENT mapping ******************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/******************************************************************************************************************/
 
#define DDIR_REC_SIZE 10000  /* Maximum data length of history file records. */
 
 
#define CURRENT_HD_LEVEL 4   /* Current HD segment level             */
#define CURRENT_MH_LEVEL 1   /* Current MH segment level             */
 
struct DDIR_POF ;
typedef struct DDIR_POF DDIR_POF ;
 
struct DDIR_DATA_CM ;
typedef struct DDIR_DATA_CM DDIR_DATA_CM ;
 
struct DDIR_DATA_CD ;
typedef struct DDIR_DATA_CD DDIR_DATA_CD ;
 
struct DDIR_DATA_MH ;
typedef struct DDIR_DATA_MH DDIR_DATA_MH ;
 
struct DDIR_DATA_MC ;
typedef struct DDIR_DATA_MC DDIR_DATA_MC ;
 
struct DDIR_DATA_ML ;
typedef struct DDIR_DATA_ML DDIR_DATA_ML ;
 
struct DDIR_BINDER ;
typedef struct DDIR_BINDER DDIR_BINDER ;
 
struct DDIR_DATA_JE ;
typedef struct DDIR_DATA_JE DDIR_DATA_JE ;
 
struct DDIR_DATA_RT ;
typedef struct DDIR_DATA_RT DDIR_DATA_RT ;
 
struct DDIR_DATA_IT ;
typedef struct DDIR_DATA_IT DDIR_DATA_IT ;
 
struct DDIR_DATA_CC ;
typedef struct DDIR_DATA_CC DDIR_DATA_CC ;
 
struct DDIR_DATA_C3 ;
typedef struct DDIR_DATA_C3 DDIR_DATA_C3 ;
 
struct DDIR_DATA_CT ;
typedef struct DDIR_DATA_CT DDIR_DATA_CT ;
 
struct DDIR_DATA_D2 ;
typedef struct DDIR_DATA_D2 DDIR_DATA_D2 ;
 
struct DDIR_DATA_LT ;
typedef struct DDIR_DATA_LT DDIR_DATA_LT ;
 
struct DDIR_DATA_KD ;
typedef struct DDIR_DATA_KD DDIR_DATA_KD ;
 
struct DDIR_DATA_MD ;
typedef struct DDIR_DATA_MD DDIR_DATA_MD ;
 
struct DDIR_DATA_IA ;
typedef struct DDIR_DATA_IA DDIR_DATA_IA ;
 
struct DDIR_DATA_GD ;
typedef struct DDIR_DATA_GD DDIR_DATA_GD ;
 
struct FND ;
typedef struct FND FND ;
struct IFND ;
typedef struct IFND IFND ;
struct IFNDA ;
typedef struct IFNDA IFNDA ;
struct IFNDSTAT ;
typedef struct IFNDSTAT IFNDSTAT ;
struct IFNDEVENT;
typedef struct IFNDEVENT IFNDEVENT;
struct DSSRII ;
typedef struct DSSRII DSSRII ;
 
/**********************************************************************
     Fault History record segment definitions
   IDIXHSEG $$SYNC IDIXCSEG.COPY
   IDIXHSEG $$SYNC IDIS$NDX.XSAMPLES
   These History File segment structures need to be kept in sync
   with the dsects in IDIXCSEG.COPY and IDIS$NDX.XSAMPLES.
   DDIR_SHDR is a 2 byte length of segment followed by a 2 byte ID.
   The first record in a fault member must be a HD segment.
   The HI segment fixed length fields are followed by _Off based
   fields.
   The HD contents with all _Off based fields set to zero are written
   to the $$INDEX member to form the cache used in the ISPF display.
   In the $$INDEX member the HD segments come after the
   IC Index Control segment which carries the fault prefix characters
   for this HIST file.
 
 **********************************************************************/
/* Fault History File     Point-of-failure info                       */
/* NOTE: Any changes made to this structure should also be made to    */
/*       the CICSSYSABEND_POF struct in IDIEH.H ($$SYNC).             */
struct DDIR_POF {                   /* Included in HD segment         */
  unsigned  DDirPofOffset;          /* CSECT offset                   */
  char      DDirPofModBDate[8];     /* Module bind date (YYYYDDD)     */
  char      DDirPofModBTime[7];     /* Module bind time (HHMMSS)      */
  char      DDirPofCsect[9];        /* CSECT name (null term)         */
  char      DDirPofModule[9];       /*Module name (var len, null term)*/
  char      DDirPofPrOrCs[1];       /* P=Program C=Csect              */
  char      DDirPofReserved[2] ;    /*                                */
};
 
/* Fault History File     record segment header                       */
struct DDIR_SHDR {
  short DDirLength;  /* Length of segment data including this         */
  char  DDirType[2]; /* Record Type HD, MH, MC, MI, ML                */
                     /* 4-byte header                                 */
};
 
/* DDirHdLevel = 01 was introduced with the addition of the index     */
/* record, but should only be updated in the future for compatibility */
/* reasons.                                                           */
/* DDirHdLevel = 02 was introduced to expand the fixed portion UsrName*/
/* DDirHdLevel = 03 was introduced Nov 2004 to change the usage of    */
/* the DDirHdType, DDirHdJType, and DDirHdAbend fields.               */
/* DDirHdLevel = 04 was introduced with V6.1 GA (Nov 2005) to change  */
/* DDirHdMdPages from a short to an int.                              */
struct DDIR_DATA_HD {   /* Always the first record in a Fault member. */
  DDIR_SHDR DDirHdHdr;              /* Header  ll,"HD"                */
  char      DDirHdLevel;            /* See CURRENT_HD_LEVEL           */
  char      DDirHdClock[8];         /* TOD Clock                      */
  char      DDirHdJobname[9];       /* Job Name                       */
  char      DDirHdTsName[9];        /* Abending CVTSNAME              */
  char      DDirHdOFaultID[9];      /* faultID when fault was created */
  char      DDirHdCFaultID[9];      /* faultID now (updated in $$index*/
  char      DDirHdAModNm[9];        /* Abending Module Name           */
  char      DDirHdUid[9];           /* Userid 8 bytes +null if needed */
  char      DDirHdJobID[9];         /* JES JOBID e.g. JOB01234        */
  char      DDirHdTranID[9];        /* Transaction ID                 */
  char      DDirHdTranNO[9];        /* Transaction Number             */
  char      DDirHdPgmNm[9];         /* executing pgm name (EXEC PGM=) */
  char      DDirHdType;             /* Fault entry type:                      */
                                    /* DDirHdLevel 1 and 2 ********************/
                                    /* X'00': Batch                           */
                                    /* X'01': CICS transaction                */
                                    /* X'02': Dump registration               */
                                    /* DDirHdLevel 3 **************************/
                                    /* X'00': Normal (complete)               */
                                    /* X'01': Dump registration               */
                                    /* X'02': Deferred report                 */
                                    /* (Above values provided as #define's    */
                                    /* following this structure)              */
  DDIR_POF  DDirHdPof;              /* DDIR_POF structure             */
  char      DDirHdJType;            /* Job type:                              */
                                    /* DDirHdLevel 1 and 2 ********************/
                                    /* X'01': Batch job                       */
                                    /* X'02': Started task                    */
                                    /* X'03': TSO user                        */
                                    /* DDirHdLevel 3 **************************/
                                    /* B'1000 ....': Batch job                */
                                    /* B'0100 ....': Started task             */
                                    /* B'0010 ....': TSO user                 */
                                    /* B'.... 1000': CICS transaction abend   */
                                    /* B'.... 0100': CICS system dump         */
                                    /* (Above values provided as #define's    */
                                    /* following this structure)              */
  char      DDirHdJClass;           /* Job execution class                    */
  char      DDirHdDSNf;             /* SYSMDUMP DSN flag ff=suppress..        */
  char      DDirHdAbendFormat;      /* Specifies the format of DDirHdAbend    */
                                    /* (introduced with DDirHdLevel 3,        */
                                    /* reserved earlier):                     */
                                    /* X'01': 3-byte MVS abend code (12-bit   */
                                    /*        system abend code + 12-bit user */
                                    /*        abend code) followed by 1       */
                                    /*        reserved byte.                  */
                                    /* X'02': 4-char CICS transaction abend   */
                                    /*        code.                           */
                                    /* X'03': 6-char CICS system abend code:  */
                                    /*        Byte 0+1: First two characters  */
                                    /*                  of CICS abend code.   */
                                    /*        Byte 2+3: Hexadecimal halfword  */
                                    /*                  representation of the */
                                    /*                  remaining 4-digit     */
                                    /*                  abend code suffix.    */
                                    /* X'04': 4-char IDISNAP identifier       */
                                    /*        "SNAP".                         */
                                    /* (Above values provided as #define's    */
                                    /* following this structure)              */
  short     DDirHdMdPages_old;      /* DDirHdLevel 1, 2 and 3 *****************/
                                    /* Expected # of minidump pages           */
                                    /* DDirHdLevel 4 **************************/
                                    /* Unused (replaced by an int).           */
  short     DDirHdDupCount;         /* count of duplicates, this fault        */
  short     DDirHdCacheIndex;       /* HIST DSN index when cached.            */
  short     DDirHdReserved3;        /*                                        */
  unsigned  DDirHdAbend ;           /* Abend code.                            */
                                    /* DDirHdLevel 1 and 2 ********************/
                                    /* If DDirHdType=1, then a 4-char         */
                                    /* CICS abend code. Otherwise,            */
                                    /* 3-byte abend code (12-bit              */
                                    /* system abend code + 12-bit user        */
                                    /* abend code) followed by 1 flag         */
                                    /* byte: 1... .... - user abend           */
                                    /*       .111 1111 - reserved             */
                                    /* DDirHdLevel 3 **************************/
                                    /* Interpreted using DDirHdAbendFormat.   */
  void     *DDirHdSDWA;             /* Address of SDWA copy           */
  void     *DDirHdCIBp;             /* LE CIB pointer if call from LE */
  char      DDirHdStepname[9];      /* Step Name                      */
  char      DDirHdRes[7];           /* reserved for future, set zero. */
  short     DDIRHdExitName_Off;     /* Name of Exit that invoked FA   */
  short     DDIRHdPLIDSA_Off;       /* PL/I DSA addr + 2 byte oncode. */
  short     DDirHdDSN_Off;          /* SYSMDUMP DSN offset, now in fixed segment DDirHDSYSDDSN Aug2006 */
  short     DDirHdAcct_Off;         /* offset to accounting info      */
                                    /* (145 chars consisting of JCT   */
                                    /* fields ACTJNFLD and ACTACCNT)  */
  short     DDirHdFreeSpaceSize;    /* size of freespace at the _Off  */
  short     DDirHdFreeSpace_Off;    /* offset to freespace at the end */
                                    /* of this segment. (initial 512) */
  char      DDirHdUsrName[9];       /* User updatable name field      */
  char      DDirHdImsPrgName[9];    /* IMS DFSPRPX0.RCPGM program     */
  char      DDirHdUsrTitle[41];     /* User updatable title field     */
  char      DDirHdReserved2;        /*                                */
  char      DDirHdLock;             /* If not 0, lock fault entry     */
  char      DDirHdApplID[9];        /* Applid (CICS)                  */
  char      DDirHdTermId[5];        /* Termid (CICS)                  */
  char      DDirHdNetName[9];       /* Netname (CICS)                 */
  char      DDirHdDupClock[8];      /* TOD Clock from most recient Dup*/
  short     DDirHdSubSeg_Off;       /* offset to the first duplicate  */
                                    /* sub-segment entry in $$INDEX HD*/
  char      DDirHdAceeGRPN[9];      /* ACEEGRPN DFLTGRP default group */
  char      DDirHdIAbendFormat;     /* Specifies the format of DDirHdIAbend   */
                                    /* (see DDirHdAbendFormat).               */
  unsigned  DDirHdMdPages;          /* Expected # of minidump pages (introduced with DDirHdLevel 4) */
  int       DDirHdCPUhsec;          /* CPU hundredths of a seconds at report end */
  unsigned  DDirHdIAbend;           /* Invocation abend code interpreted      */
                                    /* using DDirHdIAbendFormat.              */
                                    /* Early code in IDICMAIN copies the      */
                                    /* DDirHdAbend and DDirHdIAbendFormat     */
                                    /* fields to DDirHdIAbend and             */
                                    /* DDirHdIAbendFormat to preserve the     */
                                    /* invocation abend code.                 */
  char      DDirHdSYSDDSN[45];      /* SYSMDUMP DSN now in fixed segment Aug2006 */
  char      DDirHdReserved[91];     /* Reserved fixed portion                    */
  char      DDirHdTIME[16];         /* $$ZAP temp TIME value (PMR 28462,075,724) */
  char      DDirHdSTCK[8];          /* $$ZAP temp STCK value (PMR 28462,075,724) */
};
/* Flag values for DDirHdType */
#define HDTYPENORMAL       0x00
#define HDTYPEDUMPREG      0x01
#define HDTYPEDEFERRED     0x02
#define HDTYPEFLUSH        0x03
/* Flag values for DDirHdJType */
#define HDJTYPEBATCH       0x80     /* Note: Bits 0-3 only            */
#define HDJTYPESTC         0x40     /* Note: Bits 0-3 only            */
#define HDJTYPETSO         0x20     /* Note: Bits 0-3 only            */
#define HDJTYPECICSTRAN    0x08     /* Note: Bits 4-7 only            */
#define HDJTYPECICSSYS     0x04     /* Note: Bits 4-7 only            */
/* Flag values for DDirHdAbendFormat */
#define HDABENDFORMATMVS   0x01
#define HDABENDFORMATCICS4 0x02
#define HDABENDFORMATCICS6 0x03
#define HDABENDFORMATSNAP  0x04
 
struct       IFNDSTAT {       // ImageFast
  char       ITOD[8];         // LoclTime corrected TOD clock at last update
  int        ICount;          // aIFND accumulated dups since last cleared
  char       IFAULTID[9];     // failtID of problem
  char       IHISTDSN[45];    // histDSN of problem
  char       Pad[2];          // padding fullword align
} ;
 
struct       IFNDEVENT {      // ImageFast EVENT data passed from invocation exit.  In the aIFND this is
                              // replaced/overlayed by the start of the Dss/DSUBSEG repeats
  char       IfeUserID[9];    //
  char       IfeTermID[9];    //
} ;
 
struct DSUBSEG {           /* Duplicate Sub Segment appended to HD segments */
  short     DssLength;     /* Lenght including all repeat elements, see DssRepeatType */
  char      DssType;       /* 'D'=this DSUBSEG type, hopefully the only one we have to define */
  char      DssClock[8];   /* TOD Clock                      */
  char      DssJobname[9]; /* Job Name                       */
  char      DssJobID[9];   /* JES JOBID e.g. JOB01234        */
  char      DssTsName[9];  /* Abending CVTSNAME              */
  short     DssDupCount;   /* Dup count recorded this Dss. =1 unless CICS FAST nodup       */
  char      DssReserved;   /* */
  char      DssRepeatType; /* Defines the layout of potentially repeating data that follows */
                           /* 'N'=Normal dup, one only 8byte UserID+8byte stepID */
                           /* 'F'=Fast, CICS segment. 8byte userID+4byte trmID+2byte count+2byte rsv*/
                           /* The 'F' 16 byte repeats complete when DssLength is exhausted */
};
 
struct       DSSRII {         // the DSSRII is a Dss folowed by one IMAGEfast IMS repeat element.
  DSUBSEG    D;               // Dss start DssRepeatType=='I'
  char       userid[8];       //
  char       termid[4];       //
  short      count;           //
  short      resv;            //
} ;
 
/* the IFND data containes the signature for fast matching and the data to build DSUBSEG HD segment additions */
struct       IFND {           // Image Fast Path No Dup structure
  short      sig_ll;          // length of sig_data +2. The sig_ll length should be equal or less than
  char       sig_data[190];   // the length of signature data up to IFAULTID. $$SYNC190
  IFNDSTAT   S;               // TOD-faultID-histDSN
  IFNDEVENT  E;               // ImageFast IFNDEVENT positioned here for an IFND from an invocation exit.
  // In the aIFND the IFNDEVENT E; is overlayed by a series of DSUBSEG/DSSRII structures.
} ;
 
/* the IFNDA is the version of struct IFND that populates the aIFND array, it contains area for the Dss entries.*/
struct       IFNDA {          // Image Fast Path No Dup structure
  short      sig_ll;          // length of sig_data +2. The sig_ll length should be equal or less than
  char       sig_data[190];   // the length of signature data up to IFAULTID. $$SYNC190
  IFNDSTAT   S;               // TOD-faultID-histDSN
  DSSRII     A[20];
} ;
 
/* Fault History File     Console Message CN/CM single/multiline      */
struct DDIR_DATA_CM {
  DDIR_SHDR DDirCmHdr;              /* Header  ll,"CM" | "CN"         */
  char      DDirCMTime[11];         /* HH:MM:SS:hh                    */
  char      DDirCMText[1];          /* Message Text TO LENGTH OF SEGMENT.*/
};
 
/* Fault History File     Console Message CE/CD multiline messages    */
struct DDIR_DATA_CD {
  DDIR_SHDR DDirCDHdr;              /* Header  ll,"CE" | "CD"         */
  char     DDirCDResved[3];         /*                                */
  char     DDirCDText[1];           /* Message Text TO LENGTH OF SEGMENT.*/
};
 
/* Fault History Binder Information                                   */
struct DDIR_BINDER {
  char  DDirBinderId[10];           /* Binder identification          */
  char  DDirBinderVer[2];           /* Version                        */
  char  DDirBinderRel[2];           /* Release                        */
  char  DDirBinderDate[7];          /* Date of Binding YYYYDDD        */
  char  DDirBinderTime[6];          /* Time of Binding HHMMSS         */
};
 
/* Fault History File     module header record JPA and LPA            */
struct DDIR_DATA_MH {
  DDIR_SHDR    DDirMhHdr;           /* Header  ll,"MH"                */
  char         DDirMhLevel;         /* See CURRENT_MH_LEVEL           */
  char         DDirMhRes1;          /* Reserved                       */
  short        DDirMhAliasT_Off;    /* Truename if module is an alias */
  short        DDirMhFlags ;        /* Module flags 0x0001 = LPA modul*/
               /* All the following fields are offsets to the data    */
               /* if it is present, else zero. The offset is from     */
               /* the start of the data portion i.e. DDIR_SHDR +4.     */
  short        DDirMhModname_Off ;  /* Module name (8 bytes)          */
  short        DDirMhDSN_Off ;      /* loaded from DSN (44 bytes)     */
  short        DDirMhLoadDD_Off ;   /* loaded from DD: (8 bytes)      */
  short        DDirMhPath_Off ;     /* Path (null terminated path)    */
  short        DDirMhBinder_Off ;   /* Binder ID/Date/Time DDIR_BINDER*/
  short        DDirMhRFNum_Off ;    /* Extent list, This starts with  */
               /* a word for the number of load extents n (normally 1)*/
               /* then an array of n words for the length of each load*/
               /* section then n words for their load address. It is  */
               /* the format provided by csvinfo.                     */
  short        DDirMhDDConcat ;     /* Concatenation number of dataset*/
  short        DDirMhRes_Off1 ;     /* Reserved offset 1              */
  short        DDirMhRes_Off2 ;     /* Reserved offset 2              */
};
 
/* Fault History File     CSECT/ELEMENT/LABEL record                  */
struct DDIR_DATA_MC {
  DDIR_SHDR    DDirMcHdr;           /* Header  ll,"MC"                */
  char         DDirMcType[2];       /* Type SD(old) ED LD             */
  char         DDirMcRMode;         /* Rmode                          */
  char         DDirMcAMode;         /* Amode                          */
  int          DDirMcLeng;          /* Length  of section             */
  int          DDirMcSOffset;       /* ESD_Elem_offset (binder element*/
  int          DDirMcMOffset;       /* ESD_Class_offset (binder class)*/
  short        DDirMcRName_Off ;    /* segoffset to Resident name     */
  short        DDirMcName_Off ;     /* segoffset to CSECT/LABEL Name  */
  short        DDIRMcSegID ;        /* load segment id if ED format   */
  short        DDIRMcReserved ;     /* reserved if ED format          */
};
 
/* Fault History Language Processor Record                            */
struct DDIR_DATA_ML {
  DDIR_SHDR    DDirMlHdr;           /* Header  ll,"ML"                */
  char         DDirMlPid[10];       /* Compiler product ID            */
  char         DDirMlVersion[2];    /* Version                        */
  char         DDirMlModLevel[2];   /* Mod Level                      */
  char         DDirMlCompileDate[7];/* Compile Date YYYYDDD           */
  char         DDirMlRName[1];      /* Resident Name (section name) null term. */
};
 
/* Fault History File     History SAF/JES access record               */
struct DDIR_DATA_JE {
  DDIR_SHDR    DDirJeHdr;           /* Header  ll,"JE"                */
  char         DDirJeFlags[2];      /* reserved for flags ?           */
  short        DDirJeReprtVOLID_Off;/* VOLID of the IDIREPRT DD alloc.*/
  short        DDirJeReprtDSN_Off;  /* DSN of the IDIREPRT DD alloc.  */
  short        DDirJeNJEname_Off;   /* NJE system name                */
  short        DDirJeGroupID_Off;   /* GROUPID                        */
};
 
/* Fault History File     real-time segment layout                    */
/* Note that the history record might contain multiple real-time      */
/* segments (type RT).  They will appear in the correct sequence.     */
struct DDIR_DATA_RT {
  DDIR_SHDR    DDirRtHdr;           /* Header  ll,"RT"                */
  char         ddir_rt_resv[3];     /*                                */
  char         ddir_rt_report[1];   /* Real-time analysis report line */
};
 
/* segments (type IT).  Imagefast Trace data                          */
struct DDIR_DATA_IT {
  DDIR_SHDR    DDirItHdr;           /* Header  ll,"IT"                */
  char         ddir_rt_report[1];   /* Imagefast Trace line           */
};
 
/* Fault History File             CICS Transaction Abend data record  */
struct DDIR_DATA_CC {
  DDIR_SHDR    DDirCcHdr;           /* Header  ll,"CC"                */
  int          DDirCcTACB;          /* Pointer to CICS TACB           */
  int          DDirCcTCA;           /* Pointer to CICS user TCA       */
  int          DDirCcTRTp;          /* Pointer to trace NO LONGER USED*/
  void        *DDirCcSAIQ_resv;     /* reserved December 2001         */
  CICS_APIQ   *DDirCcAPIQ;          /* CICS 'INQUIRE_APPLICATION' data*/
  void        *DDirCcPGIS_resv;     /* reserved December 2001         */
  int          DDirCcDFHKCB;        /* DFHKCB address                 */
  int          DDirCcKCB_DOM;       /* KCB_DOMAIN_TABLE address       */
  char         DDirCcCICSREL[4];    /* CICS RELEASE e.g. c'0530'      */
  int          DDirCcPtr4;          /* reserved                       */
  int          DDirCcPtr5;          /* reserved                       */
  int          DDirCcPtr6;          /* reserved                       */
  int          DDirCcPtr7;          /* reserved                       */
  int          DDirCcSnapR13p;      /* R13 of caller of IDISNAP           */
  int          DDirCcpEIB;          /* transaction abend pointer to EIB   */
  int          DDirCcpTCTUA;        /* transaction abend pointer to TCTUA */
  int          DDirCcTCTUASIZE;     /* transaction abend length of TCTUA  */
  int          DDirCcpTWA;          /* transaction abend pointer to TWA   */
  int          DDirCcTWASIZE;       /* transaction abend TWA size         */
};
 
/* Fault History File             CICS 3270 screen buffer record      */
struct DDIR_DATA_C3 {
  DDIR_SHDR    DDirC3Hdr;           /* Header  ll,"C3"                */
  int          DDirC3Rows;          /* Number of screen rows    (24?) */
  int          DDirC3Columns;       /* Number of screen columns (80?) */
  int          DDirC3Size;          /* size of rawbuffer data   (1920?)*/
  int          DDirC3Resv1;         /* reserved                       */
  int          DDirC3Resv2;         /* reserved                       */
  char         DDirC3Resv3[3];      /* reserved                       */
  char         DDirC3RawBuffer[1];  /* 3270 raw buffer(variable length in size)*/
};
 
/* Fault History File             CICS Trace buffer data              */
struct DDIR_DATA_CT {
  DDIR_SHDR    DDirCTHdr;           /* Header  ll,"CT"                */
  char         DDIRCTTimeBase[8];   /* Trace STCK at last local midnight */
  int          DDirCTResv1;         /* reserved                       */
  int          DDirCTResv2;         /* reserved                       */
  int          DDirCTResv3;         /* reserved                       */
  int          DDirCTResv4;         /* reserved                       */
  char         DDirCTResv5[3];      /*                                */
  char         DDirCTBuffer[1];     /* CICS TRACE entries terminated H'0' */
};
 
/* Fault History File             DB2 fetch protected control blocks  */
struct DDIR_DATA_D2 {
  DDIR_SHDR    DDirD2Hdr;           /* Header  ll,"D2"                */
  int          DDirD2_pDB2CCB;      /* address fetch prot. Composite Capability Block */
  short        DDirD2_lDB2CCB;      /* length of           Composite Capability Block */
  short        DDirD2_DB2CCB_Off;   /* offset to           Composite Capability Block */
  int          DDirD2Resv1;         /* reserved                       */
  int          DDirD2Resv2;         /* reserved                       */
  int          DDirD2Resv3;         /* reserved                       */
  int          DDirD2Resv4;         /* reserved                       */
  int          DDirD2Resv5;         /* reserved                       */
};
 
/*                                  LE condition_token message segment*/
struct DDIR_DATA_LT {
  DDIR_SHDR    DDirLtHdr;           /* Header  ll,"LT"                */
  int          DDirLT_CIBa;         /* CIB address cond_token is from */
  char         DDirLTmsg[1];        /* condition_token msg. null term.*/
};
 
 
/* Fault History File Fault Index Segment                             */
/* Note: This segment never appears in the general fault entry        */
/*       records.  It is used only in the $$index member.             */
struct DDIR_DATA_HI {
  DDIR_SHDR    DDirHiHdr;           /* Header  ll,"Hi"                */
  char         DDirHiPrefix[4];     /* 3(max) character faultID prefix*/
  int          DDirHiNextFaultNum;  /* next fault number for failtID  */
  int          DDirHiMaxFaultEntries;/*maximum entries in hist dataset*/
  int          DDirHiReserved :1;   /*                                */
  char         DDirHiLoclTime[8];   /* LoclTime when HI last updated  */
  char         DDirHiCreator[9];    /* program creating HI data       */
  char         DDirHiRes[10];       /* Reserved                       */
};
 
/* Fault History File     Key data segment                            */
struct DDIR_DATA_KD {
  DDIR_SHDR    DDirKdHdr;           /* Header  ll,"KD"                */
  short        DDirKdLength;        /* Key data length                */
  short        DDirKdData_Off;      /* Offset to key data             */
  char         DDirKdResv[3];       /*                                */
  char         DDirKdName[1];       /* Key name (variable length,     */
                                    /* null terminated)               */
};
 
/* Fault History File     MiniDump segment                            */
struct DDIR_DATA_MD {
  DDIR_SHDR    DDirMdHdr;           /* Header  ll,"MD"                */
  int          DDirMdAddr64;        /*                                */
  int          DDirMdAddr31;        /*                                */
  char         DDirMdKey;           /*                                */
  char         DDirMdSubpool;       /*                                */
  char         DDirMdResv[2];       /*                                */
  int          DDirMdASID;          /*                                */
  char         DDirMdData[4096];    /*                                */
};
 
/* Fault History File     MiniDump Invalid Address segment            */
struct DDIR_DATA_IA {
  DDIR_SHDR    DDirIaHdr;           /* Header ll=length of array,"IA" */
  int          DDirIaData ;         /* If high order bit is on, this is pre Feb 2005 AbendASID IA array, else ==0 */
  int          DDirIaASID ;         /* post Feb 2005 ASID of the IA data in DDirIaBEdata */
  int          DDirIaBEdata;        /* INV_ADDR array of Begin End invalid ranges for DDirIaASID */
  /* post Feb 2005 arrays are pure invalid range only, i.e. no additional begin and end for Valid range returns. */
};
 
/* Fault History File     GDA fields segment                          */
struct DDIR_DATA_GD {
  DDIR_SHDR    DDirGdHdr;           /* Header ll=length of array,"GD" */
  int          DDirGdResv;          /* */
  int          DDirGDAPVT;          /* ADDRESS OF START OF PRIVATE AREA */
  int          DDirGDAPVTSZ;        /* SIZE OF THE PRIVATE AREA         */
  int          DDirGDAEPVT;         /* ADDRESS OF START OF PRIVATE AREA - EXTENDED */
  int          DDirGDAEPVTS;        /* SIZE OF THE PRIVATE AREA - EXTENDED         */
};
 
/*$$SYNC IDICALOC.ASSEMBLE */
#define DssFEl  (10*16)             /* space for 10* DupSubSeg FAST elements,  */
                                    /* Userid
8Y+TermID
4Y+count
2Y+resv
2Y=16 */
#pragma map(LocUFND,"LOCUFND")
void LocUFND(FND *, char *faultID, char *histDSN);
#pragma map(LocSFND,"LOCSFND")
void LocSFND( char *histDSN, char *buf, FND *fFND);
 
#pragma map(LocStrFT,"LOCSTRFT")
void LocStrFT(void);
 
#pragma map(LocDetFT,"LOCDETFT")
void LocDetFT(void);
 
#pragma map(LocDSNL,"LOCDSNL")
int LocDSNL( char *DSNLBuffer);
 
#pragma linkage(SETSTMRS,OS)
int SETSTMRS(HISTBUFINFO *pHistBufInfo, int Seconds);
#pragma linkage(RSTSTMRS,OS)
int RSTSTMRS(HISTBUFINFO *pHistBufInfo);
 
/*   End of Fault History record segment definitions                  */
/**********************************************************************/
 
struct STIMERM ;
typedef struct STIMERM STIMERM ;
struct STIMERM { /* $$SYNC for the STIMERM wait/loop intercept control */
  short min;             /* minimum minutes                            */
  short start;           /* start minutes                              */
  short max;             /* maximum minutes                            */
  short current;         /* current minutes                            */
  short Hmin;            /* Highest minimum accepted                   */
  short Lmax;            /* Lowest  maximum accepted                   */
  short ReportLineLimit; /* Report line threshold (x1000) before       */
                         /* doubling timer interval                    */
  short ReportLineCur;   /* Current number of report lines (x1000)     */
                         /* written so far                             */
  short ExpAt;           /* Expiration time and NoLoopProtection       */
  short reservedh;
  int initMS;            /* initial MilliSecond value                  */
  int currentTU;         /* current set Timer Units                    */
  int remainingTU;       /* remaining Timer Units from STIMERM TEST    */
  int amaxD[8];          /* array of maximum Dividers                  */
  int aminD[8];          /* array of minimum Dividers                  */
  int amaxCmp[8];        /* array max compair calculation MS           */
  int actualMS[8];       /* array actual millisecond monitor samples   */
  int aminCmp[8];        /* array min compair calculation MS           */
  int acurrent[8];       /* array currnet minutes after adjustment     */
  int aCPU[8];           /* array CPU miliseconds from TCBTTIME        */
};
 
/*******************************************************************************/
/* The IDI0092x C writable static GLOBAL (yuck), is defined here for some      */
/* clarity of its relationship with pIDI0092x which points to it out of        */
/* HISTBUFINFO.  It is the pIDI0092x pointer in HISTBUFINFO that gives us the  */
/* assembler access so the STIMERM can set the field in writable static.       */
int IDI0092x = 0;        /* if (IDI0092x) exit(8); // EXIT NOW                 */
 
/*******************************************************************************/
/*|:h4.HISTBUFINFO                                                             */
/*|IDIXHSEG.H $$SYNC IDIXCSEG.COPY for HISTBUFINFO                             */
/*|The character-format address passed in the REALTIME option is the address of*/
/*|a HISTBUFINFO structure                                                     */
/*|The first 5 words are used for the HIST buffer management                   */
/*|The BUFSTARTX and GETMSZX are for the exits to maintain, they               */
/*|keep BUFSTART and BUFSTARTX in sync but inly initilize GETMSZX              */
/*|leaving GETMSZ zero, then the LE code at first reallocation                 */
/*|sees GETMSZ is zero and does not try and free BUFSTART for the              */
/*|first reallocation.  There after the LE code uses BUFSTART and              */
/*|GETMSZ only.  This seperates the allocation and free mechanizms             */
/*|of the exits from the IDIDA function.  The exit frees on return, but only   */
/*|what it had allocated.  IDIDA frees its buffer before return to the exit.   */
/*|:xmp.*/
struct HISTBUFINFO {
  int   hist_bufstart;   /* History record buffer start address  */
  int   hist_getmsz;     /* History record buffer size           */
  int   hist_bufcurr;    /* Address of next segment for COMITSEG */
  int   hist_bufmaxseg ; /* space allowed for each new segment   */
  int   hist_bufstartx;  /* eXit History rec buffer start address*/
  int   hist_getmszx;    /* eXit History record buffer size      */
  int   suppress_dump;   /* If not 0, suppress dump              */
  int   mtracea ;        /* address of CSA for MTRACE            */
  int   mtracel ;        /* length of CSA for Mtrace             */
  FND  *pFastNoDup;      /* Pointer to Fast NoDup entry for fault*/
  int   abort_flag;      /* If non-zero, processing aborted:     */
                         /*   1 = short on storage               */
                         /*   2 = unsupported environment        */
  char  curr_lang[4];    /* Current language                     */
  int   cush24addr;      /* 24-bit storage cushion address       */
  int   cush24len;       /* 24-bit storage cushion length        */
  int   cush31addr;      /* 31-bit storage cushion address       */
  int   cush31len;       /* 31-bit storage cushion length        */
  int   ExitWaitECB;     /* STIMERM exit termination WAIT ECB    */
  int   ExitSTIMERMid;   /* STIMERM id                           */
  short *pExitWTO;       /* STIMERM expiration WTO for IDI0092S  */
  STIMERM *pSM;          /* STIMERM control data in STIMERM key  */
  int   ExitSTIMERMidS;  /* Short term STIMERM id                */
  char  DDSlotArray[180];/* 20 x 8byte (null terminated) DDNAMEs */
                         /* i.e. 20x9 bytes = 180                */
  int  *pIDI0092x;       /* STIMERM IDI0092 eXpiration flag ptr. */
  int   WORK16F[16];     /* 16 fullword workarea                 */
  int   EqauedatEP;      /* EQAUEDAT entry point passed to IDIDA */
                         /* from EXEC CICS LOAD in IDIXCX53      */
  int   SegScan_Off;     /* XpoplSegScan offset from hist_bufstart*/
  int*  pLoopProtection; /* STIMERM ptr to opts.LoopProtection   */
  int   reserved[8];     /*                                      */
};
/*|:exmp.*/
