/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.datatypeconverters.FMIAlphaNumericDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;

public class DefaultField
extends Field {
    private int defaultWidth;

    public DefaultField() throws FMIConversionException {
        super("Default", 1, 1, -22, 0, 1, false, new FMIAlphaNumericDataTypeConverter(), null);
        this.recordOffset = 0;
        this.defaultWidth = -1;
        this.startLayoutIndex = 0;
        this.endLayoutIndex = 0;
    }

    public void setDefaultValue() throws FMIModelException {
        byte[] defaultEbcdic = this.converter.getDefaultValue(this.defaultWidth, null);
        try {
            this.setEbcdic(defaultEbcdic, 0, false, true, false);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIModelException("Internal Error - invalid default field");
        }
    }

    public void setASCIIStr(String ascii, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (this.parentResource instanceof Record) {
            try {
                ((Record)this.parentResource).setAsciiString(ascii, fireEvent);
            }
            catch (FMIParseException pe) {
                throw new FMIModelException(pe.getMessage());
            }
        } else {
            throw new FMIModelException("Internal error - cannot set ascii string value on layout field");
        }
    }

    public void setDefaultWidth(int defaultWidth) throws FMIConversionException {
        this.defaultWidth = defaultWidth;
        try {
            this.maxAsciiWidth = this.converter.getMaxASCIIWidth(defaultWidth, null);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIConversionException("Internal Error: Invalid default field width");
        }
    }

    public int getActualEbcdicWidth() {
        return this.defaultWidth;
    }

    public int getMaxEbcdicWidth() {
        return this.defaultWidth;
    }

    public DefaultField copy() {
        try {
            DefaultField newField = new DefaultField();
            newField.setStartLayoutIndex(0);
            newField.defaultWidth = this.defaultWidth;
            newField.setEndLayoutIndex(0);
            return newField;
        }
        catch (FMIConversionException fe) {
            fe.printStackTrace();
            return null;
        }
    }

    public int setEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        int result = super.setEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
        this.maxAsciiWidth = this.converter.getMaxASCIIWidth(this.ebcdicWidth, this.conversionParams);
        return result;
    }

    public void validateASCIIchange(String ascii) throws FMIConversionException, FMIModelException, FMIKeyException {
        if (!this.converter.validateASCII(ascii, ascii.length(), null)) {
            throw new FMIConversionException("Provided value is invalid for this data type");
        }
    }

    public void validateEBCDICchange(byte[] ebcdic) throws FMIConversionException, FMIModelException, FMIKeyException {
        this.converter.EBCDICtoASCIIstr(ebcdic, ebcdic.length, this.conversionParams);
    }
}

