/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.fmi.client.FMIEditSessionProperties;
import com.ibm.fmi.model.DefaultRecordLayout;
import com.ibm.fmi.model.FMRecordParser;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldIterator;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.FMRecordLayoutBuilder;
import com.ibm.fmi.model.key.KSDSKey;
import com.ibm.fmi.model.shadowline.ShadowLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class TemplattedDataBuilder {
    public static TemplattedData buildModel(String dataFile, ShadowLine[] hiddenSets, FMIEditSessionProperties editSessionProperties, Object zosResource) throws FMIConversionException, FMIParseException, FMIModelException, FMIKeyException {
        TemplattedData fileData = new TemplattedData(dataFile);
        fileData.setEditSessionProperties(editSessionProperties);
        fileData.setZosResource(zosResource);
        String templateFileName = FMIClientUtilities.getLocalTemplateName((String)dataFile);
        fileData = TemplattedDataBuilder.buildLayouts(fileData, templateFileName);
        fileData = FMRecordParser.parseRecords(fileData, TemplattedDataBuilder.getRawContents(dataFile), hiddenSets, fileData.getLayouts());
        return fileData;
    }

    private static TemplattedData buildLayouts(TemplattedData data, String templateFileName) throws FMIModelException, FMIParseException, FMIConversionException, FMIKeyException {
        File templateFile = new File(templateFileName);
        if (!templateFile.exists()) {
            data.addRecordLayout(new DefaultRecordLayout(data));
            data.setStartLayoutSymbol(0);
            return data;
        }
        FMRecordLayoutBuilder layoutBuilder = new FMRecordLayoutBuilder();
        ArrayList<RecordLayout> layouts = layoutBuilder.buildLayouts(TemplattedDataBuilder.getRawContents(templateFile), data);
        if (layouts.size() == 0) {
            System.out.println("No layouts found.  Using default");
            data.addRecordLayout(new DefaultRecordLayout(data));
            data.setStartLayoutSymbol(0);
        } else {
            data.addRecordLayout(layouts);
            data.setStartLayoutSymbol(layouts.get(0).getSymbol());
        }
        if (data.getKey() != null) {
            KSDSKey key = data.getKey();
            int endKeyIndex = key.getOffset() + key.getLength();
            for (RecordLayout layout : layouts) {
                FieldIterator fIter = layout.getFieldIterator();
                int curOffset = 0;
                while (fIter.hasNext() && curOffset <= endKeyIndex) {
                    Field f = fIter.next();
                    if (f.getRecordOffset() < endKeyIndex && f.getRecordOffset() + f.getMaxEbcdicWidth() > key.getOffset()) {
                        f.setIsKeyField(true);
                    }
                    curOffset += f.getMaxEbcdicWidth();
                }
            }
        }
        return data;
    }

    private static byte[] getRawContents(String dataFileName) {
        File dataFile = new File(dataFileName);
        return TemplattedDataBuilder.getRawContents(dataFile);
    }

    private static byte[] getRawContents(File dataFile) {
        dataFile.exists();
        try {
            FileInputStream is = new FileInputStream(dataFile);
            long length = dataFile.length();
            byte[] rawBytes = new byte[(int)length];
            int offset = 0;
            int numRead = 0;
            while (offset < rawBytes.length && (numRead = ((InputStream)is).read(rawBytes, offset, rawBytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < rawBytes.length) {
                throw new IOException("Could not completely read file " + dataFile.getName());
            }
            ((InputStream)is).close();
            return rawBytes;
        }
        catch (Exception ie) {
            ie.printStackTrace();
            return null;
        }
    }

    private static char curHexChar(byte curByte, int nibble) {
        char[] hex = "0123456789ABCDEF".toCharArray();
        int b = 0;
        if (nibble == 0) {
            b = curByte & 0xF;
        } else if (nibble == 1) {
            b = (curByte & 0xF0) >> 4;
        }
        return hex[b];
    }
}

