/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.datatypeconverters;

import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class FMIUnsignedBinaryDataTypeConverter
implements IFMIDataTypeConverter {
    private String MSG_UNEXPECTED_DATA_SIZE = "Could not convert unsigned binary data to String.  Unexpected data size.";
    private static final int MAX_DIGITS_ULONG_CONVERTED = 9;

    /*
     * Unable to fully structure code
     */
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        try {
            bytes = null;
            tgtArr = new byte[tgtWidth];
            if (asciiString == null || asciiString.equals("")) {
                i = 0;
                while (i < tgtArr.length) {
                    tgtArr[i] = 0;
                    ++i;
                }
            } else {
                block14: {
                    if (tgtWidth == 2) {
                        bytes = ByteBuffer.allocate(tgtWidth * 2);
                        bytes.putInt(Integer.parseInt(asciiString));
                        bytes.position(tgtWidth);
                    } else if (tgtWidth == 4) {
                        bytes = ByteBuffer.allocate(tgtWidth * 2);
                        bytes.putLong(Long.parseLong(asciiString));
                        bytes.position(tgtWidth);
                    } else if (tgtWidth == 8) {
                        try {
                            bytes = ByteBuffer.allocate(tgtWidth);
                            tempLong = Long.parseLong(asciiString);
                            bytes.putLong(tempLong);
                            bytes.position(0);
                            break block14;
                        }
                        catch (NumberFormatException v0) {
                            tmpBig = new BigInteger(asciiString);
                            nineBytes = tmpBig.toByteArray();
                            if (nineBytes.length > 9) {
                                throw new FMIConversionException(this.MSG_UNEXPECTED_DATA_SIZE);
                            }
                            i = 1;
                            ** while (i < nineBytes.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            bytes.put(nineBytes[i]);
                            ++i;
                            continue;
                        }
lbl45:
                        // 1 sources

                        bytes.position(0);
                    }
                }
                bytes.get(tgtArr, 0, tgtWidth);
            }
            return tgtArr;
        }
        catch (Exception e) {
            throw new FMIConversionException("Conversion from ASCII to EBCDIC failed: " + e.getClass().getName());
        }
    }

    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int aIndex = asciiString.charAt(0) == '-' ? 1 : 0;
        while (aIndex < asciiString.length() && asciiString.charAt(aIndex) == '0') {
            String string = asciiString = aIndex == 0 ? asciiString.substring(aIndex + 1) : "-" + asciiString.substring(aIndex + 1);
        }
        return asciiString;
    }

    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxWidth, Object[] extraParams) throws FMIConversionException {
        String strVal = null;
        try {
            if (EBCDICval.length == 8) {
                if ((EBCDICval[0] & 0xFFFFFF80) == -128) {
                    BigInteger ulong = new BigInteger(1, EBCDICval);
                    strVal = ulong.toString();
                } else {
                    ByteBuffer bytes = ByteBuffer.allocate(8);
                    bytes.put(EBCDICval);
                    strVal = Long.toString(bytes.getLong(0));
                }
            } else if (EBCDICval.length == 4) {
                ByteBuffer bytes = ByteBuffer.allocate(8);
                byte[] topBytes = new byte[4];
                bytes.put(topBytes);
                bytes.put(EBCDICval);
                strVal = Long.toString(bytes.getLong(0));
            } else if (EBCDICval.length == 2) {
                ByteBuffer bytes = ByteBuffer.allocate(4);
                byte[] topBytes = new byte[2];
                bytes.put(topBytes);
                bytes.put(EBCDICval);
                strVal = Integer.toString(bytes.getInt(0));
            }
        }
        catch (Exception e) {
            throw new FMIConversionException("Conversion from EBCDIC to ASCII failed: " + e.getClass().getName());
        }
        if (strVal == null) {
            throw new FMIConversionException(this.MSG_UNEXPECTED_DATA_SIZE);
        }
        if (strVal.length() > maxWidth) {
            throw new FMIConversionException("Field data exceeds maximum display width" + strVal);
        }
        return strVal;
    }

    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (ascii == null || ascii.equals("")) {
            return true;
        }
        char[] charArr = ascii.toCharArray();
        int i = 0;
        while (i < charArr.length) {
            if (!Character.isDigit(charArr[i])) {
                throw new FMIConversionException("Invalid character");
            }
            ++i;
        }
        if (tgtWidth == 2 && ascii.length() > 5 || tgtWidth == 4 && ascii.length() > 10 || tgtWidth == 8 && ascii.length() > 20) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        return true;
    }

    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth == 2) {
            return 5;
        }
        if (ebcdicWidth == 4) {
            return 10;
        }
        if (ebcdicWidth == 8) {
            return 20;
        }
        throw new FMIConversionException("Error determining maximum ASCII field length");
    }

    public boolean isNumeric() {
        return true;
    }

    public String getSymbol() {
        return "BI";
    }

    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    public boolean requiresFullWordBoundary(int length) {
        return length >= 4;
    }

    public boolean requiresHalfWordBoundary(int length) {
        return length == 2;
    }
}

