/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

class SavedElementsSegment
extends Segment {
    private byte fieldType;
    private byte signField;
    private byte scaleFactor;
    private byte precision;
    private String fill;
    private static final int FILL_LENGTH = 8;

    public SavedElementsSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.fieldType = buf.get();
        this.signField = buf.get();
        this.scaleFactor = buf.get();
        this.precision = buf.get();
        try {
            this.fill = ByteUtilities.getString(buf, 8);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
    }

    public byte getFieldType() {
        return this.fieldType;
    }

    public String getFill() {
        return this.fill;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public byte getScaleFactor() {
        return this.scaleFactor;
    }

    public byte getSignField() {
        return this.signField;
    }
}

