/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.ui.propertypages;

import com.ibm.cdz.remote.ui.Messages;
import com.ibm.cdz.remote.ui.composites.HierarchyChoiceComposite;
import com.ibm.cdz.remote.ui.composites.RemoteMacrosForm;
import com.ibm.ftt.cdz.ui.propertypages.AbstractCPropertyPage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RemoteMacrosPropertyPage
extends AbstractCPropertyPage {
    private RemoteMacrosForm _symbolsForm;
    private HierarchyChoiceComposite _choiceComp;
    private boolean _useSSProperties;

    protected String getInitialSystemSymbols() {
        String syssymbolsStr = this.getSubSystem().getVendorAttribute("com.ibm.cdz", "symbols");
        if (syssymbolsStr == null || syssymbolsStr.length() == 0) {
            syssymbolsStr = "errno=(*__errno()),__TARGET_LIB__=0x20000000";
        }
        if (this.isPropertiesForFile() && !this._useSSProperties) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            String localsyssymbolsStr = this.getSubSystem().getVendorAttribute("com.ibm.cdz" + absolutePath, "symbols");
            if (localsyssymbolsStr != null) {
                syssymbolsStr = localsyssymbolsStr;
            }
        }
        return syssymbolsStr;
    }

    protected void setSystemSymbols(String newSymbols) {
        if (this.isPropertiesForFile()) {
            if (!newSymbols.equals(this.getInitialSystemSymbols())) {
                IAdaptable element = this.getElement();
                String absolutePath = this.getAbsolutePath(element);
                this.getSubSystem().setVendorAttribute("com.ibm.cdz" + absolutePath, "symbols", newSymbols);
            }
        } else {
            this.getSubSystem().setVendorAttribute("com.ibm.cdz", "symbols", newSymbols);
        }
    }

    protected Control createContentArea(Composite parent) {
        if (this.isPropertiesForFile()) {
            this._choiceComp = new HierarchyChoiceComposite();
            this._choiceComp.createContents(parent);
            this._choiceComp.addSelectionChangedListener((Listener)this);
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            String useSubSystemProperties = this.getSubSystem().getVendorAttribute("com.ibm.cdz" + absolutePath, "Symbol.UseSubSystem.Properties");
            this._useSSProperties = useSubSystemProperties == null || useSubSystemProperties.equals("true");
            this._choiceComp.setUseSubSystemSettings(this._useSSProperties);
        }
        SystemWidgetHelpers.createLabel((Composite)parent, (String)Messages.RemoteMacrosForm_Verbage);
        String sysPrompt = Messages.RemoteMacrosForm_Macros;
        this._symbolsForm = new RemoteMacrosForm(this.getMessageLine(), this.getSubSystem(), sysPrompt);
        Control sysControl = this._symbolsForm.createContents(parent);
        this.initForms();
        return sysControl;
    }

    protected void initForms() {
        String syssymbolsStr = this.getInitialSystemSymbols();
        this._symbolsForm.setSymbols(syssymbolsStr);
        this._symbolsForm.updateSymbols();
        this._symbolsForm.setEnabled(!this._useSSProperties);
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public boolean performOk() {
        if (this.isPropertiesForFile()) {
            IAdaptable element = this.getElement();
            String absolutePath = this.getAbsolutePath(element);
            this.getSubSystem().setVendorAttribute("com.ibm.cdz" + absolutePath, "Symbol.UseSubSystem.Properties", this._useSSProperties ? "true" : "false");
        }
        if (!this.isPropertiesForFile() || !this._useSSProperties) {
            String syssymbols = this._symbolsForm.getSymbols();
            this.setSystemSymbols(syssymbols);
        }
        return true;
    }

    public void handleEvent(Event event) {
        this._useSSProperties = event.data == Boolean.TRUE;
        this.initForms();
    }
}

