/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks.v600;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbFlags;
import com.ibm.dmh.db.DbPreparedStatement;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import org.w3c.dom.NamedNodeMap;

public class DmhDistCleanup
implements ITask {
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        return taskBody;
    }

    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        try {
            Integer containerId;
            int i$;
            Main.logln("Running task [DmhDistCleanup]...");
            Main.logln("Eliminate distributed resource managers.");
            DbAdmin.update((int)DbFlags.AC, (CharSequence)"delete from $(SCHEMA).DMH_RESOURCE_MNGR where CREATE_TOOL_ID=2000000", (Object[])new Object[0]);
            DbPreparedStatement ps = DbAdmin.getPreparedStatement((CharSequence)"delete from $(SCHEMA).DMH_CONTAINER where CONTAINER_ID=?").setMaxBatchSizes(1, 1);
            Main.logln("Eliminate files and containers of non-existent resource managers.");
            int[] arr$ = DbAdmin.query((CharSequence)"select C.CONTAINER_ID as containerId from $(SCHEMA).DMH_CONTAINER C where not exists (select 1 from $(SCHEMA).DMH_RESOURCE_MNGR RM where C.RESOURCE_MNGR_ID=RM.RESOURCE_MNGR_ID) order by containerId desc", (Object[])new Object[0]).toInts();
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                containerId = arr$[i$];
                Main.logln("Deleting container [" + containerId + "]");
                ps.addBatch(new Object[]{containerId});
            }
            Main.logln("Eliminate 'DIR' and 'ARC' containers.");
            arr$ = DbAdmin.query((CharSequence)"select CONTAINER_ID from $(SCHEMA).DMH_CONTAINER where CONTAINER_TYPE_CD='DIR' or CONTAINER_TYPE_CD='ARC' order by CONTAINER_ID desc", (Object[])new Object[0]).toInts();
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                containerId = arr$[i$];
                Main.logln("Deleting container [" + containerId + "]");
                ps.addBatch(new Object[]{containerId});
            }
            ps.executeBatch(true);
            DbAdmin.close((Object[])new Object[]{ps});
            Main.logln("Eliminate old distributed analysis queue entries.");
            DbAdmin.update((int)DbFlags.AC, (CharSequence)"delete from $(SCHEMA).DMH_ANALYSIS_QUEUE where ANALYSIS_TYPE_CD=21", (Object[])new Object[0]);
            DbAdmin.commit();
            Main.logln("done\n");
            return 0;
        }
        catch (Exception e) {
            Main.logException(e);
            return 2;
        }
    }
}

