/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.cfgmgr;

import com.ibm.dmh.cfgmgr.PasswordCipherUtil;
import com.ibm.dmh.cfgmgr.SecurityException;
import java.io.UnsupportedEncodingException;

public class PasswordUtil {
    public static final String STRING_CONVERSION_CODE = "UTF8";
    public static final String DEFAULT_CRYPTO_ALGORITHM;
    private static final String CRYPTO_ALGORITHM_STARTED = "{";
    private static final String CRYPTO_ALGORITHM_STOPPED = "}";
    private static final String EMPTY_STRING;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final String[] SUPPORTED_CRYPTO_ALGORITHMS;
    private static final byte[] BASE64_ENCODE_MAP;
    private static final byte[] BASE64_DECODE_MAP;

    public static String decode(String string) throws SecurityException {
        if (string == null) {
            throw new SecurityException(2);
        }
        String string2 = PasswordUtil.getCryptoAlgorithm(string);
        if (string2 == null) {
            throw new SecurityException(2);
        }
        if (!PasswordUtil.isValidCryptoAlgorithm(string2)) {
            throw new SecurityException(4);
        }
        String string3 = PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(string), string2);
        if (string3 == null) {
            throw new SecurityException(2);
        }
        return string3;
    }

    public static String encode(String string) throws SecurityException {
        return PasswordUtil.encode(string, DEFAULT_CRYPTO_ALGORITHM);
    }

    public static String encode(String string, String string2) throws SecurityException {
        if (!PasswordUtil.isValidCryptoAlgorithm(string2)) {
            throw new SecurityException(4);
        }
        if (string == null) {
            throw new SecurityException(3);
        }
        if (PasswordUtil.getCryptoAlgorithm(string) != null) {
            throw new SecurityException(3);
        }
        String string3 = PasswordUtil.encode_password(string.trim(), string2.trim());
        if (string3 == null) {
            throw new SecurityException(3);
        }
        return string3;
    }

    public static String getCryptoAlgorithm(String string) {
        int n;
        int n2;
        String string2 = null;
        if (string != null && (string = string.trim()).length() >= 2 && (n2 = string.indexOf(CRYPTO_ALGORITHM_STARTED)) == 0 && (n = string.indexOf(CRYPTO_ALGORITHM_STOPPED, ++n2)) > 0) {
            string2 = n2 < n ? string.substring(n2, n).trim() : EMPTY_STRING;
        }
        return string2;
    }

    public static String getCryptoAlgorithmTag(String string) {
        String string2 = null;
        String string3 = PasswordUtil.getCryptoAlgorithm(string);
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(CRYPTO_ALGORITHM_STARTED);
            if (string3.length() > 0) {
                stringBuffer.append(string3);
            }
            stringBuffer.append(CRYPTO_ALGORITHM_STOPPED);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static boolean isValidCryptoAlgorithm(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return true;
            }
            for (int i = 0; i < SUPPORTED_CRYPTO_ALGORITHMS.length; ++i) {
                if (!string.equalsIgnoreCase(SUPPORTED_CRYPTO_ALGORITHMS[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidCryptoAlgorithmTag(String string) {
        return PasswordUtil.isValidCryptoAlgorithm(PasswordUtil.getCryptoAlgorithm(string));
    }

    public static String passwordDecode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = PasswordUtil.getCryptoAlgorithm(string);
        if (string2 == null) {
            return string;
        }
        if (!PasswordUtil.isValidCryptoAlgorithm(string2)) {
            return null;
        }
        return PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(string), string2);
    }

    public static String passwordEncode(String string) {
        return PasswordUtil.passwordEncode(string, DEFAULT_CRYPTO_ALGORITHM);
    }

    public static String passwordEncode(String string, String string2) {
        if (!PasswordUtil.isValidCryptoAlgorithm(string2)) {
            return null;
        }
        if (string == null) {
            return null;
        }
        String string3 = PasswordUtil.getCryptoAlgorithm(string);
        if (string3 != null) {
            if (string3.equalsIgnoreCase(string2.trim())) {
                return string.trim();
            }
            return null;
        }
        return PasswordUtil.encode_password(string.trim(), string2.trim());
    }

    public static String removeCryptoAlgorithmTag(String string) {
        int n;
        int n2;
        String string2 = null;
        if (string != null && (string = string.trim()).length() >= 2 && (n2 = string.indexOf(CRYPTO_ALGORITHM_STARTED)) == 0 && (n = string.indexOf(CRYPTO_ALGORITHM_STOPPED, ++n2)) > 0) {
            string2 = ++n < string.length() ? string.substring(n).trim() : EMPTY_STRING;
        }
        return string2;
    }

    private static byte[] convert_to_bytes(String string) {
        byte[] byArray = null;
        if (string != null) {
            if (string.length() == 0) {
                byArray = EMPTY_BYTE_ARRAY;
            } else {
                try {
                    byArray = string.getBytes(STRING_CONVERSION_CODE);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace(System.err);
                }
            }
        }
        return byArray;
    }

    private static String convert_to_string(byte[] byArray) {
        String string = null;
        if (byArray != null) {
            if (byArray.length == 0) {
                string = EMPTY_STRING;
            } else {
                try {
                    string = new String(byArray, STRING_CONVERSION_CODE);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace(System.err);
                }
            }
        }
        return string;
    }

    private static byte[] convert_viewable_to_bytes(String string) {
        byte[] byArray = null;
        if (string != null) {
            if (string.length() == 0) {
                byArray = EMPTY_BYTE_ARRAY;
            } else {
                try {
                    byArray = PasswordUtil.base64Decode(PasswordUtil.convert_to_bytes(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        return byArray;
    }

    private static byte[] base64Decode(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        while (byArray[--n2] == 61) {
        }
        byte[] byArray2 = new byte[n2 + 1 - byArray.length / 4];
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = BASE64_DECODE_MAP[byArray[n]];
        }
        n = byArray2.length - 2;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            byArray2[n3] = (byte)(byArray[n4] << 2 & 0xFF | byArray[n4 + 1] >>> 4 & 3);
            byArray2[n3 + 1] = (byte)(byArray[n4 + 1] << 4 & 0xFF | byArray[n4 + 2] >>> 2 & 0xF);
            byArray2[n3 + 2] = (byte)(byArray[n4 + 2] << 6 & 0xFF | byArray[n4 + 3] & 0x3F);
            n3 += 3;
            n4 += 4;
        }
        if (n3 < byArray2.length) {
            byArray2[n3++] = (byte)(byArray[n4] << 2 & 0xFF | byArray[n4 + 1] >>> 4 & 3);
            if (n3 < byArray2.length) {
                byArray2[n3] = (byte)(byArray[n4 + 1] << 4 & 0xFF | byArray[n4 + 2] >>> 2 & 0xF);
            }
        }
        return byArray2;
    }

    private static String convert_viewable_to_string(byte[] byArray) {
        String string = null;
        if (byArray != null) {
            if (byArray.length == 0) {
                string = EMPTY_STRING;
            } else {
                try {
                    string = PasswordUtil.convert_to_string(PasswordUtil.base64Encode(byArray));
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        return string;
    }

    private static byte[] base64Encode(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n2 = 0;
        for (n = 0; n < byArray.length - 2; n += 3) {
            byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n] >>> 2 & 0x3F];
            byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
            byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n + 2] >>> 6 & 3 | byArray[n + 1] << 2 & 0x3F];
            byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n + 2] & 0x3F];
        }
        if (n < byArray.length) {
            byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n] >>> 2 & 0x3F];
            if (n < byArray.length - 1) {
                byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
                byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n + 1] << 2 & 0x3F];
            } else {
                byArray2[n2++] = BASE64_ENCODE_MAP[byArray[n] << 4 & 0x3F];
            }
        }
        while (n2 < byArray2.length) {
            byArray2[n2] = 61;
            ++n2;
        }
        return byArray2;
    }

    private static String decode_password(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() == 0) {
            stringBuffer.append(string);
        } else {
            String string3 = null;
            if (string.length() > 0) {
                byte[] byArray = PasswordUtil.convert_viewable_to_bytes(string);
                if (byArray == null) {
                    return null;
                }
                if (byArray.length > 0) {
                    byte[] byArray2 = null;
                    try {
                        byArray2 = PasswordCipherUtil.decipher(byArray, string2);
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace(System.err);
                        return null;
                    }
                    if (byArray2 != null && byArray2.length > 0) {
                        string3 = PasswordUtil.convert_to_string(byArray2);
                    }
                }
            }
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    private static String encode_password(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(CRYPTO_ALGORITHM_STARTED);
        if (string2.length() == 0) {
            stringBuffer.append(CRYPTO_ALGORITHM_STOPPED).append(string);
        } else {
            byte[] byArray;
            stringBuffer.append(string2).append(CRYPTO_ALGORITHM_STOPPED);
            String string3 = null;
            if (string.length() > 0 && (byArray = PasswordUtil.convert_to_bytes(string)).length > 0) {
                byte[] byArray2 = null;
                try {
                    byArray2 = PasswordCipherUtil.encipher(byArray, string2);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace(System.err);
                    return null;
                }
                if (byArray2 != null && byArray2.length > 0 && (string3 = PasswordUtil.convert_viewable_to_string(byArray2)) == null) {
                    return null;
                }
            }
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        EMPTY_STRING = new String("");
        EMPTY_BYTE_ARRAY = new byte[0];
        SUPPORTED_CRYPTO_ALGORITHMS = PasswordCipherUtil.getSupportedCryptoAlgorithms();
        DEFAULT_CRYPTO_ALGORITHM = SUPPORTED_CRYPTO_ALGORITHMS[0];
        byte[] byArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        BASE64_ENCODE_MAP = byArray;
        BASE64_DECODE_MAP = new byte[128];
        for (n = 0; n < BASE64_DECODE_MAP.length; ++n) {
            PasswordUtil.BASE64_DECODE_MAP[n] = -1;
        }
        for (n = 0; n < BASE64_ENCODE_MAP.length; ++n) {
            PasswordUtil.BASE64_DECODE_MAP[PasswordUtil.BASE64_ENCODE_MAP[n]] = (byte)n;
        }
    }
}

