/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.cfgmgr.vars;

import com.ibm.dmh.cfgmgr.vars.AbstractVar;
import com.ibm.dmh.cfgmgr.vars.VarException;
import com.ibm.dmh.cfgmgr.vars.VarTracker;
import com.ibm.dmh.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalMapVar
extends AbstractVar {
    protected ThreadLocal<Map<String, Object>> map = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected synchronized Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    protected Object defaultVal;
    protected boolean preserveUnknownVars;

    public ThreadLocalMapVar(boolean bl) {
        this.defaultVal = null;
        this.preserveUnknownVars = bl;
    }

    public ThreadLocalMapVar(Object object) {
        this.defaultVal = object;
        this.preserveUnknownVars = false;
    }

    public void put(String string, Object object) {
        this.map.get().put(string, object);
    }

    @Override
    public String resolve(String string, String[] stringArray, VarTracker varTracker) throws VarException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new VarException(string, stringArray, "Invalid number of arguments.  Must be 1-2.");
        }
        String string2 = stringArray[0];
        Object object = this.map.get().get(string2);
        if (object == null) {
            if (varTracker != null) {
                varTracker.notifyVarNotFound(string2);
            }
            if (stringArray.length > 1) {
                return stringArray[1];
            }
            if (this.preserveUnknownVars) {
                return "$" + string + "{" + StringUtils.join(stringArray, ",") + "}";
            }
            if (this.defaultVal != null) {
                return this.defaultVal.toString();
            }
            return "null";
        }
        if (varTracker != null) {
            varTracker.notifyVarUsed(string2);
        }
        if (object instanceof Object[]) {
            return StringUtils.join((Object[])object, ',', true);
        }
        return object.toString();
    }

    @Override
    public Set<String> getKeys() throws Exception {
        return this.map.get().keySet();
    }
}

