/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.cfgmgr.vars;

import com.ibm.dmh.cfgmgr.vars.AbstractVar;
import com.ibm.dmh.cfgmgr.vars.VarTracker;
import com.ibm.dmh.util.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarResolver {
    protected Map<String, AbstractVar> varMap = new HashMap<String, AbstractVar>();
    protected Map<String, VarTracker> varTrackerMap = new HashMap<String, VarTracker>();

    public void addVar(String string, AbstractVar abstractVar, VarTracker varTracker) {
        this.varMap.put(string, abstractVar);
        if (varTracker != null) {
            this.varTrackerMap.put(string, varTracker);
        }
    }

    public boolean resolveBoolean(String string) throws Exception {
        if (string == null || string.equals("")) {
            return true;
        }
        return this.resolveString("$MB{" + string + "}").equals("true");
    }

    public String resolveString(String string) throws Exception {
        if (string == null || string.indexOf(36) == -1) {
            return string;
        }
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block5: for (int i = 0; i < cArray.length; ++i) {
            switch (n) {
                case 1: {
                    if (cArray[i] != '$') continue block5;
                    stringBuffer.append(cArray, n2, i - n2);
                    n2 = i;
                    n3 = i;
                    n = 2;
                    continue block5;
                }
                case 2: {
                    if (cArray[i] == '{') {
                        string2 = new String(cArray, n2 + 1, i - n2 - 1);
                        n2 = i;
                        n = 3;
                        continue block5;
                    }
                    if (cArray[i] >= '&' && cArray[i] <= 'z') continue block5;
                    stringBuffer.append(cArray, n2, i - n2 + 1);
                    n2 = i + 1;
                    n = 1;
                    continue block5;
                }
                case 3: {
                    if (cArray[i] == '{') {
                        ++n4;
                        bl = true;
                        continue block5;
                    }
                    if (cArray[i] != '}') continue block5;
                    if (n4 > 0) {
                        --n4;
                        continue block5;
                    }
                    string3 = new String(cArray, n2 + 1, i - n2 - 1);
                    string3 = bl ? this.resolveString(string3) : string3;
                    AbstractVar abstractVar = this.varMap.get(string2);
                    VarTracker varTracker = this.varTrackerMap.get(string2);
                    stringBuffer.append(abstractVar == null ? new String(cArray, n3, i - n3 + 1) : abstractVar.resolve(string2, StringUtils.splitQuoted(string3, ',', true, true), varTracker));
                    n2 = i + 1;
                    n = 1;
                }
            }
        }
        stringBuffer.append(cArray, n2, cArray.length - n2);
        return stringBuffer.toString();
    }

    public List<String> getTrackerWarnings() {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            for (Map.Entry<String, VarTracker> entry : this.varTrackerMap.entrySet()) {
                String string = entry.getKey();
                VarTracker varTracker = entry.getValue();
                AbstractVar abstractVar = this.varMap.get(string);
                Set<String> set = varTracker.getNotFound();
                Set<String> set2 = varTracker.getNotUsed(abstractVar.getKeys());
                if (!set.isEmpty()) {
                    linkedList.add("Keys not found for var [" + string + "]:  \n\t" + StringUtils.join(set, "\n\t"));
                }
                if (set2.isEmpty()) continue;
                linkedList.add("Keys not used  for var [" + string + "]:  \n\t" + StringUtils.join(set2, "\n\t"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return linkedList;
    }
}

