/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.msg;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TagElementGeneric {
    private final String xmlVersion;
    private static Map<String, TagElementGeneric> map = new HashMap<String, TagElementGeneric>(101);

    TagElementGeneric(String string) {
        this.xmlVersion = string;
    }

    private static String getInnerXML(String string) {
        int n = string.indexOf(60) + 1;
        int n2 = string.lastIndexOf(62);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    public static synchronized TagElementGeneric getTag(String string) {
        String string2 = TagElementGeneric.getInnerXML(string);
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        TagElementGeneric tagElementGeneric = new TagElementGeneric(string2);
        map.put(string2, tagElementGeneric);
        return tagElementGeneric;
    }

    public String getXml() {
        if (this.xmlVersion.charAt(0) == '&') {
            return this.xmlVersion;
        }
        return "<" + this.xmlVersion + ">";
    }

    public String getText() {
        String string = this.getName(this.xmlVersion);
        String string2 = "";
        if (!(string.equals("cit") || string.equals("defn") || string.equals("/defn"))) {
            if (string.equals("dl")) {
                string2 = "[";
            } else if (string.equals("/dl")) {
                string2 = "]";
            } else if (string.equals("dlentry")) {
                string2 = "(";
            } else if (string.equals("/dlentry")) {
                string2 = ")";
            } else if (string.equals("li")) {
                string2 = "(";
            } else if (string.equals("/li")) {
                string2 = ")";
            } else if (!(string.equals("mv") || string.equals("/mv") || string.equals("p"))) {
                if (string.equals("/p")) {
                    string2 = "  ";
                } else if (!(string.equals("ph") || string.equals("/ph") || string.equals("term"))) {
                    if (string.equals("/term")) {
                        string2 = " - ";
                    } else if (string.equals("ul")) {
                        string2 = "[";
                    } else if (string.equals("/ul")) {
                        string2 = "]";
                    } else if (!string.equals("xmp") && !string.equals("/xmp")) {
                        if (string.equals("&gt;")) {
                            string2 = ">";
                        } else if (string.equals("&lt;")) {
                            string2 = "<";
                        }
                    }
                }
            }
        }
        return string2;
    }

    private String getName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return stringTokenizer.nextToken();
    }

    private String getAttributes(String string, String string2) {
        return string.substring(string2.length()).trim();
    }

    public String getHtml() {
        String string = this.getName(this.xmlVersion);
        String string2 = "";
        if (!string.equals("cit")) {
            if (string.equals("defn")) {
                string2 = "dd";
            } else if (string.equals("/defn")) {
                string2 = "/dd";
            } else if (string.equals("dl")) {
                string2 = "dl";
            } else if (string.equals("/dl")) {
                string2 = "/dl";
            } else if (string.equals("dlentry")) {
                string2 = "";
            } else if (string.equals("/dlentry")) {
                string2 = "";
            } else if (string.equals("li")) {
                string2 = "li";
            } else if (string.equals("/li")) {
                string2 = "/li";
            } else if (string.equals("mv")) {
                string2 = "span class='msgVar'";
            } else if (string.equals("/mv")) {
                string2 = "/span";
            } else if (string.equals("p")) {
                string2 = "p";
            } else if (string.equals("/p")) {
                string2 = "/p";
            } else if (string.equals("ph")) {
                string2 = "span " + this.convertPhTag(this.xmlVersion, string);
            } else if (string.equals("/ph")) {
                string2 = "/span";
            } else if (string.equals("term")) {
                string2 = "dt";
            } else if (string.equals("/term")) {
                string2 = "/dt";
            } else if (string.equals("ul")) {
                string2 = "ul";
            } else if (string.equals("/ul")) {
                string2 = "/ul";
            } else if (string.equals("xmp")) {
                string2 = "code";
            } else if (string.equals("/xmp")) {
                string2 = "/code";
            } else if (string.equals("&gt;")) {
                string2 = "&gt;";
            } else if (string.equals("&lt;")) {
                string2 = "&lt;";
            }
        }
        if ((string2 = string2.trim()).equals("")) {
            return string2;
        }
        if (string2.charAt(0) == '&') {
            return string2;
        }
        return "<" + string2 + ">";
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return this.xmlVersion.hashCode();
    }

    public String toString() {
        return this.xmlVersion;
    }

    private String convertPhTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(this.getAttributes(string, string2));
        int n = stringBuffer.toString().indexOf("italic");
        if (n != -1) {
            stringBuffer = stringBuffer.replace(n, "italic".length() + n, "font-style: italic;");
        }
        if ((n = stringBuffer.toString().indexOf("bold")) != -1) {
            stringBuffer = stringBuffer.replace(n, "bold".length() + n, "font-weight: bold;");
        }
        return stringBuffer.toString();
    }
}

