/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.qp.AbstractWork;
import com.ibm.dmh.qp.IWorkManager;
import com.ibm.dmh.qp.WorkCancelledException;
import com.ibm.dmh.qp.WorkException;
import com.ibm.dmh.qp.WorkProcessor;
import com.ibm.dmh.qp.WorkStatus;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class BackupWorkManager
implements IWorkManager {
    LinkedBlockingQueue<Runnable> queue;
    ThreadPoolExecutor tpExecutor;

    public BackupWorkManager(int n, int n2, int n3) {
        WorkProcessor.logger.info("Initializing BackupWorkManager with the following settings:  threadPoolSize=[" + n + "], queueSize=[" + n2 + "], priority=[" + n3 + "]");
        this.queue = new LinkedBlockingQueue(n2);
        this.tpExecutor = new WsaaThreadPoolExecutor(n, this.queue, n3);
    }

    public boolean awaitTermination() {
        try {
            return this.tpExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void startWork(AbstractWork abstractWork) throws WorkException {
        try {
            this.tpExecutor.execute(abstractWork);
            abstractWork.changeStatus(WorkStatus.ACCEPTED);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            abstractWork.changeStatus(WorkStatus.REJECTED);
            abstractWork.addException(rejectedExecutionException);
        }
    }

    public void shutdown() {
        LoggerManager.getMainLogger().log(Level.INFO, "BackupWorkManager[" + this + "].shutdown() called.");
        this.tpExecutor.shutdown();
    }

    public void remove(AbstractWork abstractWork) {
        if (abstractWork.status != WorkStatus.STARTED) {
            this.tpExecutor.remove(abstractWork);
            abstractWork.changeStatus(WorkStatus.REJECTED);
        }
    }

    private class WsaaThreadFactory
    implements ThreadFactory {
        private int threadPriority;

        public WsaaThreadFactory(int n) {
            this.threadPriority = n;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(this.threadPriority);
            return thread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WsaaThreadPoolExecutor
    extends ThreadPoolExecutor {
        public WsaaThreadPoolExecutor(int n, BlockingQueue<Runnable> blockingQueue, int n2) {
            super(n, n, 60L, TimeUnit.SECONDS, blockingQueue, new WsaaThreadFactory(n2));
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            super.beforeExecute(thread, runnable);
            AbstractWork abstractWork = (AbstractWork)runnable;
            if (abstractWork.status != WorkStatus.REJECTED) {
                abstractWork.changeStatus(WorkStatus.STARTED);
            }
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            AbstractWork abstractWork = (AbstractWork)runnable;
            if (throwable != null && !(throwable instanceof WorkCancelledException)) {
                abstractWork.addException(throwable);
            }
            if (throwable instanceof WorkCancelledException) {
                abstractWork.changeStatus(WorkStatus.ABORTED);
            } else if (!abstractWork.status.isInState(WorkStatus.ABORTED, WorkStatus.FAILED)) {
                abstractWork.changeStatus(abstractWork.getExceptions().length == 0 ? WorkStatus.COMPLETED : WorkStatus.FAILED);
            }
        }
    }
}

