/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.qp.AbstractWork;
import com.ibm.dmh.qp.WorkListener;
import com.ibm.dmh.qp.WorkStatus;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BlockableWorkListener
extends WorkListener {
    private Semaphore semaphore = new Semaphore(1);
    private WorkStatus[] releaseStates;

    public BlockableWorkListener(WorkStatus ... workStatusArray) {
        this.releaseStates = workStatusArray;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void workStatusChanged(WorkStatus workStatus, AbstractWork abstractWork) {
        if (workStatus.isInState(this.releaseStates)) {
            this.semaphore.release();
        }
    }

    public void waitFor(long l) throws Exception {
        if (!this.semaphore.tryAcquire(l, TimeUnit.MILLISECONDS)) {
            throw new Exception("Work timed out!");
        }
    }
}

