/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.log.LoggerManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuildInfo {
    private String buildLabel = "";
    private String buildDate = "";
    private String buildVersion = "";
    private static String propFile = "/dmhBuild_info.properties";
    private static String propResource = "dmhBuild_info";
    private static String labelProperty = "buildLabel";
    private static String versionProperty = "version";
    protected static Logger logger = LoggerManager.getMainLogger();
    protected static boolean debug = logger.isLoggable(Level.FINE);

    public BuildInfo() {
        this.loadBuildProperties();
    }

    private void loadBuildProperties() {
        if (debug) {
            logger.log(Level.FINER, "Loading build properties...");
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(propFile);
            if (inputStream == null) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.setBuildDate(bufferedReader.readLine());
            bufferedReader.close();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(propResource);
            this.setBuildLabel((String)resourceBundle.getObject(labelProperty));
            this.setBuildVersion((String)resourceBundle.getObject(versionProperty));
        }
        catch (MissingResourceException missingResourceException) {
            logger.log(Level.SEVERE, "Missing resource: dmhBuild_info.properties", missingResourceException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, "No such file: dmhBuild_info.properties", fileNotFoundException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    private void setBuildDate(String string) {
        this.buildDate = string;
    }

    private void setBuildLabel(String string) {
        this.buildLabel = string;
    }

    private void setBuildVersion(String string) {
        this.buildVersion = string;
    }

    public String getBuildLabel() {
        return this.buildLabel;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getBuildDate() {
        return this.buildDate;
    }
}

