/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.IMatcher;
import com.ibm.dmh.util.StringUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateMatcher
implements IMatcher<Date> {
    private TimestampPattern[] patterns;
    private static SimpleDateFormat[] validTimestampFormats;

    public static void setValidTimestampFormats(String string) {
        String[] stringArray = StringUtils.split(string, ',');
        validTimestampFormats = new SimpleDateFormat[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DateMatcher.validTimestampFormats[i] = new SimpleDateFormat(stringArray[i]);
        }
    }

    public DateMatcher(String string) {
        this.patterns = new TimestampPattern[1];
        this.patterns[0] = new TimestampPattern(string);
    }

    public DateMatcher(String[] stringArray) {
        this.patterns = new TimestampPattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.patterns[i] = new TimestampPattern(stringArray[i]);
        }
    }

    @Override
    public boolean matches(Date date) {
        if (date == null) {
            return false;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (this.patterns[i].matches(date)) continue;
            return false;
        }
        return true;
    }

    protected static Date parseDate(String string, ParsePosition parsePosition) {
        boolean bl = false;
        Date date = null;
        for (int i = 0; i < validTimestampFormats.length && !bl; ++i) {
            char c;
            parsePosition.setIndex(0);
            date = validTimestampFormats[i].parse(string, parsePosition);
            int n = parsePosition.getIndex();
            if (n == 0) continue;
            char c2 = c = string.length() == n ? (char)'\u0000' : string.charAt(n);
            if (c != '\u0000' && c != '-' && !Character.isWhitespace(c)) continue;
            bl = true;
        }
        if (!bl) {
            throw new RuntimeException("Invalid date encountered:  [" + string + "]");
        }
        return date;
    }

    static {
        DateMatcher.setValidTimestampFormats("yyyy.MM.dd.HH.mm.ss,yyyy.MM.dd.HH.mm,yyyy.MM.dd.HH,yyyy.MM.dd,yyyy.MM,yyyy");
    }

    protected class TimestampRange {
        Date start;
        Date end;

        public TimestampRange(Date date) {
            this.start = new Date(date.getTime() - 1L);
            this.end = this.rollUp(date);
        }

        public TimestampRange(String string, Date date) {
            if (string.equals(">") || string.equals("<=")) {
                date = this.rollUp(date);
            }
            if (string.equals(">") || string.equals(">=")) {
                this.start = new Date(date.getTime() - 1L);
                this.end = new Date(Long.MAX_VALUE);
            } else {
                this.start = new Date(0L);
                this.end = date;
            }
        }

        public TimestampRange(Date date, Date date2) {
            this.start = new Date(date.getTime() - 1L);
            this.end = this.rollUp(date2);
        }

        public boolean matches(Date date) {
            boolean bl = date.after(this.start) && date.before(this.end);
            return bl;
        }

        private Date rollUp(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = 32;
            if (calendar.isSet(1)) {
                n = 121;
            }
            if (calendar.isSet(2)) {
                n = 77;
            }
            if (calendar.isSet(5)) {
                n = 100;
            }
            if (calendar.isSet(10) || calendar.isSet(11)) {
                n = 72;
            }
            if (calendar.isSet(12)) {
                n = 109;
            }
            if (calendar.isSet(13)) {
                n = 115;
            }
            int n2 = 0;
            switch (n) {
                case 121: {
                    n2 = 1;
                    break;
                }
                case 77: {
                    n2 = 2;
                    break;
                }
                case 100: {
                    n2 = 5;
                    break;
                }
                case 72: {
                    n2 = 11;
                    break;
                }
                case 109: {
                    n2 = 12;
                    break;
                }
                case 115: {
                    n2 = 13;
                }
            }
            calendar.roll(n2, true);
            return calendar.getTime();
        }
    }

    private class TimestampPattern {
        TimestampRange[] ranges;
        List<TimestampRange> l = new LinkedList<TimestampRange>();

        public TimestampPattern(String string) {
            if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
                string = string.substring(1, string.length() - 1);
            }
            Pattern pattern = Pattern.compile("^\\s*([<>](?:=)?)\\s*(\\S+.*)$");
            Pattern pattern2 = Pattern.compile("^(\\s*-\\s*)(\\S+.*)$");
            int n = 1;
            String string2 = null;
            Date date = null;
            ParsePosition parsePosition = new ParsePosition(0);
            Matcher matcher = null;
            String string3 = string;
            while (!string3.equals("") || n != 1) {
                if (n == 1) {
                    matcher = pattern.matcher(string3);
                    if (matcher.matches()) {
                        string2 = matcher.group(1);
                        string3 = matcher.group(2);
                        n = 2;
                        continue;
                    }
                    n = 3;
                    continue;
                }
                if (n == 2) {
                    this.l.add(new TimestampRange(string2, DateMatcher.parseDate(string3, parsePosition)));
                    string3 = string3.substring(parsePosition.getIndex()).trim();
                    parsePosition.setIndex(0);
                    n = 1;
                    continue;
                }
                if (n == 3) {
                    date = DateMatcher.parseDate(string3, parsePosition);
                    string3 = string3.substring(parsePosition.getIndex()).trim();
                    parsePosition.setIndex(0);
                    n = 4;
                    continue;
                }
                if (n == 4) {
                    matcher = pattern2.matcher(string3);
                    if (matcher.matches()) {
                        n = 5;
                        string3 = matcher.group(2);
                        continue;
                    }
                    this.l.add(new TimestampRange(date));
                    n = 1;
                    continue;
                }
                if (n != 5) continue;
                this.l.add(new TimestampRange(date, DateMatcher.parseDate(string3, parsePosition)));
                string3 = string3.substring(parsePosition.getIndex()).trim();
                parsePosition.setIndex(0);
                n = 1;
            }
            this.ranges = this.l.toArray(new TimestampRange[this.l.size()]);
        }

        public boolean matches(Date date) {
            if (this.ranges.length == 0) {
                return true;
            }
            for (int i = 0; i < this.ranges.length; ++i) {
                if (!this.ranges[i].matches(date)) continue;
                return true;
            }
            return false;
        }
    }
}

