/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.FileContents;
import com.ibm.dmh.util.LocaleMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Pattern;

public class FileUtils {
    public static void deleteChildren(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    FileUtils.deleteChildren(file2);
                }
                file2.delete();
            }
        }
    }

    public static void delete(File file) {
        FileUtils.deleteChildren(file);
        file.delete();
    }

    public static void copy(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            if (file2.exists()) {
                FileUtils.delete(file2);
            }
            file2.mkdirs();
            for (String string : file.list()) {
                FileUtils.copy(new File(file, string), new File(file2, string));
            }
        } else {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static File[] findChildren(File file, String string) {
        return FileUtils.findChildren(file, Pattern.compile(string.replace(".", "\\.").replace("*", ".*")));
    }

    public static File[] findChildren(File file, final Pattern pattern) {
        return file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return pattern.matcher(string).matches();
            }
        });
    }

    public static String read(File file) throws IOException {
        FileContents fileContents = new FileContents(file, null);
        return fileContents.getContents();
    }

    public static void write(File file, String string) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    public static void write(File file, InputStream inputStream) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public static void write(File file, Reader reader) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = bufferedReader.read(cArray)) != -1) {
            bufferedWriter.write(cArray, 0, n);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static void mkdirs(File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(!LocaleMgr.isUnix() || file.canRead() && file.canWrite())) {
            Runtime.getRuntime().exec("chmod 777 " + file.getAbsolutePath());
        }
    }
}

