/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class LicenseKeyUtil {
    public static String createLicenseKey(long l) {
        return LicenseKeyUtil.randHex(40) + Long.toHexString(l) + LicenseKeyUtil.randHex(29);
    }

    public static String createLicenseKey(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(n, n2);
        return LicenseKeyUtil.createLicenseKey(calendar.getTimeInMillis());
    }

    public static long decodeExpireTime(String string) {
        if (StringUtils.isEmpty(string)) {
            return 0L;
        }
        if (string.length() != 80) {
            throw new RuntimeException("License key was not 80 characters.");
        }
        return Long.parseLong(string.substring(40, 51), 16);
    }

    private static String randHex(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = (int)Math.floor(Math.random() * 16.0);
            stringBuffer.append(n2 < 10 ? (char)(48 + n2) : (char)(97 + n2 - 10));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2011, 7, 15);
        System.err.println("Time in millis=[" + gregorianCalendar.getTimeInMillis() + "]");
        String string = LicenseKeyUtil.createLicenseKey(gregorianCalendar.getTimeInMillis());
        System.err.println("licenseKey=[" + string + "]");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        long l = LicenseKeyUtil.decodeExpireTime(string);
        System.err.println("Time in millis=[" + l + "]");
        System.err.println("License good until [" + simpleDateFormat.format(new Date(l)) + "]");
    }
}

