/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleMgr {
    public static String getExternalDefaultEncoding() {
        String string = System.getProperty("externalFileEncoding");
        if (string != null && !string.trim().equals("")) {
            return string;
        }
        if (LocaleMgr.isZOS()) {
            String string2 = Locale.getDefault().getLanguage();
            String string3 = Locale.getDefault().getCountry();
            if (string2.equals("ja") || string3.equals("JP")) {
                return "Cp939";
            }
            return "Cp1047";
        }
        return Charset.defaultCharset().toString();
    }

    public static boolean isZOS() {
        String string = System.getProperty("os.name");
        return string.startsWith("OS/390") || string.startsWith("z/OS");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().indexOf("win") != -1;
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("ix") >= 0 || string.indexOf("ux") >= 0;
    }

    public static ResourceBundle getBundleForFile(File file) {
        return LocaleMgr.getBundleForFile(file.getAbsolutePath(), Locale.getDefault());
    }

    public static ResourceBundle getBundleForFile(String string) {
        return LocaleMgr.getBundleForFile(string, Locale.getDefault());
    }

    public static ResourceBundle getBundleForFile(String string, Locale locale) {
        string = string.replace('\\', '/');
        Pattern pattern = Pattern.compile("\\/?([^\\/].*)[\\/]([^\\/\\.]+)\\.[^\\.]+");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new URL("file:/" + string2 + "/"), new URL("file:/" + string2 + "/i18n/")});
            return ResourceBundle.getBundle(string3, locale, uRLClassLoader);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        try {
            string = string2.replace('/', '.') + "." + string3;
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                string = string2.replace('/', '.') + ".i18n." + string3;
                return ResourceBundle.getBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException2) {
                return null;
            }
        }
    }

    public static Locale getLocale(String string) {
        String[] stringArray = StringUtils.split(string, '_');
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            return new Locale(stringArray[0], "");
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    public static boolean isEnglishLocale() {
        return Locale.getDefault().getLanguage().equals("en");
    }
}

