/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.StringUtils;

public class ObjectUtils {
    public static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return StringUtils.getBoolean((String)object);
        }
        if (object != null) {
            return StringUtils.getBoolean(object.toString());
        }
        throw new RuntimeException("Null passed to ObjectUtils.toBoolean()");
    }

    public static boolean toBoolean(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        return ObjectUtils.toBoolean(object);
    }

    public static int toInt(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String && StringUtils.isNumeric((String)object)) {
            return StringUtils.getInt((String)object, 0);
        }
        throw new RuntimeException("Null or non-number passed to ObjectUtils.toInt().  o.class=[" + object.getClass().getName() + "], o.value=[" + object + "]");
    }

    public static int toInt(Object object, int n) {
        if (object == null) {
            return n;
        }
        return ObjectUtils.toInt(object);
    }

    public static long toLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String && StringUtils.isNumeric((String)object)) {
            return StringUtils.getInt((String)object, 0);
        }
        throw new RuntimeException("Null or non-number passed to ObjectUtils.toInt().  o.class=[" + object.getClass().getName() + "], o.value=[" + object + "]");
    }

    public static long toLong(Object object, long l) {
        if (object == null) {
            return l;
        }
        return ObjectUtils.toLong(object);
    }

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return object.toString();
        }
        throw new RuntimeException("Null passed to ObjectUtils.toString()");
    }

    public static String toString(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ObjectUtils.toString(object);
    }

    public static boolean[] toBooleanArray(Object[] objectArray) {
        boolean[] blArray = new boolean[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            blArray[i] = ObjectUtils.toBoolean(objectArray[i]);
        }
        return blArray;
    }

    public static int[] toIntArray(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = ObjectUtils.toInt(objectArray[i]);
        }
        return nArray;
    }

    public static String[] toStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = ObjectUtils.toString(objectArray[i]);
        }
        return stringArray;
    }
}

