/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.util.IStringSubstituter;
import com.ibm.jjson.JsonList;
import com.ibm.jjson.JsonMap;
import com.ibm.jjson.JsonParser;
import com.ibm.jjson.JsonSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    protected static Pattern applySubREPattern = Pattern.compile("^s/(.*[^/])/(.*)/(.*)$");
    private static Pattern timePattern;
    private static long SECOND;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static long MONTH;
    private static long YEAR;
    private static Pattern replaceVarsPattern;

    public static String[] split(String string, char c) {
        return StringUtils.split(string, c, false);
    }

    public static String[] split(String string, char c, boolean bl) {
        return StringUtils.split(string, c, bl, false);
    }

    public static String[] split(String string, char c, boolean bl, boolean bl2) {
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string) && !bl2) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                ++n2;
            } else if (cArray2[i] == c && n2 % 2 == 0) {
                String string2 = new String(cArray2, n, i - n);
                linkedList.add(StringUtils.strip(bl ? StringUtils.unEscapeChars(string2, cArray) : string2));
                n = i + 1;
            }
            if (cArray2[i] == '\\') continue;
            n2 = 0;
        }
        String string3 = new String(cArray2, n, cArray2.length - n);
        linkedList.add(StringUtils.strip(bl ? StringUtils.unEscapeChars(string3, cArray) : string3));
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] split2(String string, char c, boolean bl) {
        return StringUtils.split(string, c, bl, false);
    }

    public static String[] splitQuoted(String string, char c) {
        return StringUtils.splitQuoted(string, c, false, false);
    }

    public static String[] splitQuoted(String string, char c, boolean bl, boolean bl2) {
        return StringUtils.splitQuoted(string, c, bl, bl2, false);
    }

    public static String[] splitQuoted(String string, char c, boolean bl, boolean bl2, boolean bl3) {
        char c2;
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                ++n2;
            } else if (n2 % 2 == 0) {
                if (cArray2[i] == '\'' && !bl5) {
                    bl4 = !bl4;
                } else if (cArray2[i] == '\"' && !bl4) {
                    bl5 = !bl5;
                } else if (cArray2[i] == c && !bl4 && !bl5) {
                    String string2 = StringUtils.strip(new String(cArray2, n, i - n));
                    if (bl) {
                        string2 = StringUtils.unEscapeChars(string2, cArray);
                    }
                    if (bl2 && string2.length() > 1) {
                        c2 = string2.charAt(0);
                        char c3 = string2.charAt(string2.length() - 1);
                        if (c2 == '\'' && c3 == '\'' || c2 == '\"' && c3 == '\"') {
                            string2 = string2.substring(1, string2.length() - 1);
                        }
                    }
                    if (!bl3 || !StringUtils.isEmpty(string2)) {
                        linkedList.add(string2);
                    }
                    n = i + 1;
                }
            }
            if (cArray2[i] == '\\') continue;
            n2 = 0;
        }
        String string3 = StringUtils.strip(new String(cArray2, n, cArray2.length - n));
        if (bl) {
            string3 = StringUtils.unEscapeChars(string3, cArray);
        }
        if (bl2 && string3.length() > 1) {
            char c4 = string3.charAt(0);
            c2 = string3.charAt(string3.length() - 1);
            if (c4 == '\'' && c2 == '\'' || c4 == '\"' && c2 == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
        }
        if (!bl3 || !StringUtils.isEmpty(string3)) {
            linkedList.add(string3);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] splitBracketed(String string, char c, boolean bl) {
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '{') {
                ++n2;
            } else if (cArray2[i] == '}') {
                --n2;
            } else if (n2 == 0 && cArray2[i] == '\\') {
                ++n3;
            } else if (cArray2[i] == c && n2 == 0 && n3 % 2 == 0) {
                String string2 = StringUtils.strip(new String(cArray2, n, i - n));
                if (bl) {
                    string2 = StringUtils.unEscapeChars(string2, cArray);
                }
                linkedList.add(string2);
                n = i + 1;
            }
            if (cArray2[i] == '\\') continue;
            n3 = 0;
        }
        String string3 = StringUtils.strip(new String(cArray2, n, cArray2.length - n));
        linkedList.add(string3);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] splitOnAny(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
                ++n;
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        if (string2 == null || string2.length() == 0) {
            throw new RuntimeException((string2 == null ? "Null" : "Blank") + " delimiter passed to StringUtils.split(s, delim)");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            linkedList.add(StringUtils.strip(string.substring(n, n2)));
            n = n2 + string2.length();
        }
        linkedList.add(StringUtils.strip(string.substring(n)));
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String[] split(String string) {
        if (string == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static int countChars(String string, char c, boolean bl) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\\') {
                ++n2;
            } else if (c2 == c && n2 % 2 == 0) {
                ++n;
            }
            if (c2 == '\\') continue;
            n2 = 0;
        }
        return n;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0 || string.indexOf(string2) == -1) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
        return stringBuffer.append(string.substring(n)).toString();
    }

    public static String replace(String string, char c, char c2) {
        return StringUtils.replace(string, c, c2, false, false);
    }

    public static String replace(String string, char c, char c2, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c3 = cArray[i];
            if (c3 == '\\' && bl) {
                ++n;
            } else if (n % 2 == 0) {
                if (c3 == '\'' && bl2) {
                    ++n2;
                } else if (c3 == '\"' && bl2) {
                    ++n3;
                } else if (c3 == c && n2 % 2 == 0 && n3 % 2 == 0) {
                    cArray[i] = c2;
                }
            }
            if (cArray[i] == '\\') continue;
            n = 0;
        }
        return new String(cArray);
    }

    public static String escapeChars(String string, char[] cArray) {
        return StringUtils.escapeChars(string, cArray, '\\');
    }

    public static String escapeDoubleQuotes(String string) {
        return StringUtils.escapeChars(string, new char[]{'\"'}, '\\');
    }

    public static String escapeChar(String string, char c) {
        return StringUtils.escapeChars(string, new char[]{c}, '\\');
    }

    public static String escapeChars(String string, char[] cArray, char c) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < cArray.length && !bl; ++j) {
                bl = cArray2[i] == cArray[j] || cArray2[i] == c;
            }
            if (bl) {
                stringBuffer.append(c);
            }
            stringBuffer.append(cArray2[i]);
        }
        return stringBuffer.toString();
    }

    public static String unEscapeChars(String string, char[] cArray) {
        return StringUtils.unEscapeChars(string, cArray, '\\');
    }

    public static String unEscapeChars(String string, char[] cArray, char c) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            char c2 = cArray2[i];
            if (c2 == c && i + 1 != cArray2.length) {
                char c3 = cArray2[i + 1];
                boolean bl = false;
                for (int j = 0; j < cArray.length && !bl; ++j) {
                    bl = c3 == cArray[j];
                }
                if (bl) {
                    ++i;
                } else if (c3 == c) {
                    stringBuffer.append(c);
                    ++i;
                }
            }
            stringBuffer.append(cArray2[i]);
        }
        return stringBuffer.toString();
    }

    public static boolean isNumeric(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n2 = n = cArray[0] == '-' ? 1 : 0;
        while (n < cArray.length) {
            if (cArray[n] < '0' || cArray[n] > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            stringBuffer.append(objectArray[0]);
        }
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(string).append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(int[] nArray, String string) {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = nArray[i];
        }
        return StringUtils.join(objectArray, string);
    }

    public static String join(Object[] objectArray, char c, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        char[] cArray = new char[]{c};
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            stringBuffer.append(bl ? StringUtils.escapeChars(objectArray[0] == null ? "null" : objectArray[0].toString(), cArray) : objectArray[0]);
        }
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(c).append(bl ? StringUtils.escapeChars(objectArray[i] == null ? "null" : objectArray[i].toString(), cArray) : objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String join(Iterator iterator, String string) {
        if (iterator == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(string).append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String join(Collection collection, String string) {
        return collection == null ? "" : StringUtils.join(collection.iterator(), string);
    }

    public static String quoteAndJoin(Iterator iterator, String string) {
        return StringUtils.quoteAndJoin(iterator, '\'', string);
    }

    public static String quoteAndJoin(Iterator iterator, char c, String string) {
        return StringUtils.quoteAndJoin(iterator, c + "", c + "", string);
    }

    public static String quoteAndJoin(Iterator iterator, String string, String string2, String string3) {
        if (iterator == null) {
            return null;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(string).append(iterator.next()).append(string2);
        }
        while (iterator.hasNext()) {
            stringBuffer.append(string3).append(string).append(iterator.next()).append(string2);
        }
        return stringBuffer.toString();
    }

    public static String join(Collection collection, char c, boolean bl) {
        return StringUtils.join(collection.iterator(), c, bl);
    }

    public static String join(Iterator iterator, char c, boolean bl) {
        String string;
        Object e;
        if (iterator == null) {
            return null;
        }
        char[] cArray = new char[]{c};
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            e = iterator.next();
            string = e == null ? "null" : e.toString();
            stringBuffer.append(bl ? StringUtils.escapeChars(string, cArray) : string);
        }
        while (iterator.hasNext()) {
            e = iterator.next();
            string = e == null ? "null" : e.toString();
            stringBuffer.append(c).append(bl ? StringUtils.escapeChars(string, cArray) : string);
        }
        return stringBuffer.toString();
    }

    public static String strip(String string, String string2) {
        int n;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return string;
        }
        char[] cArray = string2.toCharArray();
        char[] cArray2 = string.toCharArray();
        int n2 = 0;
        int n3 = cArray2.length - 1;
        for (n = 0; n < cArray2.length; ++n) {
            if (cArray2[n] == ' ' || cArray2[n] == '\t' || StringUtils.charIsOneOf(cArray2[n], cArray)) {
                ++n2;
                continue;
            }
            n = cArray2.length;
        }
        for (n = n3; n > n2; --n) {
            if (cArray2[n] == ' ' || cArray2[n] == '\t' || StringUtils.charIsOneOf(cArray2[n], cArray)) {
                --n3;
                continue;
            }
            n = n2;
        }
        return new String(cArray2, n2, n3 - n2 + 1);
    }

    public static String strip(String string) {
        return StringUtils.strip(string, " \t\r\n");
    }

    public static String[] strip(String[] stringArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl && StringUtils.isEmpty(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean charIsOneOf(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return true;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return false;
        }
        return true;
    }

    public static boolean getBoolean(String string) {
        return StringUtils.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return bl;
        }
        char c = string.charAt(0);
        return c == 'T' || c == 't' || c == 'Y' || c == 'y' || c == '1';
    }

    public static int getInt(String string, int n) {
        if (!StringUtils.isNumeric(string)) {
            return n;
        }
        return Integer.parseInt(string);
    }

    public static int[] getInts(String string) {
        int[] nArray = new int[StringUtils.countChars(string, ',', false) + 1];
        int n = 0;
        for (String string2 : StringUtils.split(string, ',')) {
            nArray[n++] = Integer.parseInt(string2);
        }
        return nArray;
    }

    public static Integer getInteger(String string, Integer n) {
        if (!StringUtils.isNumeric(string)) {
            return n;
        }
        return Integer.parseInt(string);
    }

    public static long getLong(String string, long l) {
        if (!StringUtils.isNumeric(string)) {
            return l;
        }
        return Long.parseLong(string);
    }

    public static Long getLong(String string, Long l) {
        if (!StringUtils.isNumeric(string)) {
            return l;
        }
        return Long.parseLong(string);
    }

    public static char getChar(String string, char c) {
        if (string == null || string.length() == 0) {
            return c;
        }
        return string.charAt(0);
    }

    public static String[] getVars(String string, String string2) {
        string = string + "{";
        int n = string.length();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = string2.indexOf(string);
        while (n2 != -1) {
            int n3 = string2.indexOf(125, n2);
            if (n3 != -1) {
                linkedList.add(string2.substring(n2 + n, n3));
                n2 = string2.indexOf(string, n3);
                continue;
            }
            n2 = -1;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String getString(String string, String string2) {
        return StringUtils.coalesce(string, string2);
    }

    public static String coalesce(String ... stringArray) {
        for (String string : stringArray) {
            if (StringUtils.isEmpty(string)) continue;
            return string;
        }
        return stringArray[stringArray.length - 1];
    }

    public static String getString(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            string = string2;
        }
        if (string == null) {
            return null;
        }
        return bl ? string.trim() : string;
    }

    public static LinkedHashMap<String, String> getMap(String string) throws ParseException {
        return StringUtils.getMap(string, ',', '=');
    }

    public static LinkedHashMap<String, String> getMap(String string, char c, char c2) throws ParseException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String[] stringArray = StringUtils.split(string, c, true);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtils.split(stringArray[i], c2, true);
            if (stringArray2.length != 2) {
                throw new ParseException("Invalid map string: [" + string + "]", 0);
            }
            String string2 = linkedHashMap.put(stringArray2[0], stringArray2[1]);
            if (string2 == null) continue;
            throw new ParseException("Duplicate keys in map string: [" + string + "]", 0);
        }
        return linkedHashMap;
    }

    public static String makeUnicodeReadable(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' || c > '~') {
                stringBuffer.append("\\u" + StringUtils.toHex(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String convertToCsv(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    bl = true;
                    break;
                }
                case ',': {
                    bl = true;
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    bl = true;
                    break;
                }
            }
            stringBuffer.append(c);
        }
        return bl ? "\"" + stringBuffer + "\"" : string;
    }

    public static String toValidXmlString(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i];
            if (n == 62 || n == 60 || n == 34 || n == 39) {
                n = 63;
            } else if (!(n == 10 || n >= 32 && n <= 55295 || n >= 57344 && n <= 65533)) {
                n = 63;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public static String htmlEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '@' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '-' && c <= '9' || c == '*' || c == '+' || c == '_') {
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append("%u" + StringUtils.toHex(c));
                continue;
            }
            stringBuffer.append("%" + StringUtils.toHex(c, 2));
        }
        return stringBuffer.toString();
    }

    public static String toHex(int n, int n2) {
        String string = StringUtils.toHex(n);
        return n2 == 4 ? string : string.substring(4 - n2);
    }

    public static String toHex(int n) {
        char[] cArray = new char[4];
        int n2 = n % 16;
        cArray[3] = (char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2);
        int n3 = 16;
        for (int i = 1; i < 4; ++i) {
            n2 = n / n3 % 16;
            n3 <<= 4;
            cArray[3 - i] = (char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2);
        }
        return new String(cArray);
    }

    public static String toHex(long l) {
        char[] cArray = new char[8];
        long l2 = l % 16L;
        cArray[7] = (char)(l2 > 9L ? 65L + l2 - 10L : 48L + l2);
        int n = 16;
        for (int i = 1; i < 8; ++i) {
            l2 = l / (long)n % 16L;
            n <<= 4;
            cArray[7 - i] = (char)(l2 > 9L ? 65L + l2 - 10L : 48L + l2);
        }
        return new String(cArray);
    }

    public static boolean isValidIdentifier(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0 && !Character.isLetter(cArray[i])) {
                return false;
            }
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public static String escapeApostrophes(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                ++n;
            } else if (n % 2 == 0) {
                if (cArray[i] == '\'') {
                    if (bl2 || i > 0 && i < cArray.length - 1 && !Character.isWhitespace(cArray[i - 1]) && cArray[i - 1] != '+' && cArray[i - 1] != '-' && !Character.isWhitespace(cArray[i + 1])) {
                        stringBuffer.append('\\');
                    } else {
                        bl = !bl;
                    }
                } else if (cArray[i] == '\"') {
                    if (bl || i > 0 && i < cArray.length - 1 && !Character.isWhitespace(cArray[i - 1]) && cArray[i - 1] != '+' && cArray[i - 1] != '-' && !Character.isWhitespace(cArray[i + 1])) {
                        stringBuffer.append('\\');
                    } else {
                        boolean bl3 = bl2 = !bl2;
                    }
                }
            }
            if (cArray[i] != '\\') {
                n = 0;
            }
            stringBuffer.append(cArray[i]);
        }
        if (bl || bl2) {
            throw new RuntimeException("Single or double quote not properly closed in the following expression: [" + string + "]");
        }
        return stringBuffer.toString();
    }

    public static String[] fragment(String string, int n, String string2) throws UnsupportedEncodingException {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (!StringUtils.isEmpty(string)) {
            String string3 = StringUtils.truncateBytes(string, n, string2);
            string = string.substring(string3.length());
            linkedList.add(string3);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String applySubRE(String string, String string2) {
        Matcher matcher = applySubREPattern.matcher(string);
        if (matcher.find()) {
            boolean bl = matcher.group(3).indexOf(103) != -1;
            boolean bl2 = matcher.group(3).indexOf(115) == -1;
            Pattern pattern = Pattern.compile(matcher.group(1), bl2 ? 8 : 32);
            Matcher matcher2 = pattern.matcher(string2);
            if (bl) {
                return matcher2.replaceAll(matcher.group(2));
            }
            return matcher2.replaceFirst(matcher.group(2));
        }
        return string2;
    }

    public static boolean containsUnEscapedChars(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                bl = !bl;
                continue;
            }
            if (!bl) {
                for (int j = 0; j < cArray.length; ++j) {
                    if (cArray2[i] != cArray[j]) continue;
                    return true;
                }
            }
            bl = false;
        }
        return false;
    }

    public static boolean containsEscapedChars(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                bl = !bl;
                continue;
            }
            if (bl) {
                for (int j = 0; j < cArray.length; ++j) {
                    if (cArray2[i] != cArray[j]) continue;
                    return true;
                }
            }
            bl = false;
        }
        return false;
    }

    public static String chop(String string, int n) {
        return StringUtils.chop(string, n, false, false);
    }

    public static String chop(String string, int n, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (string.length() < n) {
            if (bl2) {
                StringBuilder stringBuilder = new StringBuilder(n);
                stringBuilder.append(string);
                for (int i = string.length(); i < n; ++i) {
                    stringBuilder.append(' ');
                }
                return stringBuilder.toString();
            }
            return string;
        }
        if (bl) {
            return string.substring(string.length() - n);
        }
        return string.substring(0, n);
    }

    public static String[] addToArray(String[] stringArray, String string) {
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[1] : new String[stringArray.length + 1];
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static String toValidXml(String string) {
        if (string == null) {
            return "null";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"' && !Character.isISOControl(c)) continue;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c == '&') {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append("&quot;");
                    continue;
                }
                if (Character.isISOControl(c)) {
                    stringBuffer.append("&#" + c + ";");
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String toValidHtml(String string) {
        if (string == null) {
            return "null";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"' && c != '\n' && c != '\t' && !Character.isISOControl(c)) continue;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c == '&') {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append("&quot;");
                    continue;
                }
                if (c == '\n') {
                    stringBuffer.append("<br>");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer.append("&nbsp;&nbsp;&nbsp;");
                    continue;
                }
                if (Character.isISOControl(c)) {
                    stringBuffer.append("&#" + c + ";");
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String[] toValidHtml(String[] stringArray) {
        if (stringArray == null) {
            return stringArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = StringUtils.toValidHtml(stringArray[i]);
        }
        return stringArray;
    }

    public static String toValidXmlAttr(String string) {
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\'' && c != '&' && c != '<' && !Character.isISOControl(c)) continue;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c == '\"') {
                    stringBuffer.append("&quot;");
                    continue;
                }
                if (c == '\'') {
                    stringBuffer.append("&#39;");
                    continue;
                }
                if (c == '&') {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (Character.isISOControl(c)) {
                    stringBuffer.append("&#" + c + ";");
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String toValidJavascriptParam(String string) {
        return StringUtils.escapeChars(string, new char[]{'\'', '\"'});
    }

    public static long parseTime(String string) {
        if (timePattern == null) {
            timePattern = Pattern.compile("(\\d+)\\s*(\\w*)");
        }
        if ((string = string.toUpperCase()).equals("NEVER")) {
            return Long.MAX_VALUE;
        }
        if (string.equals("")) {
            return 0L;
        }
        Matcher matcher = timePattern.matcher(string);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid time string format: [" + string + "]");
        }
        long l = Long.parseLong(matcher.group(1));
        String string2 = matcher.group(2);
        if (string2.startsWith("S")) {
            l *= SECOND;
        } else if (string2.startsWith("MIN")) {
            l *= MINUTE;
        } else if (string2.startsWith("H")) {
            l *= HOUR;
        } else if (string2.startsWith("D")) {
            l *= DAY;
        } else if (string2.startsWith("W")) {
            l *= WEEK;
        } else if (string2.startsWith("MO")) {
            l *= MONTH;
        } else if (string2.startsWith("Y")) {
            l *= YEAR;
        }
        return l;
    }

    public static String getTimeString(long l) {
        long l2;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (l == Long.MAX_VALUE) {
            return "never";
        }
        if (l >= YEAR) {
            l2 = l / YEAR;
            l %= YEAR;
            linkedList.add(l2 + " year" + (l2 > 1L ? "s" : ""));
        }
        if (l >= MONTH) {
            l2 = l / MONTH;
            l %= MONTH;
            linkedList.add(l2 + " month" + (l2 > 1L ? "s" : ""));
        }
        if (l >= DAY) {
            l2 = l / DAY;
            l %= DAY;
            linkedList.add(l2 + " day" + (l2 > 1L ? "s" : ""));
        }
        if (l >= HOUR) {
            l2 = l / HOUR;
            l %= HOUR;
            linkedList.add(l2 + " hour" + (l2 > 1L ? "s" : ""));
        }
        if (l >= MINUTE) {
            l2 = l / MINUTE;
            l %= MINUTE;
            linkedList.add(l2 + " minute" + (l2 > 1L ? "s" : ""));
        }
        if (l >= SECOND) {
            l2 = l / SECOND;
            l %= SECOND;
            linkedList.add(l2 + " second" + (l2 > 1L ? "s" : ""));
        }
        return StringUtils.join(linkedList.iterator(), ",");
    }

    public static String getTimeStringShort(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 0L) {
            return "00:00:00.000";
        }
        long l2 = l / HOUR;
        stringBuffer.append((l2 < 10L ? "0" : "") + l2 + ":");
        l2 = (l %= HOUR) / MINUTE;
        stringBuffer.append((l2 < 10L ? "0" : "") + l2 + ":");
        l2 = (l %= MINUTE) / SECOND;
        stringBuffer.append((l2 < 10L ? "0" : "") + l2 + ".");
        l2 = l %= SECOND;
        stringBuffer.append((l2 < 10L ? "00" : (l2 < 100L ? "0" : "")) + l2);
        return stringBuffer.toString();
    }

    public static boolean needsTruncate(String string, int n, String string2) throws UnsupportedEncodingException {
        return string.getBytes(string2).length > n;
    }

    public static String truncateBytes(String string, int n, String string2) throws UnsupportedEncodingException {
        Charset charset = Charset.forName(string2);
        CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(new byte[]{63});
        try {
            CharBuffer charBuffer = CharBuffer.wrap(string);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            boolean bl = false;
            byte[] byArray = byteBuffer.array();
            for (int i = 0; i < byArray.length && !bl; ++i) {
                if (byArray[i] != 63) continue;
                bl = true;
            }
            String string3 = null;
            if (coderResult.isOverflow() || bl) {
                byteBuffer.limit(byteBuffer.position());
                CharsetDecoder charsetDecoder = charset.newDecoder();
                byteBuffer.rewind();
                string3 = charsetDecoder.decode(byteBuffer).toString();
            } else {
                string3 = string;
            }
            if (string3.getBytes(string2).length > n) {
                return string3.substring(0, string3.length() - 1);
            }
            return string3;
        }
        catch (Throwable throwable) {
            while (string.getBytes(string2).length > n) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
    }

    public static String getReaderContents(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = reader.read(cArray, 0, 1024)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static boolean isHexChars(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= 'a' && cArray[i] <= 'f' || cArray[i] >= 'A' && cArray[i] <= 'F') continue;
            return false;
        }
        return true;
    }

    public static boolean isLike(String string, String string2) {
        char c = '*';
        char c2 = '?';
        return StringUtils.isLike(string, string2, c, c2);
    }

    public static boolean isLike(String string, String string2, char c, char c2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (string2.equals(string)) {
            return true;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string2.length();
        while (n3 < n) {
            char c3;
            if ((c3 = stringBuffer.charAt(n3++)) == c) {
                if (n3 >= n) {
                    return true;
                }
                n4 = n3;
                continue;
            }
            if (n2 >= n5) {
                return false;
            }
            char c4 = stringBuffer2.charAt(n2++);
            if (c3 == c2 || c3 == c4) {
                if (n4 <= 0 || n3 < n || n2 >= n5) continue;
            } else if (n4 == 0) {
                return false;
            }
            int n6 = n3 - n4 - 1;
            n3 = n4;
            n2 -= n6;
        }
        return n2 >= n5;
    }

    public static String[] removeDuplicates(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            hashSet.add(string);
        }
        String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        return stringArray2;
    }

    public static String substitute(String string, Pattern pattern, IStringSubstituter iStringSubstituter) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (matcher.find()) {
            stringBuffer.append(string.substring(n, matcher.start()));
            stringBuffer.append(iStringSubstituter.substitute(matcher));
            n = matcher.end();
        }
        if (n == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static List<String> splitToList(String string, char c) {
        return StringUtils.splitToList(string, c, true);
    }

    public static List<String> splitToList(String string, char c, boolean bl) {
        if (string == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split(string, c, bl, false));
    }

    public static List<String> splitQuotedToList(String string, char c) {
        return StringUtils.splitQuotedToList(string, c, true, true, false);
    }

    public static List<String> splitQuotedToList(String string, char c, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.splitQuoted(string, c, bl, bl2, bl3));
    }

    public static JsonList splitList(String string) {
        if (string == null) {
            return new JsonList();
        }
        if (string.startsWith("[")) {
            return new JsonList((CharSequence)string);
        }
        return new JsonList(StringUtils.splitToList(string, ','));
    }

    public static JsonMap<String, Object> parseUrlQuery(String string) throws Exception {
        char c;
        if (StringUtils.isEmpty(string)) {
            return new JsonMap();
        }
        if (string.charAt(0) == '?') {
            string = string.substring(1);
        }
        JsonMap jsonMap = new JsonMap();
        int n = 1;
        int n2 = 2;
        int n3 = 0;
        int n4 = n;
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (n4 == n) {
                if (c == '=') {
                    string2 = URLDecoder.decode(string.substring(n3, i), "UTF-8");
                    n3 = i + 1;
                    n4 = n2;
                    continue;
                }
                if (c != '&') continue;
                string2 = URLDecoder.decode(string.substring(n3, i), "UTF-8");
                n3 = i + 1;
                jsonMap.put((Object)string2, null);
                n4 = n;
                continue;
            }
            if (n4 != n2 || c != '&') continue;
            String string3 = URLDecoder.decode(string.substring(n3, i), "UTF-8");
            char c2 = string3.length() == 0 ? (char)'\u0000' : string3.charAt(0);
            jsonMap.put((Object)string2, c2 == '{' || c2 == '[' ? JsonParser.DEFAULT.parse((CharSequence)string3) : string3);
            n4 = n;
            n3 = i + 1;
        }
        if (n4 == n && n3 < string.length()) {
            jsonMap.put((Object)URLDecoder.decode(string.substring(n3, string.length()), "UTF-8"), null);
        } else if (n4 == n2) {
            String string4 = URLDecoder.decode(string.substring(n3, string.length()), "UTF-8");
            c = string4.length() == 0 ? (char)'\u0000' : string4.charAt(0);
            jsonMap.put((Object)string2, c == '{' || c == '[' ? JsonParser.DEFAULT.parse((CharSequence)string4) : string4);
        }
        return jsonMap;
    }

    public static String createUrlQuery(JsonMap jsonMap) {
        try {
            int n = 63;
            StringBuffer stringBuffer = new StringBuffer();
            for (Map.Entry entry : jsonMap.entrySet()) {
                stringBuffer.append((char)n);
                n = 38;
                stringBuffer.append(URLEncoder.encode(entry.getKey().toString(), "UTF-8"));
                Object v = entry.getValue();
                if (v == null) continue;
                stringBuffer.append("=");
                if (v instanceof Map || v instanceof Collection) {
                    stringBuffer.append(URLEncoder.encode(JsonSerializer.DEFAULT_CONDENSED.serialize(v), "UTF-8"));
                    continue;
                }
                stringBuffer.append(URLEncoder.encode(v.toString(), "UTF-8"));
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static List<String> toStringList(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (Object e : collection) {
                arrayList.add(e == null ? null : e.toString());
            }
            return arrayList;
        }
        return StringUtils.splitToList(object.toString(), ',');
    }

    public static String[] append(String[] stringArray, String ... stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + stringArray2.length);
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.addAll(Arrays.asList(stringArray2));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] prepend(String[] stringArray, String ... stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + stringArray2.length);
        arrayList.addAll(Arrays.asList(stringArray2));
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] remove(String[] stringArray, String ... stringArray2) {
        if (stringArray == null) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        for (String string : stringArray2) {
            linkedList.remove(string);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String replaceVars(String string, final Map map) {
        return StringUtils.substitute(string, replaceVarsPattern, new IStringSubstituter(){

            public String substitute(Matcher matcher) {
                String string = matcher.group(1);
                return map.containsKey(string) ? map.get(string).toString() : null;
            }
        });
    }

    public static String repeat(String string, int n) {
        return StringUtils.repeatAndAppend(new StringBuilder(), string, n).toString();
    }

    public static StringBuilder repeatAndAppend(StringBuilder stringBuilder, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    public static String format(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        new Formatter(stringBuilder).format(string, objectArray);
        return stringBuilder.toString();
    }

    public static String bytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static byte[] hexToBytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = i * 2;
            int n2 = Integer.parseInt(string.substring(n, n + 2), 16);
            byArray[i] = (byte)n2;
        }
        return byArray;
    }

    public static String toValidUrl(String string) {
        try {
            boolean bl = false;
            for (int i = 0; i < string.length() && !bl; ++i) {
                if (string.charAt(i) <= '\u007f' && string.charAt(i) != ' ') continue;
                bl = true;
            }
            if (!bl) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ') {
                    stringBuilder.append('+');
                    continue;
                }
                if (c > '\u007f') {
                    stringBuilder.append(URLEncoder.encode("" + c, "UTF-8"));
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String trimEnd(String string) {
        int n;
        for (n = string.length() - 1; n > 0 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        return string.substring(0, n + 1);
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(throwable.toString() + "\n");
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            stringBuilder.append("\tat " + stackTraceElement + "\n");
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuilder.append("Caused by: " + throwable2 + "\n");
            StackTraceElement[] stackTraceElementArray2 = throwable2.getStackTrace();
            int n = StringUtils.countTraceDuplicates(stackTraceElementArray2, stackTraceElementArray);
            for (int i = 0; i < stackTraceElementArray2.length - n; ++i) {
                stringBuilder.append("\tat " + stackTraceElementArray2[i] + "\n");
            }
            if (n > 0) {
                stringBuilder.append("\t... " + n + " more\n");
            }
            stackTraceElementArray = stackTraceElementArray2;
        }
        return stringBuilder.toString();
    }

    private static int countTraceDuplicates(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement stackTraceElement;
        int n = 0;
        int n2 = stackTraceElementArray2.length;
        int n3 = stackTraceElementArray.length;
        while (--n3 >= 0 && --n2 >= 0 && (stackTraceElement = stackTraceElementArray2[n2]).equals(stackTraceElementArray[n3])) {
            ++n;
        }
        return n;
    }

    static {
        SECOND = 1000L;
        MINUTE = SECOND * 60L;
        HOUR = MINUTE * 60L;
        DAY = HOUR * 24L;
        WEEK = DAY * 7L;
        MONTH = DAY * 31L;
        YEAR = DAY * 365L;
        replaceVarsPattern = Pattern.compile("\\{([^\\}]+)\\}");
    }
}

