/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.ProcessExec;
import com.ibm.dmh.cfgmgr.ConfigMgr;
import com.ibm.dmh.db.DataSourceAdmin;
import com.ibm.dmh.db.DbFlags;
import com.ibm.dmh.db.DbInfo;
import com.ibm.dmh.db.DbLoadStatement;
import com.ibm.dmh.db.DbMetaData;
import com.ibm.dmh.db.DbPreparedStatement;
import com.ibm.dmh.db.DbResultSet;
import com.ibm.dmh.db.DbStats;
import com.ibm.dmh.db.JdbcDriverAdmin;
import com.ibm.dmh.db.PrimaryKeyGenerator;
import com.ibm.dmh.db.SQLRuntimeException;
import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.msg.MsgMgr;
import com.ibm.dmh.msg.WsaaException;
import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAdmin {
    private static boolean autoCommitEnabled;
    static boolean isLegacyDriver;
    public static boolean hasBeenInitialized;
    private static DbInfo dbInfo;
    private static DbMetaData dbMetaData;
    private static Logger logger;
    public static String encoding;
    private static String schemaName;
    private static boolean debug;
    protected static int maxBatchExecuteSize;
    protected static int maxBatchCommitSize;
    private static boolean loadsAllowed;
    private static boolean deleteFromSelectAllowed;
    public static int accessMethod;
    public static final int DATASOURCE = 1;
    public static final int JDBC = 2;
    public static final int SHARE = 1;
    public static final int EXCLUSIVE = 2;
    private static ThreadLocal<String> threadUser;
    private static ThreadLocal<String> threadPw;
    private static ThreadLocal<Connection> threadConnection;
    protected static ThreadLocal<DbStats> dbStats;
    protected static ThreadLocal<Writer> dbLog;
    private static ThreadLocal<Map<String, DbPreparedStatement>> psReusableCache;
    private static ThreadLocal<Set<DbPreparedStatement>> psNonReusableCache;
    private static ThreadLocal<Set<DbResultSet>> rsCache;
    private static Map<String, PrimaryKeyGenerator> pkCache;
    private static ThreadLocal<Map<String, Integer>> lockedTables;
    private static Pattern copySqlPattern;

    public static boolean initializeJdbc(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, int n, int n2) throws Exception {
        autoCommitEnabled = bl;
        schemaName = string6.toUpperCase();
        encoding = string7;
        DbAdmin.setThreadUser(string2, string3);
        JdbcDriverAdmin.init(string, string4, string5);
        accessMethod = 2;
        dbInfo = new DbInfo(DbAdmin.getThreadConnection(), string6);
        dbMetaData = new DbMetaData(DbAdmin.getThreadConnection(), string6, "");
        maxBatchExecuteSize = n;
        maxBatchCommitSize = n2;
        return true;
    }

    public static boolean initializeDatasource(String string, String string2, String string3, String string4, String string5, boolean bl, int n, int n2) throws Exception {
        autoCommitEnabled = bl;
        schemaName = string4.toUpperCase();
        encoding = string5;
        DbAdmin.setThreadUser(string2, string3);
        DataSourceAdmin.init(string);
        accessMethod = 1;
        dbInfo = new DbInfo(DbAdmin.getThreadConnection(), string4);
        dbMetaData = new DbMetaData(DbAdmin.getThreadConnection(), string4, "");
        maxBatchExecuteSize = n;
        maxBatchCommitSize = n2;
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initialize(boolean bl) throws WsaaException {
        if (hasBeenInitialized) {
            return;
        }
        String string = ConfigMgr.get((String)"Common.Database.username");
        String string2 = ConfigMgr.get((String)"Common.Database.password");
        String string3 = ConfigMgr.get((String)"Common.Database.schema");
        String string4 = ConfigMgr.get((String)"Common.Database.encoding");
        String string5 = ConfigMgr.get((String)"Common.Database.dataSource");
        String string6 = ConfigMgr.get((String)"Common.Database.url");
        String string7 = ConfigMgr.get((String)"Common.Database.driver");
        String string8 = ConfigMgr.get((String)"Common.PrereqPaths.db2JdbcDriverJar");
        int n = ConfigMgr.getInt((String)"Common.Database.maxBatchExecuteSize");
        int n2 = ConfigMgr.getInt((String)"Common.Database.maxBatchCommitSize");
        String[] stringArray = StringUtils.split((String)ConfigMgr.get((String)"Common.Database.accessMethods"), (char)',');
        for (int i = 0; i < stringArray.length && accessMethod == 0; ++i) {
            if (stringArray[i].equalsIgnoreCase("DATASOURCE")) {
                try {
                    DbAdmin.initializeDatasource(string5, string, string2, string3, string4, bl, n, n2);
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "Access to database using method [DATASOURCE] failed:  [" + throwable.getClass().getName() + "," + throwable.getMessage() + "]");
                    logger.log(Level.FINE, throwable.getLocalizedMessage(), throwable);
                }
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("JDBC")) {
                throw new WsaaException(MsgMgr.dmh7882e((String)stringArray[i]));
            }
            try {
                DbAdmin.initializeJdbc(string6, string, string2, string7, string8, string3, string4, bl, n, n2);
                continue;
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Access to database using method [JDBC] failed:  [" + throwable.getMessage() + "]");
                logger.log(Level.WARNING, throwable.getLocalizedMessage(), throwable);
            }
        }
        if (accessMethod == 0) {
            throw new WsaaException(MsgMgr.dmh7883e());
        }
        logger.log(Level.INFO, "Accessing database using method [" + (accessMethod == 1 ? "DATASOURCE" : "JDBC") + "]");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string9 = "Not set to anything yet";
        try {
            block32: {
                connection = DbAdmin.getConnection(bl, ConfigMgr.get((String)"Common.Database.username"), ConfigMgr.get((String)"Common.Database.password"));
                statement = connection.createStatement();
                string9 = "select 1 from sysibm.sysdummy1";
                statement.executeQuery(string9);
                string9 = "select count(*) from sysibm.syscolumns";
                statement.executeQuery(string9);
                string9 = "select count(*) from sysibm.systables";
                statement.executeQuery(string9);
                string9 = "delete from " + string3 + ".DMH_SYSTEM_ATTR where SYS_ATTR_ID=999";
                statement.execute(string9);
                string9 = "insert into " + string3 + ".DMH_SYSTEM_ATTR(SYS_ATTR_ID, UPDATE_TIMESTAMP) values (999, current timestamp)";
                statement.execute(string9);
                string9 = "update " + string3 + ".DMH_SYSTEM_ATTR set SYS_CHAR_ATTR='test' where SYS_ATTR_ID=999";
                statement.execute(string9);
                string9 = "select * from " + string3 + ".DMH_SYSTEM_ATTR where SYS_ATTR_ID=999";
                statement.execute(string9);
                string9 = "delete from " + string3 + ".DMH_SYSTEM_ATTR where SYS_ATTR_ID=999";
                statement.execute(string9);
                try {
                    deleteFromSelectAllowed = true;
                    string9 = "delete from (select * from " + string3 + ".DMH_SYSTEM_ATTR where SYS_ATTR_ID=999)";
                    statement.execute(string9);
                    logger.info("Delete-from-select clauses are allowed.");
                }
                catch (SQLException sQLException) {
                    logger.info("Delete-from-select clauses are not allowed.");
                    deleteFromSelectAllowed = false;
                }
                try {
                    string9 = "declare global temporary table GTTTEST(testcol integer)" + (dbInfo.isDb2Zos() ? "" : " not logged");
                    statement.execute(string9);
                    string9 = "drop table SESSION.GTTTEST";
                    statement.execute(string9);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -601) break block32;
                    throw sQLException;
                }
            }
            try {
                isLegacyDriver = false;
                boolean bl2 = isLegacyDriver = !connection.getMetaData().supportsResultSetHoldability(1);
                if (!isLegacyDriver) {
                    Statement statement2 = connection.createStatement(1003, 1007, 1);
                    DbAdmin.close(statement2);
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                isLegacyDriver = true;
            }
            catch (SQLException sQLException) {
                isLegacyDriver = true;
            }
            if (isLegacyDriver) {
                logger.log(Level.WARNING, "Legacy driver detected.  Statement-level cursor holdability not supported.");
                if (accessMethod == 1) {
                    try {
                        resultSet = statement.executeQuery("select * from " + string3 + ".DMH_SYSTEM_ATTR");
                        statement.getConnection().commit();
                        if (!resultSet.next()) {
                            throw new WsaaException(MsgMgr.dmh7910e());
                        }
                        logger.log(Level.INFO, "Connection-level cursor holdability appears to be enabled.");
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, exception.getLocalizedMessage());
                        throw new WsaaException(MsgMgr.dmh7910e());
                    }
                }
            }
            loadsAllowed = ConfigMgr.getBoolean((String)"Common.Database.loadsAllowed", (boolean)false) && !dbInfo.isDb2Zos();
        }
        catch (SQLException sQLException) {
            try {
                int n3 = sQLException.getErrorCode();
                if (n3 == -1013) {
                    throw new WsaaException(MsgMgr.dmh5983e((String)ConfigMgr.get((String)"Common.Database.url")), (Throwable)sQLException);
                }
                if (n3 == -1403 || n3 == -30082 || n3 == -922) {
                    throw new WsaaException(MsgMgr.dmh5984e((String)string), (Throwable)sQLException);
                }
                if (n3 == -551) {
                    throw new WsaaException(MsgMgr.dmh5985e(), (Throwable)sQLException);
                }
                if (n3 == -204) {
                    logger.log(Level.SEVERE, "SQLError[" + n3 + "]: Offending SQL=[" + string9 + "]");
                    throw new WsaaException(MsgMgr.dmh7884e(), (Throwable)sQLException);
                }
                System.err.println("SQLError[" + n3 + "]: Offending SQL=[" + string9 + "]");
                throw new WsaaException(MsgMgr.dmh5986e((String)("" + n3)), (Throwable)sQLException);
                catch (WsaaException wsaaException) {
                    logger.log(Level.SEVERE, "Error in DbAdmin.initialize(): " + wsaaException.getMessage());
                    throw wsaaException;
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "SQLError[" + throwable.getMessage() + "]: Offending SQL=[" + string9 + "]");
                    throw new WsaaException(MsgMgr.dmh5986e((String)"N/A"), throwable);
                }
            }
            catch (Throwable throwable) {
                DbAdmin.close(statement, resultSet);
                DbAdmin.close(connection);
                throw throwable;
            }
        }
        DbAdmin.close(statement, resultSet);
        DbAdmin.close(connection);
        hasBeenInitialized = true;
    }

    private static Connection getConnection(boolean bl, String string, String string2) throws SQLRuntimeException {
        Connection connection = null;
        try {
            switch (accessMethod) {
                case 1: {
                    connection = DataSourceAdmin.getConnection(string, string2);
                    break;
                }
                case 2: {
                    connection = JdbcDriverAdmin.getConnection(string, string2);
                }
            }
            connection.setAutoCommit(bl);
            if (connection.getTransactionIsolation() != 1) {
                connection.setTransactionIsolation(1);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLRuntimeException(sQLException);
        }
        return connection;
    }

    public static void startProfiling(int n) {
        if (n > 0) {
            dbStats.set(new DbStats(n));
        }
    }

    public static DbStats stopProfiling() {
        DbStats dbStats = DbAdmin.dbStats.get();
        DbAdmin.dbStats.remove();
        return dbStats == null ? new DbStats(0) : dbStats;
    }

    public static boolean isProfiling() {
        return dbStats.get() != null;
    }

    public static void startLogging(Writer writer) {
        dbLog.set(writer);
    }

    public static void stopLogging() {
        dbLog.remove();
    }

    public static boolean isLogging() {
        return dbLog.get() != null;
    }

    public static boolean threadConnectionExists() {
        return threadConnection.get() != null;
    }

    private static synchronized Statement getStatement(int n) throws SQLRuntimeException {
        try {
            Connection connection = DbAdmin.getThreadConnection();
            if (isLegacyDriver) {
                return connection.createStatement();
            }
            return connection.createStatement(DbFlags.getScrollability(n), DbFlags.getUpdatability(n), DbFlags.getHoldability(n));
        }
        catch (SQLException sQLException) {
            throw new SQLRuntimeException(sQLException);
        }
    }

    public static synchronized DbPreparedStatement getPreparedStatement(CharSequence charSequence) throws SQLRuntimeException {
        return DbAdmin.getPreparedStatement(0, charSequence);
    }

    public static synchronized DbPreparedStatement getPreparedStatement(int n, CharSequence charSequence) throws SQLRuntimeException {
        String string = ((Object)charSequence).toString();
        if (DbFlags.isReusable(n)) {
            Map<String, DbPreparedStatement> map = DbAdmin.getPsReusableCache();
            if (!map.containsKey(string)) {
                map.put(string, new DbPreparedStatement(n, DbAdmin.getThreadConnection(), string));
            }
            return map.get(string);
        }
        DbPreparedStatement dbPreparedStatement = new DbPreparedStatement(n, DbAdmin.getThreadConnection(), charSequence);
        DbAdmin.getPsNonReusableCache().add(dbPreparedStatement);
        return dbPreparedStatement;
    }

    public static DbPreparedStatement getLoadStatement(int n, String string, String ... stringArray) throws IOException {
        if (stringArray.length == 0) {
            stringArray = dbMetaData.getTable(string).getColumnNames();
        }
        if (loadsAllowed) {
            return new DbLoadStatement(n, string, stringArray);
        }
        Object[] objectArray = new String[stringArray.length];
        Arrays.fill(objectArray, "?");
        StringBuilder stringBuilder = new StringBuilder("insert into $(SCHEMA)." + string + " (" + StringUtils.join((Object[])stringArray, (String)",") + ") values (" + StringUtils.join((Object[])objectArray, (String)",") + ")");
        return DbAdmin.getPreparedStatement(n, stringBuilder.toString());
    }

    public static synchronized void closeThreadConnection() {
        DbAdmin.close(threadConnection.get());
    }

    public static synchronized void setThreadUser(String string, String string2) {
        threadUser.set(string);
        threadPw.set(string2);
    }

    public static synchronized String getThreadUser() {
        return StringUtils.getString((String)threadUser.get(), (String)"");
    }

    public static synchronized String getThreadPw() {
        return StringUtils.getString((String)threadPw.get(), (String)"");
    }

    public static synchronized Connection getThreadConnection() throws SQLRuntimeException {
        return DbAdmin.getThreadConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Connection getThreadConnection(boolean bl) throws SQLRuntimeException {
        Connection connection = threadConnection.get();
        try {
            Object object;
            Object object2;
            block16: {
                block14: {
                    if (connection != null && connection.isClosed()) {
                        logger.log(Level.SEVERE, "ERROR in getConnectionForThread():  Connection object was inexplicably closed.  It will be re-created.");
                        DbAdmin.closeThreadConnection();
                        connection = null;
                    }
                    if (connection == null || !bl) break block16;
                    object2 = null;
                    object = null;
                    try {
                        object2 = connection.createStatement();
                        object = object2.executeQuery("SELECT 1 FROM SYSIBM.SYSDUMMY1");
                        if (object.next()) break block14;
                        logger.log(Level.SEVERE, "ERROR in getConnectionForThread():  Query 'SELECT 1 FROM SYSIBM.SYSDUMMY1' returned no rows.  Connection will be recreated.");
                        connection = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            logger.log(Level.SEVERE, "ERROR in getConnectionForThread():  Query 'SELECT 1 FROM SYSIBM.SYSDUMMY1' caused exception.  Connection will be recreated.", throwable);
                            DbAdmin.close(object2, object);
                            object2 = null;
                            object = null;
                            DbAdmin.closeThreadConnection();
                            connection = null;
                        }
                        catch (Throwable throwable2) {
                            DbAdmin.close(object2, object);
                            throw throwable2;
                        }
                        DbAdmin.close(object2, object);
                    }
                }
                DbAdmin.close(object2, object);
                if (connection != null) {
                    block15: {
                        try {
                            String string = DbAdmin.getThreadUser();
                            String string2 = StringUtils.getString((String)connection.getMetaData().getUserName(), (String)"");
                            if (string.equals("")) break block15;
                            string = string.indexOf(92) == -1 ? string : string.substring(string.indexOf(92) + 1);
                            String string3 = string2 = string2.indexOf(92) == -1 ? string2 : string2.substring(string2.indexOf(92) + 1);
                            if (string.equalsIgnoreCase(string2)) break block15;
                            Exception exception = new Exception("Authenticating userid=[" + string + "] to DB, but the thread already has a valid Connection for user=[" + string2 + "].  Previous connection will be closed.");
                            exception.fillInStackTrace();
                            logger.log(Level.WARNING, exception.getLocalizedMessage(), exception);
                            DbAdmin.closeThreadConnection();
                            connection = null;
                        }
                        catch (Throwable throwable) {
                            DbAdmin.close(object2, object);
                            throw throwable;
                        }
                    }
                    DbAdmin.close(object2, object);
                }
            }
            if (connection == null) {
                object2 = threadUser.get();
                object = threadPw.get();
                if (debug) {
                    logger.log(Level.FINER, "Opening connection for thread [" + Thread.currentThread() + "] using access method [" + accessMethod + "], user=[" + (String)object2 + "].");
                }
                connection = DbAdmin.getConnection(autoCommitEnabled, (String)object2, (String)object);
                if (debug) {
                    logger.log(Level.FINER, "Auto-commit set to " + autoCommitEnabled + ".");
                }
                if (debug) {
                    logger.log(Level.FINER, "connection=[" + connection + "]");
                }
                threadConnection.set(connection);
                psReusableCache.remove();
                psNonReusableCache.remove();
                rsCache.remove();
                dbStats.remove();
                dbLog.remove();
            }
        }
        catch (SQLException sQLException) {
            throw new SQLRuntimeException(sQLException);
        }
        return connection;
    }

    public static synchronized boolean authenticateUser(String string, String string2) throws SQLRuntimeException {
        DbAdmin.setThreadUser(string, string2);
        try {
            DbAdmin.getThreadConnection(true);
        }
        catch (SQLRuntimeException sQLRuntimeException) {
            int n = sQLRuntimeException.getNextException().getErrorCode();
            if (n == -922 || n == -1403 || n == -30082) {
                return false;
            }
            if (n == -4461) {
                return false;
            }
            if (n == -4214) {
                return false;
            }
            throw sQLRuntimeException;
        }
        return true;
    }

    public static boolean close(Object ... objectArray) {
        boolean bl = true;
        for (Object object : objectArray) {
            try {
                Object object2;
                Object object3;
                if (object instanceof Collection) {
                    object3 = (Collection)object;
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        DbAdmin.close(e);
                    }
                    continue;
                }
                if (object instanceof DbPreparedStatement) {
                    object3 = (DbPreparedStatement)object;
                    DbAdmin.getPsReusableCache().remove(((DbPreparedStatement)object3).sql);
                    DbAdmin.getPsNonReusableCache().remove(object3);
                    ((DbPreparedStatement)object3).close();
                    continue;
                }
                if (object instanceof DbResultSet) {
                    object3 = (DbResultSet)object;
                    if (DbAdmin.getRsCache().contains(object3)) {
                        DbAdmin.getRsCache().remove(object3);
                        ((DbResultSet)object3).close();
                        DbAdmin.addQueryStats((DbResultSet)object3);
                        continue;
                    }
                    ((DbResultSet)object3).close();
                    continue;
                }
                if (object instanceof Connection) {
                    object3 = (Connection)object;
                    if (threadConnection.get() == object3) {
                        if (object3.getAutoCommit() && !autoCommitEnabled) {
                            object2 = new Exception("Autocommit-enabled detected while trying to close connection.  Autocommit should always be disabled when closing the thread connection.");
                            ((Throwable)object2).fillInStackTrace();
                            logger.log(Level.WARNING, ((Throwable)object2).getLocalizedMessage(), (Throwable)object2);
                        }
                        for (DbPreparedStatement dbPreparedStatement : DbAdmin.getPsReusableCache().values()) {
                            dbPreparedStatement.close();
                        }
                        int n = DbAdmin.getRsCache().size();
                        if (n > 0) {
                            logger.warning("[" + n + "] result sets were not closed during the call to DbAdmin.close(Connection).");
                            int n2 = 1;
                            for (DbResultSet dbResultSet : DbAdmin.getRsCache()) {
                                logger.warning("\t[SQL-" + n2++ + "] - " + dbResultSet.sql);
                                dbResultSet.close();
                            }
                        }
                        if ((n = DbAdmin.getPsNonReusableCache().size()) > 0) {
                            logger.warning("[" + n + "] non-reusable prepared statements were not closed during the call to DbAdmin.close(Connection).");
                            int n3 = 1;
                            for (DbPreparedStatement dbPreparedStatement : DbAdmin.getPsNonReusableCache()) {
                                logger.warning("\t[SQL-" + n3++ + "] - " + dbPreparedStatement.sql);
                                dbPreparedStatement.close();
                            }
                        }
                        threadConnection.remove();
                        psReusableCache.remove();
                        psNonReusableCache.remove();
                        rsCache.remove();
                        dbStats.remove();
                        dbLog.remove();
                    }
                    if (object3.isClosed()) continue;
                    object3.commit();
                    object3.close();
                    continue;
                }
                if (object instanceof Statement) {
                    ((Statement)object).close();
                    continue;
                }
                if (object instanceof ResultSet) {
                    ((ResultSet)object).close();
                    continue;
                }
                if (object == null) continue;
                logger.log(Level.WARNING, "Invalid object of type [" + object.getClass().getName() + "] passed to DbAdmin.close()");
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getLocalizedMessage(), exception);
                bl = false;
            }
        }
        return bl;
    }

    public static DbResultSet query(CharSequence charSequence, Object ... objectArray) throws SQLRuntimeException {
        return DbAdmin.query(0, charSequence, objectArray);
    }

    public static DbResultSet query(int n, CharSequence charSequence, Object ... objectArray) throws SQLRuntimeException {
        long l = System.currentTimeMillis();
        if (DbFlags.isReusable(n) || objectArray.length > 0) {
            return DbAdmin.getPreparedStatement(n, charSequence).setParams(objectArray).query(new Object[0]);
        }
        Statement statement = null;
        String string = DbAdmin.replaceVars(charSequence);
        if (debug) {
            logger.log(Level.FINER, "Running query:  " + charSequence);
        }
        try {
            statement = DbAdmin.getStatement(n);
            DbResultSet dbResultSet = new DbResultSet(n, ((Object)charSequence).toString(), statement, statement.executeQuery(string), l);
            DbAdmin.getRsCache().add(dbResultSet);
            return dbResultSet;
        }
        catch (SQLException sQLException) {
            DbAdmin.close(statement);
            throw new SQLRuntimeException("Exception on SQL [" + charSequence + "]", sQLException);
        }
    }

    public static int update(CharSequence charSequence, Object ... objectArray) throws SQLRuntimeException {
        return DbAdmin.update(0, charSequence, objectArray);
    }

    public static int update(int n, CharSequence charSequence, Object ... objectArray) throws SQLRuntimeException {
        int n2;
        long l = System.currentTimeMillis();
        if (DbFlags.isReusable(n)) {
            return DbAdmin.getPreparedStatement(n, charSequence).setParams(objectArray).update(new Object[0]);
        }
        if (objectArray.length > 0) {
            DbPreparedStatement dbPreparedStatement = new DbPreparedStatement(n, DbAdmin.getThreadConnection(), charSequence);
            int n3 = dbPreparedStatement.setParams(objectArray).update(new Object[0]);
            dbPreparedStatement.close();
            return n3;
        }
        String string = DbAdmin.replaceVars(charSequence);
        Matcher matcher = copySqlPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            int n4 = Integer.parseInt(matcher.group(3));
            return DbAdmin.insertFromSelect(n, string2, string3, n4, n4);
        }
        Statement statement = null;
        if (debug) {
            logger.log(Level.FINER, "Running update:  " + charSequence);
        }
        try {
            statement = DbAdmin.getStatement(n);
            int n5 = statement.executeUpdate(string);
            DbAdmin.addUpdateStats(charSequence, l, n5, new Object[0]);
            if (n5 > 0 && DbFlags.isAutoCommit(n)) {
                DbAdmin.commit();
            }
            n2 = n5;
        }
        catch (SQLException sQLException) {
            block11: {
                int n6;
                try {
                    if (!DbFlags.isIgnoreDuplicate(n) || sQLException.getErrorCode() != -803) break block11;
                    n6 = 0;
                }
                catch (Throwable throwable) {
                    DbAdmin.close(statement);
                    throw throwable;
                }
                DbAdmin.close(statement);
                return n6;
            }
            if (DbFlags.isAutoRollback(n)) {
                DbAdmin.rollback();
            }
            throw new SQLRuntimeException("Exception on SQL [" + charSequence + "]", sQLException);
        }
        DbAdmin.close(statement);
        return n2;
    }

    public static String getSchemaName() {
        return schemaName;
    }

    public static DbInfo getInfo() {
        return dbInfo;
    }

    public static DbMetaData getMetaData() {
        return dbMetaData;
    }

    public static void commit() throws SQLRuntimeException {
        try {
            for (DbPreparedStatement dbPreparedStatement : DbAdmin.getPsReusableCache().values()) {
                if (dbPreparedStatement.executeSize <= 0 || DbFlags.isBatchFloat(dbPreparedStatement.flags)) continue;
                DbAdmin.rollback();
                throw new SQLRuntimeException("[" + dbPreparedStatement.executeSize + "] batched rows unexecuted on prepared statement [" + dbPreparedStatement.getSQL() + "] at end of transaction!");
            }
            for (DbPreparedStatement dbPreparedStatement : DbAdmin.getPsReusableCache().values()) {
                if (dbPreparedStatement.executeSize <= 0 || DbFlags.isBatchFloat(dbPreparedStatement.flags)) continue;
                DbAdmin.rollback();
                throw new SQLRuntimeException("[" + dbPreparedStatement.executeSize + "] batched rows unexecuted on prepared statement [" + dbPreparedStatement.getSQL() + "] at end of transaction!");
            }
            long l = System.currentTimeMillis();
            Connection connection = threadConnection.get();
            if (connection == null || connection.isClosed()) {
                return;
            }
            connection.commit();
            DbAdmin.resetCacheForThread();
            if (DbAdmin.isProfiling()) {
                dbStats.get().addCommit(System.currentTimeMillis() - l);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLRuntimeException(sQLException);
        }
    }

    public static void rollback() throws SQLRuntimeException {
        try {
            Connection connection = threadConnection.get();
            if (connection == null || connection.isClosed()) {
                return;
            }
            connection.rollback();
            DbAdmin.resetCacheForThread();
        }
        catch (SQLException sQLException) {
            throw new SQLRuntimeException(sQLException);
        }
    }

    private static void resetCacheForThread() {
        for (String object : DbAdmin.getLockedTables().keySet()) {
            if (!pkCache.containsKey(object)) continue;
            pkCache.get(object).reset();
        }
        DbAdmin.getLockedTables().clear();
        if (DbAdmin.getInfo().isDb2Zos()) {
            Iterator<Object> iterator = DbAdmin.getPsReusableCache().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                DbPreparedStatement dbPreparedStatement = (DbPreparedStatement)entry.getValue();
                if (dbPreparedStatement.getResultSetHoldability() != 2) continue;
                dbPreparedStatement.close();
                iterator.remove();
            }
        }
    }

    public static String replaceVars(CharSequence charSequence) {
        String string = ((Object)charSequence).toString().replaceAll("(\\$\\{ts\\})|(\\$\\{tschema\\})|(\\$\\(SCHEMA\\))", schemaName).replaceAll("\\?\\:[\\w\\d\\_]+(\\(\\d+\\))?", "?");
        if (string.indexOf(36) != -1) {
            return DbAdmin.replaceInnerSql(string);
        }
        return string;
    }

    public static String replaceInnerSql(String string) {
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        int n4 = n;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n4 == n && c == '$') {
                n4 = n2;
                continue;
            }
            if (n4 == n2 && c == '(') {
                n4 = n3;
                n5 = i - 1;
                continue;
            }
            if (n4 != n3) continue;
            if (c == '(') {
                ++n6;
                continue;
            }
            if (c != ')') continue;
            if (n6 > 0) {
                --n6;
                continue;
            }
            String string2 = string.substring(n5 + 2, i);
            if (!string2.toLowerCase().startsWith("select")) continue;
            string = string.substring(0, n5) + DbAdmin.query(string2, new Object[0]).toSingleString() + string.substring(i + 1);
            return DbAdmin.replaceInnerSql(string);
        }
        return string;
    }

    public static synchronized void runstats(Set<String> set) {
        if (set.size() > 0) {
            DbAdmin.runstats(set.toArray(new String[set.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void runstats(String ... processExec) {
        if (dbInfo.isDb2Zos()) {
            logger.log(Level.INFO, "Runstats command ignored.  Incompatible platform.");
            return;
        }
        if (!ConfigMgr.getBoolean((String)"Common.Database.enableDynamicRunstats")) {
            logger.log(Level.INFO, "Runstats command ignored.  'enableDynamicRunstats' set to false.");
            return;
        }
        File file = new File(ConfigMgr.get((String)"Common.tempDir") + "/runstats.ddl");
        try {
            logger.log(Level.INFO, "Performing RUNSTATS on tables [" + StringUtils.join((Object[])processExec, (String)",") + "]");
            long l = System.currentTimeMillis();
            FileWriter fileWriter = new FileWriter(file);
            String string = DbAdmin.getThreadUser();
            String string2 = DbAdmin.getThreadPw();
            fileWriter.write("CONNECT TO " + ConfigMgr.get((String)"Common.Database.name") + (string.equals("") ? "" : " user " + string) + (string2.equals("") ? "" : " using " + string2) + ";\n");
            for (String string3 : processExec) {
                fileWriter.write("RUNSTATS ON TABLE " + schemaName + "." + string3 + " AND INDEXES ALL ALLOW READ ACCESS;\n");
            }
            fileWriter.write("CONNECT RESET;\n");
            fileWriter.close();
            ProcessExec processExec2 = new ProcessExec(new String[]{"db2cmd", "/i", "/c", "/w", "db2", "-vtf", "runstats.ddl"});
            processExec2.setLocation(ConfigMgr.get((String)"Common.tempDir"));
            processExec2.setLogging(debug);
            processExec2.appendEnvVar("PATH", new File(ConfigMgr.get((String)"Common.PrereqPaths.db2Home") + "/bin").getPath(), ";");
            int n = processExec2.run();
            if (n != 0) {
                processExec2.setLogging(true);
                processExec2.run();
                logger.log(Level.WARNING, "Command output \n------START------\n," + processExec2.getLog().toString() + "\n------END------\n");
            }
            logger.log(Level.INFO, "RUNSTATS command finished with return code [" + n + "] in [" + (System.currentTimeMillis() - l) + "ms]");
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Exception caught while performing RUNSTATS", iOException);
        }
        finally {
            file.delete();
        }
    }

    public static synchronized void disableLogging(String ... stringArray) {
        if (dbInfo.isDb2Zos() || dbInfo.getVersionMajor() < 8) {
            logger.log(Level.INFO, "Disable logging command ignored.  Incompatible platform.");
            return;
        }
        for (String string : stringArray) {
            try {
                DbAdmin.update("alter table " + schemaName + "." + string + " activate not logged initially", new Object[0]);
            }
            catch (SQLRuntimeException sQLRuntimeException) {
                logger.log(Level.WARNING, "Exception caught while disabling logging on table [" + string + "]", sQLRuntimeException);
            }
        }
    }

    public static synchronized void lockTable(int n, String ... stringArray) throws SQLRuntimeException {
        Map<String, Integer> map = DbAdmin.getLockedTables();
        for (String string : stringArray) {
            boolean bl;
            boolean bl2 = bl = !map.containsKey(string = string.toUpperCase()) || n == 2 && map.get(string) == 1;
            if (!bl) continue;
            String string2 = n == 2 ? "exclusive" : "share";
            logger.fine("Locking table [" + string + "] in [" + string2 + "] mode.");
            DbAdmin.update("lock table $(SCHEMA)." + string + " in " + string2 + " mode", new Object[0]);
            map.put(string, n);
        }
    }

    public static synchronized void lockTable(String ... stringArray) throws SQLRuntimeException {
        DbAdmin.lockTable(1, stringArray);
    }

    public static void clearTable(String ... stringArray) throws SQLRuntimeException {
        for (String string : stringArray) {
            if (dbInfo.isDb2Zos()) {
                if (dbInfo.getVersionMajor() >= 9) {
                    DbAdmin.update(DbFlags.AC, "truncate table $(SCHEMA)." + string + " reuse storage ignore delete triggers immediate", new Object[0]);
                    continue;
                }
                DbAdmin.update(DbFlags.AC, "delete from $(SCHEMA)." + string + "", new Object[0]);
                continue;
            }
            if (dbInfo.getVersionMajor() >= 8) {
                DbAdmin.update(DbFlags.AC, "alter table $(SCHEMA)." + string + " activate not logged initially with empty table", new Object[0]);
                continue;
            }
            DbAdmin.update(DbFlags.AC, "delete from $(SCHEMA)." + string + "", new Object[0]);
        }
    }

    public static int insertFromSelect(int n, String string, String string2) throws SQLRuntimeException {
        return DbAdmin.insertFromSelect(n, string, string2, maxBatchExecuteSize, maxBatchCommitSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertFromSelect(int n, String string, String string2, int n2, int n3) throws SQLRuntimeException {
        int n4;
        DbPreparedStatement dbPreparedStatement = null;
        Object var6_6 = null;
        try {
            dbPreparedStatement = DbAdmin.getPreparedStatement(n, string2).setMaxBatchSizes(n2, n3);
            int n5 = dbPreparedStatement.loadFromSelect(string);
            dbPreparedStatement.executeBatch();
            n4 = n5;
        }
        catch (Throwable throwable) {
            DbAdmin.close(dbPreparedStatement, var6_6);
            throw throwable;
        }
        DbAdmin.close(dbPreparedStatement, var6_6);
        return n4;
    }

    public static int deleteFromSelect(int n, String string, String string2) throws SQLRuntimeException {
        return DbAdmin.deleteFromSelect(n, string, string2, maxBatchExecuteSize, maxBatchCommitSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deleteFromSelect(int n, String string, String string2, int n2, int n3) throws SQLRuntimeException {
        int n4;
        if (!deleteFromSelectAllowed) {
            return DbAdmin.insertFromSelect(n, string, string2, n2, n3);
        }
        boolean bl = DbFlags.isVerbose(n);
        DbPreparedStatement dbPreparedStatement = null;
        try {
            Matcher matcher = Pattern.compile("select .* from (.*)").matcher(string);
            if (!matcher.matches()) {
                throw new RuntimeException("Pattern [select .* from (.*)] didn't match sql [" + string + "]");
            }
            String string3 = "delete from (select * from " + matcher.group(1) + " fetch first " + n3 + " rows only)";
            if (bl) {
                logger.info("deleteFromSelect:  sql=[" + string3 + "]");
            }
            dbPreparedStatement = DbAdmin.getPreparedStatement(n, string3);
            int n5 = 0;
            int n6 = 0;
            long l = System.currentTimeMillis();
            do {
                long l2 = System.currentTimeMillis();
                n5 = dbPreparedStatement.update(new Object[0]);
                n6 += n5;
                if (!bl) continue;
                logger.info("Deleted [" + n5 + "] rows in [" + (System.currentTimeMillis() - l2) + "ms].  Total=[" + n6 + "]");
            } while (n5 > 0);
            if (bl) {
                logger.info("[" + n6 + "] total rows deleted and committed (" + (System.currentTimeMillis() - l) + "ms).");
            }
            n4 = n6;
        }
        catch (Throwable throwable) {
            DbAdmin.close(dbPreparedStatement);
            throw throwable;
        }
        DbAdmin.close(dbPreparedStatement);
        return n4;
    }

    public static PrimaryKeyGenerator getPkGenerator(String string, String string2) throws SQLRuntimeException {
        if (!pkCache.containsKey(string = string.toUpperCase())) {
            pkCache.put(string, new PrimaryKeyGenerator(string, string2));
        }
        return pkCache.get(string);
    }

    private static Map<String, DbPreparedStatement> getPsReusableCache() {
        if (psReusableCache.get() == null) {
            psReusableCache.set(new LinkedHashMap());
        }
        return psReusableCache.get();
    }

    private static Set<DbPreparedStatement> getPsNonReusableCache() {
        if (psNonReusableCache.get() == null) {
            psNonReusableCache.set(new HashSet());
        }
        return psNonReusableCache.get();
    }

    protected static Set<DbResultSet> getRsCache() {
        if (rsCache.get() == null) {
            rsCache.set(new HashSet());
        }
        return rsCache.get();
    }

    private static Map<String, Integer> getLockedTables() {
        if (lockedTables.get() == null) {
            lockedTables.set(new HashMap());
        }
        return lockedTables.get();
    }

    protected static void addQueryStats(DbResultSet dbResultSet) {
        if (DbAdmin.isProfiling()) {
            dbStats.get().addSqlStats(dbResultSet.sql, dbResultSet.startTime, dbResultSet.numRowsScrolled, dbResultSet.args);
        }
        if (DbAdmin.isLogging()) {
            try {
                dbLog.get().write("<div class='sqltrace'>" + dbResultSet.sql + " (time=" + StringUtils.getTimeStringShort((long)(System.currentTimeMillis() - dbResultSet.startTime)) + ", rows=[" + dbResultSet.numRowsScrolled + "]" + (dbResultSet.args == null ? "" : ", parms=[" + StringUtils.join((Object[])dbResultSet.args, (String)",") + "]") + ")</div>");
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    protected static void addUpdateStats(CharSequence charSequence, long l, int n, Object ... objectArray) {
        if (DbAdmin.isProfiling()) {
            dbStats.get().addSqlStats(((Object)charSequence).toString(), l, n, objectArray);
        }
        if (DbAdmin.isLogging()) {
            try {
                dbLog.get().write("<div class='sqltrace'>" + charSequence + " (time=" + StringUtils.getTimeStringShort((long)(System.currentTimeMillis() - l)) + ", rows=[" + n + "]" + (objectArray == null ? "" : ", parms=[" + StringUtils.join((Object[])objectArray, (String)",") + "]") + ")</div>");
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    protected static void addBatchStats(CharSequence charSequence, long l, int n) {
        if (DbAdmin.isProfiling()) {
            dbStats.get().addBatchStats(((Object)charSequence).toString(), l, n);
        }
    }

    public static void declareGlobalTempTable(String string, boolean bl, String ... stringArray) {
        boolean bl2 = true;
        if (DbAdmin.getInfo().isDb2Zos()) {
            try {
                DbAdmin.query("select * from SESSION." + string + " optimize for 1 row", new Object[0]);
                DbAdmin.update("delete from SESSION." + string, false, false);
                bl2 = false;
            }
            catch (SQLRuntimeException sQLRuntimeException) {
                // empty catch block
            }
        }
        if (bl2) {
            DbAdmin.update("declare global temporary table " + string + "(" + StringUtils.join((Object[])stringArray, (String)", ") + ")" + (DbAdmin.getInfo().isDb2Zos() ? "" : " not logged with replace") + " on commit " + (bl ? "preserve" : "delete") + " rows", new Object[0]);
        } else if (bl) {
            DbAdmin.update(DbFlags.AC, "delete from SESSION." + string, new Object[0]);
        }
    }

    static {
        logger = LoggerManager.getMainLogger();
        debug = logger.isLoggable(Level.FINE);
        accessMethod = 0;
        threadUser = new ThreadLocal();
        threadPw = new ThreadLocal();
        threadConnection = new ThreadLocal();
        dbStats = new ThreadLocal();
        dbLog = new ThreadLocal();
        psReusableCache = new ThreadLocal();
        psNonReusableCache = new ThreadLocal();
        rsCache = new ThreadLocal();
        pkCache = new HashMap<String, PrimaryKeyGenerator>();
        lockedTables = new ThreadLocal();
        copySqlPattern = Pattern.compile("(?i)\\s*COPY FROM\\s+(\\S.*\\S)\\s+COPY TO\\s+(\\S.*\\S)\\s+BATCH SIZE\\s+(\\d+)\\s*");
    }
}

