/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

public class DbFlags {
    private static final String copyright = "Licensed Material - Property of IBM\n5724-V27\nCopyright IBM Corp. 2011\nThe source code for this program is not published or otherwise\ndivested of its trade secrets, irrespective of what has been\ndeposited with the U.S. Copyright Office.";
    public static int REUSABLE = 1;
    public static int HOLDABLE = 2;
    public static int UPDATABLE = 4;
    public static int SCROLLABLE = 8;
    public static int SCROLL_SENSITIVE = 16;
    public static int AC = 32;
    public static int ACR = 64;
    public static int TRIM = 128;
    public static int LOCK = 256;
    public static int ABEC = 512;
    public static int VERBOSE = 1024;
    public static int BATCHFLOAT = 2048;
    public static int IGNORE_DUPLICATE = 4096;

    protected static int getHoldability(int n) {
        return (n & HOLDABLE) > 0 ? 1 : 2;
    }

    protected static int getScrollability(int n) {
        return (n & SCROLLABLE) > 0 ? ((n & SCROLL_SENSITIVE) > 0 ? 1005 : 1004) : 1003;
    }

    protected static int getUpdatability(int n) {
        return (n & UPDATABLE) > 0 ? 1008 : 1007;
    }

    protected static boolean isAutoBatchExecuteAndCommit(int n) {
        return (n & ABEC) > 0;
    }

    protected static boolean isAutoCommit(int n) {
        return (n & AC) > 0 || (n & ACR) > 0;
    }

    protected static boolean isAutoRollback(int n) {
        return (n & ACR) > 0;
    }

    protected static boolean isBatchFloat(int n) {
        return (n & BATCHFLOAT) > 0;
    }

    protected static boolean isIgnoreDuplicate(int n) {
        return (n & IGNORE_DUPLICATE) > 0;
    }

    protected static boolean isLocking(int n) {
        return (n & LOCK) > 0;
    }

    protected static boolean isReusable(int n) {
        return (n & REUSABLE) > 0;
    }

    protected static boolean isTrimming(int n) {
        return (n & TRIM) > 0;
    }

    protected static boolean isVerbose(int n) {
        return (n & VERBOSE) > 0;
    }
}

