/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbFlags;
import com.ibm.dmh.db.DbPreparedStatement;
import com.ibm.dmh.db.SQLRuntimeException;
import com.ibm.dmh.util.StringUtils;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbResultSet {
    protected String sql;
    protected ResultSet rs;
    protected Statement st;
    protected DbPreparedStatement ps;
    protected long startTime;
    protected int numRowsScrolled;
    protected int flags;
    private int rowCount = -1;
    private String rowCountQuery = null;
    protected Object[] args;
    private Boolean nextFlag = null;

    protected DbResultSet(int n, String string, Statement statement, ResultSet resultSet, long l) {
        this.flags = n;
        this.sql = string;
        this.rs = resultSet;
        this.st = statement;
        this.startTime = l;
    }

    protected DbResultSet(DbPreparedStatement dbPreparedStatement, ResultSet resultSet, long l, Object ... objectArray) {
        this.flags = dbPreparedStatement.flags;
        this.ps = dbPreparedStatement;
        this.sql = dbPreparedStatement.sql;
        this.rs = resultSet;
        this.startTime = l;
        this.args = objectArray;
    }

    public List<Object[]> toRows(String ... stringArray) throws SQLRuntimeException {
        return this.toRows(1, Integer.MAX_VALUE, stringArray);
    }

    public List<Object[]> toRows(int n, int n2, String ... stringArray) {
        int n3;
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        boolean bl = stringArray.length == 0;
        int n4 = n3 = bl ? this.getColumnCount() : stringArray.length;
        while (--n > 0) {
            this.next();
        }
        while (n2-- > 0) {
            if (this.next()) {
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    objectArray[i] = bl ? this.getObject(i + 1) : this.getObject(stringArray[i]);
                }
                linkedList.add(objectArray);
                continue;
            }
            n2 = 0;
        }
        DbAdmin.close(this);
        return linkedList;
    }

    public Object[] toSingleRow(String ... stringArray) throws SQLRuntimeException {
        int n;
        int n2 = 0;
        Object[] objectArray = null;
        boolean bl = stringArray.length == 0;
        int n3 = n = bl ? this.getColumnCount() : stringArray.length;
        while (this.next()) {
            ++n2;
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = bl ? this.getObject(i + 1) : this.getObject(stringArray[i]);
            }
        }
        DbAdmin.close(this);
        if (n2 > 1) {
            throw new SQLRuntimeException("Query [" + this.getDebugSql() + "] was supposed to return 1 row, but returned [" + n2 + "] rows");
        }
        return objectArray;
    }

    public Object[] toSingleColumn() throws SQLRuntimeException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (this.next()) {
            linkedList.add(this.getObject(1));
        }
        DbAdmin.close(this);
        return linkedList.toArray(new Object[linkedList.size()]);
    }

    public int toSingleInt() throws SQLRuntimeException {
        return this.toSingleInt(-1);
    }

    public int toSingleInt(int n) throws SQLRuntimeException {
        int n2 = 0;
        int n3 = n;
        while (this.next()) {
            n3 = this.getInt(1);
            ++n2;
        }
        DbAdmin.close(this);
        if (n2 > 1) {
            throw new SQLRuntimeException("Query [" + this.getDebugSql() + "] was supposed to return 1 row, but returned [" + n2 + "] rows");
        }
        return n3;
    }

    public Timestamp toSingleTimestamp() throws SQLRuntimeException {
        int n = 0;
        Timestamp timestamp = null;
        while (this.next()) {
            timestamp = this.getTimestamp(1);
            ++n;
        }
        DbAdmin.close(this);
        if (n > 1) {
            throw new SQLRuntimeException("Query [" + this.getDebugSql() + "] was supposed to return 1 row, but returned [" + n + "] rows");
        }
        return timestamp;
    }

    public String toSingleString() throws SQLRuntimeException {
        return this.toSingleString(null);
    }

    public String toSingleString(String string) throws SQLRuntimeException {
        int n = 0;
        String string2 = string;
        while (this.next()) {
            string2 = this.getString(1);
            ++n;
        }
        DbAdmin.close(this);
        if (n > 1) {
            throw new SQLRuntimeException("Query [" + this.getDebugSql() + "] was supposed to return 1 row, but returned [" + n + "] rows");
        }
        return string2;
    }

    public int[] toInts() throws SQLRuntimeException {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (this.next()) {
            linkedList.add(this.getInt(1));
        }
        DbAdmin.close(this);
        int[] nArray = new int[linkedList.size()];
        int n = 0;
        for (Integer n2 : linkedList) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public String[] toStrings() throws SQLRuntimeException {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (this.next()) {
            linkedList.add(this.getString(1));
        }
        DbAdmin.close(this);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public List<Map<String, Object>> toMapList(String ... stringArray) throws SQLRuntimeException {
        return this.toMapList(1, Integer.MAX_VALUE, new String[0]);
    }

    public List<Map<String, Object>> toMapList(int n, int n2, String ... stringArray) throws SQLRuntimeException {
        try {
            int n3;
            LinkedList<Map<String, Object>> linkedList = new LinkedList<Map<String, Object>>();
            ResultSetMetaData resultSetMetaData = this.getMetaData();
            boolean bl = stringArray.length == 0;
            int n4 = n3 = bl ? this.getColumnCount() : stringArray.length;
            while (--n > 0) {
                this.next();
            }
            while (n2-- > 0) {
                if (this.next()) {
                    int n5;
                    LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(n3);
                    if (bl) {
                        for (n5 = 1; n5 < n3 + 1; ++n5) {
                            linkedHashMap.put(resultSetMetaData.getColumnLabel(n5), this.getObject(n5));
                        }
                    } else {
                        for (n5 = 0; n5 < n3; ++n5) {
                            linkedHashMap.put(stringArray[n5], this.getObject(stringArray[n5]));
                        }
                    }
                    linkedList.add(linkedHashMap);
                    continue;
                }
                n2 = 0;
            }
            DbAdmin.close(this);
            return linkedList;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public String toDebugString() throws SQLRuntimeException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Object[] objectArray : this.toRows(new String[0])) {
            String string = StringUtils.join((Object[])this.debugTrim(objectArray), (char)',', (boolean)true);
            string = StringUtils.escapeChars((String)string, (char[])new char[]{'[', ']'});
            linkedList.add(string);
        }
        return linkedList.size() == 0 ? "" : "[" + StringUtils.join(linkedList, (String)"][") + "]";
    }

    public String toDebugSingleRow() throws SQLRuntimeException {
        return StringUtils.join((Object[])this.debugTrim(this.toSingleRow(new String[0])), (char)',', (boolean)true);
    }

    public String toDebugSingleColumn() throws SQLRuntimeException {
        return StringUtils.join((Object[])this.debugTrim(this.toSingleColumn()), (char)',', (boolean)true);
    }

    private Object[] debugTrim(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            objectArray[i] = objectArray[i].toString().trim();
        }
        return objectArray;
    }

    private String trim(String string) {
        return DbFlags.isTrimming(this.flags) && string != null ? string.toString().trim() : string;
    }

    public boolean isEmpty() {
        try {
            if (this.rs.isBeforeFirst()) {
                this.nextFlag = this.rs.next();
                return this.nextFlag == false;
            }
            return this.numRowsScrolled > 0;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    protected void close() throws SQLException {
        if (this.st != null) {
            this.st.close();
        }
        if (this.ps != null && !this.ps.isReusable()) {
            DbAdmin.close(this.ps);
        }
        this.rs.close();
    }

    public boolean next() throws SQLRuntimeException {
        try {
            if (this.nextFlag != null) {
                boolean bl = this.nextFlag;
                this.nextFlag = null;
                return bl;
            }
            boolean bl = this.rs.next();
            if (bl) {
                ++this.numRowsScrolled;
            }
            return bl;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public String getString(int n) throws SQLRuntimeException {
        try {
            return this.trim(this.rs.getString(n));
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public String getString(String string) throws SQLRuntimeException {
        try {
            return this.trim(this.rs.getString(string));
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Object getObject(int n) throws SQLRuntimeException {
        try {
            Object object = this.rs.getObject(n);
            return object instanceof String ? this.trim(object.toString()) : object;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Object getObject(String string) throws SQLRuntimeException {
        try {
            Object object = this.rs.getObject(string);
            return object instanceof String ? this.trim(object.toString()) : object;
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getColumnCount() throws SQLRuntimeException {
        try {
            return this.rs.getMetaData().getColumnCount();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean getBoolean(int n) throws SQLRuntimeException {
        try {
            return this.rs.getBoolean(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getInt(int n) throws SQLRuntimeException {
        try {
            return this.rs.getInt(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public short getShort(int n) throws SQLRuntimeException {
        try {
            return this.rs.getShort(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public long getLong(int n) throws SQLRuntimeException {
        try {
            return this.rs.getLong(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public float getFloat(int n) throws SQLRuntimeException {
        try {
            return this.rs.getFloat(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public double getDouble(int n) throws SQLRuntimeException {
        try {
            return this.rs.getDouble(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Date getDate(int n) throws SQLRuntimeException {
        try {
            return this.rs.getDate(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Time getTime(int n) throws SQLRuntimeException {
        try {
            return this.rs.getTime(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLRuntimeException {
        try {
            return this.rs.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLRuntimeException {
        try {
            return this.rs.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLRuntimeException {
        try {
            return this.rs.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLRuntimeException {
        try {
            return this.rs.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Clob getClob(int n) throws SQLRuntimeException {
        try {
            return this.rs.getClob(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Object getObject(int n, Map<String, Class<?>> map) throws SQLRuntimeException {
        try {
            return this.rs.getObject(n, map);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean getBoolean(String string) throws SQLRuntimeException {
        try {
            return this.rs.getBoolean(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getInt(String string) throws SQLRuntimeException {
        try {
            return this.rs.getInt(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public short getShort(String string) throws SQLRuntimeException {
        try {
            return this.rs.getShort(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public long getLong(String string) throws SQLRuntimeException {
        try {
            return this.rs.getLong(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public float getFloat(String string) throws SQLRuntimeException {
        try {
            return this.rs.getFloat(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public double getDouble(String string) throws SQLRuntimeException {
        try {
            return this.rs.getDouble(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Date getDate(String string) throws SQLRuntimeException {
        try {
            return this.rs.getDate(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Time getTime(String string) throws SQLRuntimeException {
        try {
            return this.rs.getTime(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLRuntimeException {
        try {
            return this.rs.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLRuntimeException {
        try {
            return this.rs.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLRuntimeException {
        try {
            return this.rs.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLRuntimeException {
        try {
            return this.rs.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Object getObject(String string, Map<String, Class<?>> map) throws SQLRuntimeException {
        try {
            return this.rs.getObject(string, map);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Clob getClob(String string) throws SQLRuntimeException {
        try {
            return this.rs.getClob(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public SQLWarning getWarnings() throws SQLRuntimeException {
        try {
            return this.rs.getWarnings();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLRuntimeException {
        try {
            return this.rs.getMetaData();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int findColumn(String string) throws SQLRuntimeException {
        try {
            return this.rs.findColumn(string);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean isBeforeFirst() throws SQLRuntimeException {
        try {
            return this.rs.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean isAfterLast() throws SQLRuntimeException {
        try {
            return this.rs.isAfterLast();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean isFirst() throws SQLRuntimeException {
        try {
            return this.rs.isFirst();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean isLast() throws SQLRuntimeException {
        try {
            return this.rs.isLast();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void beforeFirst() throws SQLRuntimeException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void afterLast() throws SQLRuntimeException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean first() throws SQLRuntimeException {
        try {
            return this.rs.first();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean last() throws SQLRuntimeException {
        try {
            return this.rs.last();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getRow() throws SQLRuntimeException {
        try {
            return this.rs.getRow();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean absolute(int n) throws SQLRuntimeException {
        try {
            return this.rs.absolute(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean relative(int n) throws SQLRuntimeException {
        try {
            return this.rs.relative(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public boolean previous() throws SQLRuntimeException {
        try {
            return this.rs.previous();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void setFetchDirection(int n) throws SQLRuntimeException {
        try {
            this.rs.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getFetchDirection() throws SQLRuntimeException {
        try {
            return this.rs.getFetchDirection();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public void setFetchSize(int n) throws SQLRuntimeException {
        try {
            this.rs.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getFetchSize() throws SQLRuntimeException {
        try {
            return this.rs.getFetchSize();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getType() throws SQLRuntimeException {
        try {
            return this.rs.getType();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public int getConcurrency() throws SQLRuntimeException {
        try {
            return this.rs.getConcurrency();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    public Statement getStatement() throws SQLRuntimeException {
        try {
            return this.rs.getStatement();
        }
        catch (SQLException sQLException) {
            throw this.wrap(sQLException);
        }
    }

    private SQLRuntimeException wrap(SQLException sQLException) {
        DbAdmin.close(this);
        throw new SQLRuntimeException("Exception on SQL [" + this.getDebugSql() + "]", sQLException);
    }

    private String getDebugSql() {
        if (this.ps == null) {
            return this.sql;
        }
        return this.ps.getDebugSql();
    }

    @Deprecated
    public ResultSet getInnerResultSet() {
        return this.rs;
    }

    @Deprecated
    public int getRowCount() {
        if (this.rowCount == -1) {
            if (this.rowCountQuery == null) {
                this.rowCountQuery = this.sql.replaceAll("(?i) ORDER BY.*", "").replaceAll("(?i) OPTIMIZE FOR.*", "").replaceAll("\\;\\s*$", "");
                this.rowCountQuery = "select count(*) from (" + this.rowCountQuery + ") as MYTAB";
            }
            this.rowCount = this.ps != null ? DbAdmin.getPreparedStatement(this.rowCountQuery).query(this.ps.currentParams).toSingleInt() : DbAdmin.query(this.rowCountQuery, new Object[0]).toSingleInt();
        }
        return this.rowCount;
    }

    public DbResultSet setRowCountQuery(String string) {
        this.rowCountQuery = string;
        return this;
    }

    public String getSql() {
        return this.sql;
    }
}

