/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.SQLRuntimeException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class PrimaryKeyGenerator {
    private int nextId;
    private int limitId;
    private String table;
    private String idColumn;
    Set<Integer> rangeStarts = new HashSet<Integer>();
    boolean hasScatteredIds = false;

    protected PrimaryKeyGenerator(String string, String string2) throws SQLRuntimeException {
        this.table = string;
        this.idColumn = string2;
    }

    private void findOpenRange() throws SQLRuntimeException {
        if (!this.hasScatteredIds) {
            this.nextId = DbAdmin.query("select value(max(" + this.idColumn + ")+1, 1) from $(SCHEMA)." + this.table, new Object[0]).toSingleInt();
            if (this.nextId < 1000000000) {
                this.limitId = Integer.MAX_VALUE;
            } else {
                this.hasScatteredIds = true;
            }
        }
        if (this.hasScatteredIds) {
            this.limitId = -1;
            while (this.nextId > this.limitId || this.rangeStarts.contains(this.nextId)) {
                int n = Math.abs(new Random().nextInt());
                this.nextId = DbAdmin.query("select value(max(" + this.idColumn + ")+1, 1) from $(SCHEMA)." + this.table + " where " + this.idColumn + "<" + n, new Object[0]).toSingleInt();
                this.limitId = DbAdmin.query("select value(min(" + this.idColumn + ")-1, 2147483647) from $(SCHEMA)." + this.table + " where " + this.idColumn + ">=" + n, new Object[0]).toSingleInt();
            }
            this.rangeStarts.add(this.nextId);
        }
    }

    public synchronized int getKey() throws SQLRuntimeException {
        DbAdmin.lockTable(this.table);
        if (this.nextId == 0 || this.nextId > this.limitId) {
            this.findOpenRange();
        }
        return this.nextId++;
    }

    public synchronized void reset() {
        this.nextId = 0;
        this.rangeStarts.clear();
    }
}

