/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import java.sql.SQLException;

public class SQLRuntimeException
extends RuntimeException {
    private SQLException innerException;
    private String msg;

    public SQLRuntimeException(SQLException sQLException) {
        this.innerException = sQLException;
        this.msg = "SQLRuntimeException";
        this.setStackTrace(sQLException.getStackTrace());
    }

    public SQLRuntimeException(String string) {
        this.msg = string;
    }

    public SQLRuntimeException(String string, SQLException sQLException) {
        this.msg = string;
        this.innerException = sQLException;
        this.setStackTrace(sQLException.getStackTrace());
    }

    public SQLException getNextException() {
        return this.innerException;
    }

    public int getErrorCode() {
        return this.innerException == null ? 0 : this.innerException.getErrorCode();
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder(this.msg);
        SQLException sQLException = this.innerException;
        for (int n = 10; sQLException != null && n > 0; sQLException = sQLException.getNextException(), --n) {
            stringBuilder.append("\n\tCaused by: " + sQLException.getLocalizedMessage());
        }
        return stringBuilder.toString();
    }
}

