/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbPreparedStatement;
import com.ibm.dmh.db.DbResultSet;
import com.ibm.dmh.db.DbStats;
import com.ibm.dmh.db.PrimaryKeyGenerator;
import com.ibm.dmh.log.LoggerManager;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DbContext {
    protected Connection c;
    protected String user;
    protected String pw;
    protected DbStats dbStats;
    protected Writer dbLog;
    private Logger logger = LoggerManager.getMainLogger();
    protected Map<String, DbPreparedStatement> psReusableCache = new HashMap<String, DbPreparedStatement>();
    protected Set<DbPreparedStatement> psNonReusableCache = new HashSet<DbPreparedStatement>();
    protected Set<DbResultSet> rsCache = new HashSet<DbResultSet>();
    protected Map<String, PrimaryKeyGenerator> pkCache = new HashMap<String, PrimaryKeyGenerator>();
    protected Set<String> lockedTables = new HashSet<String>();

    protected DbContext(Connection connection, String string, String string2) {
        this.c = connection;
        this.user = string;
        this.pw = string2;
    }

    protected void closeContext() throws SQLException {
        for (DbPreparedStatement dbPreparedStatement : this.psReusableCache.values()) {
            dbPreparedStatement.close();
        }
        int n = this.rsCache.size();
        if (n > 0) {
            this.logger.warning("[" + n + "] result sets were not closed during the call to DbAdmin.close(Connection).");
            int n2 = 1;
            for (DbResultSet object : this.rsCache) {
                this.logger.warning("\t[SQL-" + n2++ + "] - " + object.sql);
                object.close();
            }
        }
        if ((n = this.psNonReusableCache.size()) > 0) {
            this.logger.warning("[" + n + "] non-reusable prepared statements were not closed during the call to DbAdmin.close(Connection).");
            int n3 = 1;
            for (DbPreparedStatement dbPreparedStatement : this.psNonReusableCache) {
                this.logger.warning("\t[SQL-" + n3++ + "] - " + dbPreparedStatement.sql);
                dbPreparedStatement.close();
            }
        }
        if (!this.c.isClosed()) {
            this.c.commit();
            this.c.close();
        }
    }
}

