/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.cfgmgr;

import com.ibm.dmh.cfgmgr.ConfigFile;
import com.ibm.dmh.cfgmgr.ConfigMgr;
import com.ibm.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.dmh.cfgmgr.ExpressionSolver;
import com.ibm.dmh.cfgmgr.PasswordUtil;
import com.ibm.dmh.util.StringUtils;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public class ConfigEntry {
    ConfigFile configFile;
    String rawValue;
    String resolvedValue;
    String sectionName;
    String propName;
    String configKey;
    boolean isEncoded;
    MessageFormat messageFormat;

    public ConfigEntry(ConfigFile configFile, String string, String string2, String string3, boolean bl, int n) throws ConfigRuntimeException {
        this.configFile = configFile;
        this.sectionName = string;
        this.propName = string2;
        this.configKey = (string == null ? "" : string + ".") + string2;
        this.rawValue = string3;
        this.isEncoded = bl;
        if (bl && !string3.startsWith("{xor}")) {
            try {
                this.rawValue = PasswordUtil.encode(string3);
            }
            catch (Exception exception) {
                throw new ConfigRuntimeException("Could not encode value for prop [" + string2 + "] at line [" + n + "] of [" + configFile.name + "].  Msg=[" + exception.getLocalizedMessage() + "]");
            }
            configFile.hasBeenModified = true;
        }
    }

    public String getValue() throws ConfigRuntimeException {
        if (this.resolvedValue == null) {
            this.resolveValue();
        }
        return this.resolvedValue;
    }

    public String getValue(Object[] objectArray) throws ConfigRuntimeException {
        if (this.resolvedValue == null) {
            this.resolveValue();
        }
        if (this.messageFormat != null) {
            return this.messageFormat.format(objectArray);
        }
        return this.resolvedValue;
    }

    private void resolveValue() throws ConfigRuntimeException {
        int n;
        String string;
        int n2;
        String string2 = this.rawValue;
        if (this.isEncoded) {
            try {
                string2 = PasswordUtil.decode(string2);
            }
            catch (Throwable throwable) {
                throw new ConfigRuntimeException("Could not decode property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + throwable.getLocalizedMessage() + "]", throwable);
            }
        }
        int n3 = 0;
        while ((n2 = string2.indexOf("$C{", n3)) != -1) {
            String string3;
            n3 = string2.indexOf(125, n2);
            string = string2.substring(n2 + 3, string2.indexOf(125, n2));
            String string4 = string3 = string.startsWith("this.") ? this.configFile.get(string.substring(5)) : ConfigMgr.get(string, (String)null);
            if (string3 != null) {
                string2 = string2.substring(0, n2) + string3 + string2.substring(n3 + 1);
            }
            n3 = n2 + 1;
        }
        n3 = 0;
        while ((n2 = string2.indexOf("$L{", n3)) != -1 && this.configFile.resourceBundle != null) {
            n3 = string2.indexOf(125, n2);
            string = null;
            try {
                string = this.configFile.resourceBundle.getString(string2.substring(n2 + 3, string2.indexOf(125, n2)));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (string != null) {
                string2 = string2.substring(0, n2) + string + string2.substring(n3 + 1);
            }
            n3 = n2 + 1;
        }
        if (string2.startsWith("math(")) {
            try {
                string2 = "" + ExpressionSolver.solveMath(string2.substring(5, string2.lastIndexOf(41)));
            }
            catch (Exception exception) {
                throw new ConfigRuntimeException("Math error encountered trying to solve property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + exception.getLocalizedMessage() + "]", exception);
            }
        }
        if (string2.startsWith("mathf(")) {
            try {
                string = string2.substring(6, string2.lastIndexOf(41));
                float f = ExpressionSolver.solveFloatMath(string);
                String string5 = Float.toString(f);
                string2 = string5.indexOf(69) != -1 ? string5 : ((n = string5.indexOf(46)) == -1 ? string5 : string5.substring(0, n));
            }
            catch (Exception exception) {
                throw new ConfigRuntimeException("Math error encountered trying to solve property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + exception.getLocalizedMessage() + "]", exception);
            }
        }
        if (string2.startsWith("case(")) {
            try {
                string = string2.substring(5, string2.lastIndexOf(41));
                String[] stringArray = StringUtils.split(string, ',');
                boolean bl = false;
                for (n = 0; n < stringArray.length - 1 && !bl; ++n) {
                    String string6 = stringArray[n];
                    int n4 = string6.indexOf(61);
                    String string7 = string6.substring(0, n4 - 1).trim();
                    String string8 = string6.substring(n4 + 1).trim();
                    if (!ExpressionSolver.solveBoolean(string7)) continue;
                    bl = true;
                    string2 = "" + ExpressionSolver.solveMath(string8);
                }
                if (!bl) {
                    string2 = "" + ExpressionSolver.solveMath(stringArray[stringArray.length - 1]);
                }
            }
            catch (Exception exception) {
                throw new ConfigRuntimeException("Math error encountered trying to solve property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + exception.getLocalizedMessage() + "]", exception);
            }
        }
        this.resolvedValue = string2;
        if (string2.indexOf("{0") != -1) {
            this.messageFormat = new MessageFormat(string2);
        }
    }

    public void setValue(String string) throws ConfigRuntimeException {
        if (this.isEncoded && !string.startsWith("{xor}")) {
            try {
                string = PasswordUtil.encode(string);
            }
            catch (Exception exception) {
                throw new ConfigRuntimeException("Could not encode value for property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + exception.getMessage() + "]", exception);
            }
        }
        if (!string.equals(this.rawValue)) {
            this.rawValue = string;
            this.configFile.hasBeenModified = true;
        }
        this.resolvedValue = null;
    }
}

