/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.qp.AbstractWork;
import com.ibm.dmh.util.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WorkStatus {
    UNKNOWN(0),
    ACCEPTED(1),
    REJECTED(2),
    STARTED(3),
    COMPLETED(4),
    FAILED(5),
    ABORTED(6),
    INDETERMINATE(7),
    ANY(99);

    private static ResourceBundle i18n;
    private int val;

    private WorkStatus(int n2) {
        this.val = n2;
    }

    public boolean isInState(WorkStatus ... workStatusArray) {
        for (WorkStatus workStatus : workStatusArray) {
            if (workStatus != this && workStatus != ANY) continue;
            return true;
        }
        return false;
    }

    public static WorkStatus[] valueOfNames(String string) {
        LinkedList<WorkStatus> linkedList = new LinkedList<WorkStatus>();
        for (String string2 : StringUtils.split(string, ',')) {
            WorkStatus workStatus = WorkStatus.valueOf(string2);
            if (workStatus == null) {
                throw new RuntimeException("Invalid work status:  " + string2);
            }
            linkedList.add(workStatus);
        }
        return linkedList.toArray(new WorkStatus[linkedList.size()]);
    }

    public static Collection<AbstractWork> filter(Collection<AbstractWork> collection, WorkStatus ... workStatusArray) {
        LinkedList<AbstractWork> linkedList = new LinkedList<AbstractWork>();
        for (AbstractWork abstractWork : collection) {
            if (!abstractWork.isInState(workStatusArray)) continue;
            linkedList.add(abstractWork);
        }
        return linkedList;
    }

    public String toLocalizedString() {
        return i18n.getString("Status." + this.val);
    }

    public int toInt() {
        return this.val;
    }

    static {
        i18n = ResourceBundle.getBundle("com.ibm.dmh.qp.WorkStatus");
    }
}

