/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbColumn;
import com.ibm.dmh.db.DbIndex;
import com.ibm.dmh.db.DbTable;
import com.ibm.dmh.db.DbTrigger;
import com.ibm.dmh.db.SqlUtils;
import com.ibm.wsaa.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DbMetaData {
    private Map tables = new TreeMap();
    private String schemaName = null;
    private String schemaDesc = null;
    private String os = null;
    private int formatVersion = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMetaData(Connection c, String schemaName, String schemaDesc) throws SQLException {
        this.schemaName = schemaName = schemaName.trim().toUpperCase();
        this.schemaDesc = schemaDesc;
        ResultSet rs = null;
        Statement st = null;
        Pattern p1 = null;
        Pattern p2 = null;
        Pattern p3 = null;
        Pattern p4 = null;
        try {
            p1 = Pattern.compile(".*\\s+AFTER\\s+(\\S+)\\s+(?:OF \\S+\\s+)?ON\\s+.*");
            p2 = Pattern.compile("\\s+DELETE\\s+FROM\\s+(\\S+)\\s+");
            p3 = Pattern.compile("\\s+UPDATE\\s+(\\S+)\\s+");
            p4 = Pattern.compile("\\s+INSERT\\s+INTO\\s+(\\S+)\\s+");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace(System.err);
            DbAdmin.close(rs);
            DbAdmin.close(st);
            return;
        }
        try {
            String tableName;
            String tbName;
            rs = c.getMetaData().getTables(null, "SYSIBM", "SYSDATABASE", null);
            this.os = rs.next() ? "zOS" : "UDB";
            rs.close();
            String sql = null;
            st = c.createStatement();
            sql = "select NAME,TYPE from SYSIBM.SYSTABLES where CREATOR='" + schemaName + "' order by NAME";
            rs = st.executeQuery(sql);
            while (rs.next()) {
                tbName = rs.getString(1).trim().toUpperCase();
                String type = rs.getString(2).trim().toUpperCase();
                this.tables.put(tbName, new DbTable(tbName, type.charAt(0)));
            }
            sql = this.os.equals("zOS") ? "select TBNAME,NAME,COLTYPE,LENGTH,LENGTH2,NULLS,DEFAULT,DEFAULTVALUE from SYSIBM.SYSCOLUMNS where TBCREATOR='" + schemaName + "' " + "order by TBNAME, COLNO" : "select TBNAME,NAME,COLTYPE,LENGTH,LONGLENGTH,NULLS,DEFAULT,'1' from SYSIBM.SYSCOLUMNS where TBCREATOR='" + schemaName + "' " + "order by TBNAME, COLNO";
            rs = st.executeQuery(sql);
            while (rs.next()) {
                tbName = rs.getString(1).trim().toUpperCase();
                String colName = rs.getString(2).trim().toUpperCase();
                int colType = SqlUtils.getSqlTypeInt(rs.getString(3).trim());
                int length = rs.getInt(4);
                int longLength = rs.getInt(5);
                String nulls = rs.getString(6);
                String defaultx = rs.getString(7);
                String defaultValue = rs.getString(8);
                boolean canBeNull = StringUtils.getBoolean((String)nulls);
                String colDefValue = null;
                if (this.os.equals("zOS")) {
                    char defaultChar = defaultx.charAt(0);
                    switch (defaultChar) {
                        case 'A': 
                        case 'D': 
                        case 'I': 
                        case 'J': 
                        case 'N': 
                        case 'S': 
                        case 'U': {
                            break;
                        }
                        case 'B': {
                            colDefValue = SqlUtils.getDefaultForColumnType(colType);
                            break;
                        }
                        case 'Y': {
                            if (nulls.equalsIgnoreCase("Y")) break;
                            colDefValue = SqlUtils.getDefaultForColumnType(colType);
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '7': {
                            colDefValue = defaultValue;
                        }
                    }
                    if (longLength > 0) {
                        length = longLength;
                    }
                } else {
                    length = longLength;
                    colDefValue = defaultx;
                    if (colDefValue != null && colDefValue.startsWith("'")) {
                        colDefValue = colDefValue.substring(1, colDefValue.length() - 1);
                    }
                }
                if (colDefValue != null) {
                    colDefValue = colDefValue.trim();
                }
                DbTable table = (DbTable)this.tables.get(tbName);
                if (table.type == 'V') {
                    colDefValue = null;
                }
                table.addColumn(new DbColumn(colName, colType, length, colDefValue, "" + canBeNull));
            }
            rs.close();
            rs = st.executeQuery("select NAME, TBNAME from SYSIBM.SYSINDEXES where TBCREATOR='" + schemaName + "' and CREATOR='" + schemaName + "'");
            while (rs.next()) {
                String tableName2 = rs.getString(2).trim().toUpperCase();
                String indexName = rs.getString(1).trim().toUpperCase();
                DbTable table = (DbTable)this.tables.get(tableName2);
                if (table == null) {
                    throw new RuntimeException("Unexpected scenario encountered.  Table [" + tableName2 + "] for index [" + indexName + "] was not previously found in SYSIBM.SYSTABLES.  Contact IBM support.");
                }
                table.addIndex(new DbIndex(indexName, null));
            }
            rs.close();
            st.close();
            sql = this.os.equals("zOS") ? "select A.TBNAME as TABLE, A.NAME as INDEX, B.COLNAME as COLUMN, B.ORDERING as ORD from SYSIBM.SYSINDEXES A, SYSIBM.SYSKEYS B where A.TBCREATOR='" + schemaName + "' and A.CREATOR='" + schemaName + "' and A.NAME=B.IXNAME and B.IXCREATOR='" + schemaName + "' " + "order by table, index, colseq" : "select A.TBNAME as TABLE, A.NAME as INDEX, B.COLNAME as COLUMN, B.COLORDER as ORD from SYSIBM.SYSINDEXES A, SYSIBM.SYSINDEXCOLUSE B where A.TBCREATOR='" + schemaName + "' and A.CREATOR='" + schemaName + "' and A.NAME=B.INDNAME and B.INDSCHEMA='" + schemaName + "'" + "order by table, index, colseq";
            HashMap map = new HashMap();
            st = c.createStatement();
            rs = st.executeQuery(sql);
            while (rs.next()) {
                tableName = rs.getString(1).trim().toUpperCase();
                String indexName = rs.getString(2).trim().toUpperCase();
                String columnName = rs.getString(3).trim().toUpperCase();
                String order = rs.getString(4).trim().toUpperCase();
                String key = tableName + "," + indexName;
                if (!map.containsKey(key)) {
                    map.put(key, new LinkedList());
                }
                LinkedList l = (LinkedList)map.get(key);
                l.add(columnName + "-" + order);
            }
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                List val = (List)map.get(key);
                String[] k = key.split(",");
                ((DbTable)this.tables.get((Object)k[0])).getIndex((String)k[1]).colTokens = DbMetaData.join(val);
            }
            rs.close();
            st.close();
            st = c.createStatement();
            rs = st.executeQuery("select NAME, TBNAME, TEXT from SYSIBM.SYSTRIGGERS where SCHEMA='" + schemaName + "'");
            while (rs.next()) {
                tableName = rs.getString(2).trim().toUpperCase();
                String triggerName = rs.getString(1).trim().toUpperCase();
                DbTable table = (DbTable)this.tables.get(tableName);
                String text = rs.getString(3).trim().toUpperCase();
                text = text.replaceAll("\n", " ");
                String triggerType = "Unknown";
                LinkedList<String> triggerTargets = new LinkedList<String>();
                Matcher m = p1.matcher(text);
                if (m.matches()) {
                    triggerType = m.group(1).substring(0, 1);
                }
                text = text.substring(text.indexOf("MODE"));
                m = p2.matcher(text);
                while (m.find()) {
                    triggerTargets.add(DbMetaData.stripSchema(m.group(1)) + "-D");
                }
                m = p3.matcher(text);
                while (m.find()) {
                    triggerTargets.add(DbMetaData.stripSchema(m.group(1)) + "-U");
                }
                m = p4.matcher(text);
                while (m.find()) {
                    triggerTargets.add(DbMetaData.stripSchema(m.group(1)) + "-I");
                }
                if (triggerType.equals("Unknown")) {
                    System.err.println("ERROR: Couldn't determine trigger type on '" + triggerName + "'.");
                }
                if (triggerTargets.size() == 0) {
                    System.err.println("ERROR: Couldn't find any targets on trigger '" + triggerName + "'.");
                }
                table.addTrigger(new DbTrigger(triggerName, triggerType, DbMetaData.join(triggerTargets)));
            }
            rs.close();
            st.close();
            st = c.createStatement();
            try {
                rs = st.executeQuery("select TBNAME, NAME from SYSIBM.SYSCOLUMNS where TBCREATOR='" + schemaName + "' and KEYSEQ > 0 ORDER BY TBNAME, KEYSEQ");
                while (rs.next()) {
                    tableName = rs.getString(1).trim().toUpperCase();
                    String columnName = rs.getString(2).trim().toUpperCase();
                    DbTable table = (DbTable)this.tables.get(tableName);
                    table.pkColumns = table.pkColumns + (table.pkColumns.equals("") ? "" : ",") + columnName;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -204) {
                    System.out.println("WARNING:  Database appears to be on DB2 pre-v7.  Unable to retrieve primary key information.");
                }
                throw e;
            }
            rs.close();
            st.close();
        }
        catch (Throwable throwable) {
            DbAdmin.close(rs);
            DbAdmin.close(st);
            throw throwable;
        }
        DbAdmin.close(rs);
        DbAdmin.close(st);
    }

    public DbMetaData(File metaDataFile, String schemaName) throws ParserConfigurationException, FactoryConfigurationError, FileNotFoundException, SAXException, IOException {
        this.schemaName = schemaName;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element root = builder.parse(new InputSource(new FileReader(metaDataFile))).getDocumentElement();
        this.schemaDesc = root.getAttribute("desc");
        this.formatVersion = Integer.parseInt(DbMetaData.value(root.getAttribute("formatVersion"), "1"));
        NodeList nl = root.getElementsByTagName("Table");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element x;
            int j;
            Element tableElement = (Element)nl.item(i);
            String tableName = tableElement.getAttribute("name");
            String pk = tableElement.getAttribute("pk");
            String tableType = tableElement.getAttribute("type");
            DbTable table = new DbTable(tableName, StringUtils.isEmpty((String)tableType) ? (char)'U' : tableType.charAt(0));
            table.pkColumns = pk;
            this.tables.put(tableName, table);
            NodeList nl2 = tableElement.getElementsByTagName("Column");
            for (j = 0; j < nl2.getLength(); ++j) {
                x = (Element)nl2.item(j);
                DbColumn column = this.formatVersion > 1 ? new DbColumn(x.getAttribute("name"), x.getAttribute("type"), x.hasAttribute("default") ? x.getAttribute("default") : null, x.hasAttribute("nullable") ? x.getAttribute("nullable") : "false") : new DbColumn(x.getAttribute("name"), Integer.parseInt(x.getAttribute("type")), Integer.parseInt(x.getAttribute("size")), null, null);
                table.addColumn(column);
            }
            nl2 = tableElement.getElementsByTagName("Index");
            for (j = 0; j < nl2.getLength(); ++j) {
                x = (Element)nl2.item(j);
                DbIndex index = new DbIndex(x.getAttribute("name"), DbMetaData.value(x.getAttribute("colTokens"), ""));
                table.addIndex(index);
            }
            nl2 = tableElement.getElementsByTagName("Trigger");
            for (j = 0; j < nl2.getLength(); ++j) {
                x = (Element)nl2.item(j);
                DbTrigger trigger = new DbTrigger(x.getAttribute("name"), DbMetaData.value(x.getAttribute("type"), ""), DbMetaData.value(x.getAttribute("targets"), ""));
                table.addTrigger(trigger);
            }
        }
    }

    public void saveToFile(File metaDataFile) throws IOException {
        if (!metaDataFile.exists()) {
            metaDataFile.getParentFile().mkdirs();
        }
        PrintWriter out = new PrintWriter(new FileWriter(metaDataFile));
        out.println("<DbMetaData desc='" + this.schemaDesc + "' formatVersion='" + this.formatVersion + "'>");
        Iterator i = this.tables.keySet().iterator();
        while (i.hasNext()) {
            String tableName = (String)i.next();
            DbTable table = (DbTable)this.tables.get(tableName);
            out.println("\t<Table name='" + tableName + "' pk='" + table.pkColumns + "' type='" + table.type + "'>");
            Iterator<Object> j = table.columns.valueList().iterator();
            while (j.hasNext()) {
                DbColumn column = (DbColumn)j.next();
                out.println("\t\t<Column name='" + column.name + "' type='" + SqlUtils.getSqlTypeAndSizeString(column.type, column.size) + "'" + (column.allowNull ? " nullable='true'" : "") + (column.defaultValue == null ? "" : " default='" + column.defaultValue + "'") + "/>");
            }
            j = table.indexes.keySet().iterator();
            while (j.hasNext()) {
                String indexName = (String)j.next();
                DbIndex index = table.getIndex(indexName);
                out.println("\t\t<Index name='" + indexName + "' colTokens='" + index.colTokens + "'/>");
            }
            j = table.triggers.keySet().iterator();
            while (j.hasNext()) {
                String triggerName = (String)j.next();
                DbTrigger trigger = table.getTrigger(triggerName);
                out.println("\t\t<Trigger name='" + triggerName + "' type='" + trigger.type + "' targets='" + trigger.targets + "'/>");
            }
            out.println("\t</Table>");
        }
        out.println("</DbMetaData>");
        out.flush();
        out.close();
    }

    private static String join(List l) {
        StringBuffer sb = new StringBuffer();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            sb.append(i.next() + (i.hasNext() ? "," : ""));
        }
        return sb.toString();
    }

    public String[] compareTo(DbMetaData dmd) {
        DbTrigger thisTrigger;
        String triggerName;
        DbIndex thisIndex;
        String indexName;
        String columnName;
        Iterator<Object> j;
        DbTable compTable;
        DbTable thisTable;
        String tableName;
        LinkedList<String> problems = new LinkedList<String>();
        boolean bothAtFV2 = this.formatVersion >= 2 && dmd.formatVersion >= 2;
        Iterator i = dmd.tables.keySet().iterator();
        while (i.hasNext()) {
            tableName = (String)i.next();
            thisTable = this.getTable(tableName);
            compTable = dmd.getTable(tableName);
            if (thisTable == null) {
                problems.add("Database is missing table '" + tableName + "'.");
                continue;
            }
            if (!thisTable.pkColumns.equals(compTable.pkColumns)) {
                problems.add("Table '" + tableName + "' primary key columns should be '" + compTable.pkColumns + "' but is '" + thisTable.pkColumns + "'");
            }
            j = compTable.columns.keySet().iterator();
            while (j.hasNext()) {
                columnName = (String)j.next();
                DbColumn thisColumn = thisTable.getColumn(columnName);
                DbColumn compColumn = compTable.getColumn(columnName);
                if (thisColumn == null) {
                    problems.add("Database is missing column '" + columnName + "' in table '" + tableName + "'");
                    continue;
                }
                if (thisColumn.type != compColumn.type || thisColumn.size != compColumn.size) {
                    problems.add("Column type should be '" + SqlUtils.getSqlTypeAndSizeString(compColumn.type, compColumn.size) + "' but is '" + SqlUtils.getSqlTypeAndSizeString(thisColumn.type, thisColumn.size) + "' for column '" + columnName + "' in table '" + tableName + "'.");
                }
                if (!bothAtFV2) continue;
                if (!DbMetaData.isEqual(thisColumn.defaultValue, compColumn.defaultValue)) {
                    problems.add("Column default value should be '" + compColumn.defaultValue + "' but is '" + thisColumn.defaultValue + "' for column '" + columnName + "' in table '" + tableName + "'.");
                }
                if (thisColumn.allowNull == compColumn.allowNull) continue;
                problems.add("Column nullable should be '" + compColumn.allowNull + "' but is '" + thisColumn.allowNull + "' for column '" + columnName + "' in table '" + tableName + "'.");
            }
            j = compTable.indexes.keySet().iterator();
            while (j.hasNext()) {
                indexName = (String)j.next();
                thisIndex = thisTable.getIndex(indexName);
                DbIndex compIndex = compTable.getIndex(indexName);
                if (thisIndex == null) {
                    problems.add("Database is missing index '" + indexName + "' in table '" + tableName + "'");
                    continue;
                }
                if (!bothAtFV2 || thisIndex.colTokens.equals(compIndex.colTokens)) continue;
                problems.add("Columns on index '" + indexName + "' are different.  Expected='" + compIndex.colTokens + "', actual='" + thisIndex.colTokens + "'.");
            }
            j = compTable.triggers.keySet().iterator();
            while (j.hasNext()) {
                triggerName = (String)j.next();
                thisTrigger = thisTable.getTrigger(triggerName);
                DbTrigger compTrigger = compTable.getTrigger(triggerName);
                if (thisTrigger == null) {
                    problems.add("Database is missing trigger '" + triggerName + "' in table '" + tableName + "'");
                    continue;
                }
                if (bothAtFV2 && !thisTrigger.type.equals(compTrigger.type)) {
                    problems.add("Trigger '" + triggerName + "' was expected to be of type '" + compTrigger.type + "' but was actually of type '" + thisTrigger.type + "'.");
                    continue;
                }
                if (!bothAtFV2 || thisTrigger.targets.equals(compTrigger.targets)) continue;
                problems.add("Trigger target tables on '" + triggerName + "' was expected to be '" + compTrigger.targets + "' but was actually '" + thisTrigger.targets + "'.");
            }
        }
        i = this.tables.keySet().iterator();
        while (i.hasNext()) {
            tableName = (String)i.next();
            thisTable = this.getTable(tableName);
            compTable = dmd.getTable(tableName);
            if (compTable == null) {
                problems.add("Database has extra table '" + tableName + "'.");
                continue;
            }
            j = thisTable.columns.keySet().iterator();
            while (j.hasNext()) {
                columnName = (String)j.next();
                DbColumn compColumn = compTable.getColumn(columnName);
                if (compColumn != null) continue;
                problems.add("Database has extra column '" + columnName + "' in table '" + tableName + "'");
            }
            j = thisTable.indexes.keySet().iterator();
            while (j.hasNext()) {
                indexName = (String)j.next();
                thisIndex = compTable.getIndex(indexName);
                if (thisIndex != null) continue;
                problems.add("Database has extra index '" + indexName + "' in table '" + tableName + "'");
            }
            j = thisTable.triggers.keySet().iterator();
            while (j.hasNext()) {
                triggerName = (String)j.next();
                thisTrigger = compTable.getTrigger(triggerName);
                if (thisTrigger != null) continue;
                problems.add("Database has extra trigger '" + triggerName + "' in table '" + tableName + "'");
            }
        }
        return problems.toArray(new String[problems.size()]);
    }

    public DbTable getTable(String name) {
        if ((name = name.toUpperCase()).startsWith(this.schemaName + ".")) {
            name = name.substring(name.indexOf(46) + 1);
        }
        return (DbTable)this.tables.get(name.toUpperCase());
    }

    public Map getTableMap() {
        return this.tables;
    }

    public DbColumn getColumn(String tableName, String columnName) {
        DbTable t = this.getTable(tableName);
        if (t == null) {
            return null;
        }
        return (DbColumn)t.columns.get((Object)columnName.toUpperCase());
    }

    public DbIndex getIndex(String tableName, String indexName) {
        DbTable t = this.getTable(tableName);
        if (t == null) {
            return null;
        }
        return (DbIndex)t.indexes.get(indexName.toUpperCase());
    }

    public DbTrigger getTrigger(String tableName, String triggerName) {
        DbTable t = this.getTable(tableName);
        if (t == null) {
            return null;
        }
        return (DbTrigger)t.triggers.get(triggerName.toUpperCase());
    }

    public Map getColumnMap(String tableName) {
        DbTable t = this.getTable(tableName);
        if (t == null) {
            return null;
        }
        return t.columns;
    }

    public static String value(String s, String def) {
        if (s == null || s.equals("")) {
            return def;
        }
        return s;
    }

    public static String stripSchema(String s) {
        int i = s.indexOf(46);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static boolean isEqual(Object s1, Object s2) {
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null;
        }
        return s1.equals(s2);
    }
}

