/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import com.ibm.wsaa.util.FileContents;
import com.ibm.wsaa.util.LocaleMgr;
import com.ibm.wsaa.util.StringUtils;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;

public class SqlOutputFile
implements ITask {
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        taskBody = taskBody.replaceAll("\n\\s*\n", "\n");
        taskBody = taskBody.replaceAll("([^\\\\];)", "$1\n");
        taskBody = Pattern.compile("[\\s]*$", 8).matcher(taskBody).replaceAll("");
        return taskBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        String[] commands = SqlOutputFile.breakUpCommands(taskBody);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = DbAdmin.getConnection().createStatement();
            String outputfile = attrs.getNamedItem("outputfile").getNodeValue();
            boolean includeheader = StringUtils.getBoolean((String)attrs.getNamedItem("includeheader").getNodeValue(), (boolean)false);
            FileContents fc = new FileContents();
            StringBuffer sb = fc.getContentsBuffer();
            int numRows = 0;
            for (int i = 0; i < commands.length; ++i) {
                String sql = commands[i].trim();
                if (sql.trim().equals("")) continue;
                sql = sql.replaceAll("\n        ", "\n");
                sql = sql.replaceAll("\n\t\t", "\n");
                rs = st.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                if (includeheader) {
                    StringBuffer head = new StringBuffer();
                    for (int j = 1; j <= numCols; ++j) {
                        head.append(rsmd.getColumnName(j).trim() + (j == numCols ? "" : ","));
                    }
                    sb.append("# " + head + "\n\n");
                }
                while (rs.next()) {
                    ++numRows;
                    for (int j = 1; j <= numCols; ++j) {
                        sb.append(rs.getString(j).trim() + (j == numCols ? "" : ","));
                    }
                    sb.append("\n");
                }
            }
            File f = new File(outputfile);
            Main.logln("Generating file:  [" + f.getAbsolutePath() + "]");
            Main.logln("Encoding:         [" + LocaleMgr.getExternalDefaultEncoding() + "]");
            Main.logln("#-Rows:           [" + numRows + "]");
            fc.saveFile(outputfile, LocaleMgr.getExternalDefaultEncoding());
        }
        catch (Exception e) {
            Main.logException(e);
            int n = 2;
            return n;
        }
        finally {
            DbAdmin.close(st);
        }
        return 0;
    }

    private static String[] breakUpCommands(String commands) {
        commands = commands + "\n";
        commands = commands.replaceAll("\n\\s*--[^\n]*", "\n");
        return StringUtils.split((String)commands, (char)';', (boolean)true);
    }
}

