/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonList;
import com.ibm.jjson.JsonParseException;
import com.ibm.jjson.JsonParser;
import com.ibm.jjson.JsonSerializer;
import com.ibm.jjson.JsonUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonMap
extends LinkedHashMap {
    private static final long serialVersionUID = 1L;

    public JsonMap(String string) throws JsonParseException {
        JsonParser.parseInto(string, this);
    }

    public JsonMap() {
    }

    public JsonMap(Map map) {
        super(map);
    }

    public Object get(Object object, Object object2) {
        Object v = this.get(object);
        return v == null ? object2 : v;
    }

    public void putJson(Object object, String string) {
        this.put(object, JsonParser.parse(string));
    }

    public String getString(String string) {
        return JsonUtils.toString(this.get(string), null);
    }

    public String getString(String string, String string2) {
        return JsonUtils.toString(this.get(string), string2);
    }

    public int getInt(String string) {
        return JsonUtils.toInt(this.get(string));
    }

    public int getInt(String string, int n) {
        return JsonUtils.toInt(this.get(string), n);
    }

    public long getLong(String string) {
        return JsonUtils.toLong(this.get(string));
    }

    public long getLong(String string, long l) {
        return JsonUtils.toLong(this.get(string), l);
    }

    public boolean getBoolean(String string) {
        return JsonUtils.toBoolean(this.get(string));
    }

    public boolean getBoolean(String string, boolean bl) {
        return JsonUtils.toBoolean(this.get(string), bl);
    }

    public Map getMap(String string) {
        return (Map)this.get(string);
    }

    public Map getMap(String string, Map map) {
        return (Map)this.get(string, map);
    }

    public List getList(String string) {
        return JsonUtils.toList((Collection)this.get(string));
    }

    public List getList(String string, List list) {
        return JsonUtils.toList((Collection)this.get(string, list));
    }

    public JsonMap getJsonMap(String string) {
        return JsonUtils.toJsonMap((Map)this.get(string));
    }

    public JsonMap getJsonMap(String string, JsonMap jsonMap) {
        return JsonUtils.toJsonMap((Map)this.get(string, jsonMap));
    }

    public JsonList getJsonList(String string) {
        return JsonUtils.toJsonList((List)this.get(string));
    }

    public JsonList getJsonList(String string, JsonList jsonList) {
        return JsonUtils.toJsonList((List)this.get(string, jsonList));
    }

    public String toString(int n, int n2, boolean bl) {
        String string = JsonSerializer.serialize(this, n, n2);
        if (bl) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String toString(int n, int n2) {
        return JsonSerializer.serialize(this, n, n2);
    }

    public String toString() {
        return this.toString(JsonSerializer.NOT_STRICT, JsonSerializer.FORMAT_NORMAL);
    }
}

