/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonList;
import com.ibm.jjson.JsonMap;
import com.ibm.jjson.JsonParser;
import com.ibm.jjson.JsonSerializer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static String toStrictJson(String string, int n) {
        return JsonSerializer.serialize(JsonParser.parse(string), JsonSerializer.STRICT, n);
    }

    public static String toStrictJson(String string) {
        return JsonUtils.toStrictJson(string, JsonSerializer.FORMAT_NORMAL);
    }

    public static Object deepClone(Object object) {
        if (object instanceof Map) {
            JsonMap jsonMap = new JsonMap((Map)object);
            Iterator iterator = jsonMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entry.setValue(JsonUtils.deepClone(entry.getValue()));
            }
            return jsonMap;
        }
        if (object instanceof List) {
            JsonList jsonList = new JsonList();
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                jsonList.add(JsonUtils.deepClone(iterator.next()));
            }
            return jsonList;
        }
        return object;
    }

    public static String toJsonString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\n') {
                stringBuffer.append('\\').append('n');
                continue;
            }
            if (c == '\t') {
                stringBuffer.append('\\').append('t');
                continue;
            }
            if (c == '\'') {
                stringBuffer.append('\\').append('\'');
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            if (c == '\r') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static JsonMap toJsonMap(Map map) {
        if (map == null) {
            return null;
        }
        return map instanceof JsonMap ? (JsonMap)map : new JsonMap(map);
    }

    public static JsonList toJsonList(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection instanceof JsonList ? (JsonList)collection : new JsonList(collection);
    }

    public static List toList(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection instanceof List ? (List)collection : new JsonList(collection);
    }

    public static JsonList[] toJsonListArray(Collection[] collectionArray) {
        if (collectionArray == null) {
            return null;
        }
        if (collectionArray instanceof JsonList[]) {
            return (JsonList[])collectionArray;
        }
        JsonList[] jsonListArray = new JsonList[collectionArray.length];
        for (int i = 0; i < collectionArray.length; ++i) {
            jsonListArray[i] = JsonUtils.toJsonList(collectionArray[i]);
        }
        return jsonListArray;
    }

    public static JsonMap[] toJsonMapArray(Map[] mapArray) {
        if (mapArray == null) {
            return null;
        }
        if (mapArray instanceof JsonMap[]) {
            return (JsonMap[])mapArray;
        }
        JsonMap[] jsonMapArray = new JsonMap[mapArray.length];
        for (int i = 0; i < mapArray.length; ++i) {
            jsonMapArray[i] = JsonUtils.toJsonMap(mapArray[i]);
        }
        return jsonMapArray;
    }

    public static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return c == 'T' || c == 't' || c == 'Y' || c == 'y' || c == '1';
    }

    public static boolean toBoolean(Object object, boolean bl) {
        return object == null ? bl : JsonUtils.toBoolean(object);
    }

    public static int toInt(Object object) {
        return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
    }

    public static int toInt(Object object, int n) {
        return object == null ? n : JsonUtils.toInt(object);
    }

    public static long toLong(Object object) {
        return object instanceof Number ? ((Number)object).longValue() : Long.parseLong(object.toString());
    }

    public static long toLong(Object object, long l) {
        return object == null ? l : JsonUtils.toLong(object);
    }

    public static String toString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static boolean[] toBooleanArray(Object[] objectArray) {
        boolean[] blArray = new boolean[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            blArray[i] = JsonUtils.toBoolean(objectArray[i]);
        }
        return blArray;
    }

    public static int[] toIntArray(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = JsonUtils.toInt(objectArray[i]);
        }
        return nArray;
    }

    public static String[] toStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    protected static String[] split(String string, char c, boolean bl) {
        char[] cArray = new char[]{'\\', c};
        if (string == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '\\') {
                ++n2;
            } else if (cArray2[i] == c && n2 % 2 == 0) {
                String string2 = new String(cArray2, n, i - n);
                string2 = JsonUtils.unEscapeChars(string2, cArray);
                if (bl) {
                    string2 = string2.trim();
                }
                linkedList.add(string2);
                n = i + 1;
            }
            if (cArray2[i] == '\\') continue;
            n2 = 0;
        }
        String string3 = new String(cArray2, n, cArray2.length - n);
        string3 = JsonUtils.unEscapeChars(string3, cArray);
        if (bl) {
            string3 = string3.trim();
        }
        linkedList.add(string3);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    protected static String[] split(String string, char c) {
        return JsonUtils.split(string, c, false);
    }

    protected static String unEscapeChars(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray2 = string.toCharArray();
        for (int i = 0; i < cArray2.length; ++i) {
            char c = cArray2[i];
            if (c == '\\' && i + 1 != cArray2.length) {
                char c2 = cArray2[i + 1];
                boolean bl = false;
                for (int j = 0; j < cArray.length && !bl; ++j) {
                    bl = c2 == cArray[j];
                }
                if (bl) {
                    ++i;
                } else if (c2 == '\\') {
                    stringBuffer.append('\\');
                    ++i;
                }
            }
            stringBuffer.append(cArray2[i]);
        }
        return stringBuffer.toString();
    }
}

