/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonList;
import com.ibm.jjson.JsonMap;
import com.ibm.jjson.JsonParseException;
import com.ibm.jjson.JsonParser;
import com.ibm.jjson.JsonSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int NUMBER = 4;
    private static final int BOOLEAN = 5;
    private static final Map types = new HashMap();

    public static Object parse(String string) throws JsonParseException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(string));
        return XmlParser.parseElement(documentBuilder.parse(inputSource).getDocumentElement());
    }

    public static Object parseElement(Element element) {
        int n = XmlParser.getJsonType(element);
        if (n == 1) {
            JsonMap jsonMap = new JsonMap();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                jsonMap.put(XmlParser.getJsonAttrName((Element)node), XmlParser.parseElement((Element)node));
            }
            return jsonMap;
        }
        if (n == 2) {
            JsonList jsonList = new JsonList();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                jsonList.add(XmlParser.parseElement((Element)node));
            }
            return jsonList;
        }
        if (n == 3) {
            return XmlParser.getTextContent(element);
        }
        if (n == 4) {
            return JsonParser.parseNumber(XmlParser.getTextContent(element).toCharArray(), new JsonParser.MutableInt(0));
        }
        if (n == 5) {
            return new Boolean(XmlParser.getTextContent(element).charAt(0) == 't');
        }
        return null;
    }

    private static String getTextContent(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return ((Text)node).getNodeValue();
        }
        return "";
    }

    private static int getJsonType(Element element) {
        return element.hasAttribute("type") ? ((Integer)types.get(element.getAttribute("type"))).intValue() : ((Integer)types.get(element.getNodeName())).intValue();
    }

    private static String getJsonAttrName(Element element) {
        String string = element.getNodeName();
        return types.get(string) == null ? XmlParser.decodeName(string) : null;
    }

    private static String decodeName(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < string.length() && !bl; ++i) {
            char c = string.charAt(i);
            if (c != '_') continue;
            bl = true;
        }
        if (bl) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '_' && i < cArray.length - 1 && cArray[i + 1] == 'x') {
                    stringBuffer.append((char)Integer.parseInt(new String(cArray, i + 2, 4), 16));
                    i += 6;
                    continue;
                }
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "<object>\t<name type='string'>John Smith</name>\t<address type='object'>\t\t<streetAddress type='string'>21 2nd Street</streetAddress>\t\t<city type='string'>New York</city>\t\t<state type='string'>NY</state>\t\t<postalCode type='number'>10021</postalCode>\t</address>\t<phoneNumbers type='array'>\t\t<string>212 555-1111</string>\t\t<string>212 555-2222</string>\t</phoneNumbers>\t<additionalInfo type='null'/>\t<remote type='boolean'>false</remote>\t<height type='number'>62.4</height>\t<fico_x0020_score type='string'> &gt; 640</fico_x0020_score></object>";
        try {
            Map map = (Map)XmlParser.parse(string);
            String string2 = JsonSerializer.serialize(map, JsonSerializer.NOT_STRICT, JsonSerializer.FORMAT_PRETTY);
            System.out.println(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static {
        types.put("object", new Integer(1));
        types.put("array", new Integer(2));
        types.put("string", new Integer(3));
        types.put("number", new Integer(4));
        types.put("boolean", new Integer(5));
        types.put("null", new Integer(6));
    }
}

