/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.StringUtils;

public class ExpressionSolver {
    public static boolean solveBoolean(String string) throws Exception {
        return ExpressionSolver.solveMath(string) > 0;
    }

    public static int solveMath(String string) throws Exception {
        if (StringUtils.isEmpty(string)) {
            throw new RuntimeException("Blank expression passed to ExpressionSolver.");
        }
        string = ExpressionSolver.fixUp(string);
        string = ExpressionSolver.methodizeOperator(string, '*', "mul");
        string = ExpressionSolver.methodizeOperator(string, '/', "div");
        string = ExpressionSolver.methodizeOperator(string, '+', "add");
        string = ExpressionSolver.methodizeOperator(string, '-', "sub");
        string = ExpressionSolver.methodizeOperator(string, '=', "equ");
        string = ExpressionSolver.methodizeOperator(string, '!', "neq");
        string = ExpressionSolver.methodizeOperator(string, '&', "and");
        string = ExpressionSolver.methodizeOperator(string, '|', "orr");
        string = ExpressionSolver.methodizeOperator(string, '>', "grt");
        string = ExpressionSolver.methodizeOperator(string, '<', "les");
        try {
            return ExpressionSolver.solve(string.toCharArray(), 0, string.length());
        }
        catch (ArithmeticException arithmeticException) {
            return 0;
        }
    }

    public static float solveFloatMath(String string) throws Exception {
        string = ExpressionSolver.fixUp(string);
        string = ExpressionSolver.methodizeOperator(string, '*', "mul");
        string = ExpressionSolver.methodizeOperator(string, '/', "div");
        string = ExpressionSolver.methodizeOperator(string, '+', "add");
        string = ExpressionSolver.methodizeOperator(string, '-', "sub");
        string = ExpressionSolver.methodizeOperator(string, '=', "equ");
        string = ExpressionSolver.methodizeOperator(string, '!', "neq");
        string = ExpressionSolver.methodizeOperator(string, '&', "and");
        float f = ExpressionSolver.solveFloat((string = ExpressionSolver.methodizeOperator(string, '|', "orr")).toCharArray(), 0, string.length());
        return Float.isNaN(f) ? 0.0f : f;
    }

    private static String methodizeOperator(String string, char c, String string2) {
        int n;
        while ((n = string.indexOf(c)) != -1) {
            char[] cArray = string.toCharArray();
            String string3 = ExpressionSolver.op1(cArray, n);
            String string4 = ExpressionSolver.op2(cArray, n);
            string = (string3.length() < n ? string.substring(0, n - string3.length()) : "") + string2 + "(" + string3 + "," + string4 + ")" + (n + string4.length() < string.length() ? string.substring(n + string4.length() + 1) : "");
        }
        return string;
    }

    private static String op1(char[] cArray, int n) {
        if (n == 0) {
            return "";
        }
        if (cArray[n - 1] == ')') {
            int n2 = 1;
            int n3 = 2;
            while (n2 != 0) {
                if (cArray[n - n3] == ')') {
                    ++n2;
                } else if (cArray[n - n3] == '(') {
                    --n2;
                }
                ++n3;
            }
            return new String(cArray, n - n3 - 2, n3 + 2);
        }
        int n4 = 1;
        while (n - n4 >= 0 && (Character.isJavaIdentifierPart(cArray[n - n4]) || cArray[n - n4] == '#')) {
            ++n4;
        }
        return new String(cArray, n - n4 + 1, n4 - 1);
    }

    private static String op2(char[] cArray, int n) {
        if (cArray.length > n + 4 && Character.isLetter(cArray[n + 1]) && Character.isLetter(cArray[n + 2]) && Character.isLetter(cArray[n + 3]) && cArray[n + 4] == '(') {
            int n2 = 1;
            int n3 = 5;
            while (n2 != 0) {
                if (cArray[n + n3] == '(') {
                    ++n2;
                } else if (cArray[n + n3] == ')') {
                    --n2;
                }
                ++n3;
            }
            return new String(cArray, n + 1, n3 - 1);
        }
        int n4 = 1;
        while (n + n4 < cArray.length && (Character.isJavaIdentifierPart(cArray[n + n4]) || cArray[n + n4] == '#')) {
            ++n4;
        }
        return new String(cArray, n + 1, n4 - 1);
    }

    private static String fixUp(String string) throws Exception {
        char c;
        if (string.indexOf(" >= ") != -1 || string.indexOf(" <= ") != -1) {
            throw new Exception("Unsupported operator used.");
        }
        int n = 0;
        while ((n = string.indexOf("true")) != -1) {
            string = string.substring(0, n) + "1" + string.substring(n + 4);
        }
        n = 0;
        while ((n = string.indexOf("false")) != -1) {
            string = string.substring(0, n) + "0" + string.substring(n + 5);
        }
        n = 0;
        while ((n = string.indexOf(" AND ")) != -1) {
            string = string.substring(0, n) + " && " + string.substring(n + 5);
        }
        n = 0;
        while ((n = string.indexOf(" OR ")) != -1) {
            string = string.substring(0, n) + " || " + string.substring(n + 4);
        }
        n = 0;
        while ((n = string.indexOf("!", n)) != -1) {
            if (string.charAt(n + 1) != '=') {
                string = string.substring(0, n) + "1 !=" + string.substring(n + 1);
                n += 4;
                continue;
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (Character.isSpaceChar(c)) continue;
            if (c == '&' || c == '|' || c == '!' || c == '=') {
                ++n;
            }
            stringBuffer.append(c);
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (!(c != '(' || n != 0 && Character.isLetter(string.charAt(n - 1)))) {
                stringBuffer.append("par(");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static int solve(char[] cArray, int n, int n2) throws Exception {
        if (Character.isDigit(cArray[n])) {
            try {
                return Integer.parseInt(new String(cArray, n, n2 - n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n + 3 >= cArray.length || cArray[n + 3] != '(') {
            return -999;
        }
        String string = new String(cArray, n, 3);
        int n3 = 0;
        int n4 = 1;
        for (int i = n + 4; i < n2 - 1; ++i) {
            if (cArray[i] == ',') {
                if (n3 != 0) continue;
                cArray[i] = 4096;
                ++n4;
                continue;
            }
            if (cArray[i] == '(') {
                ++n3;
                continue;
            }
            if (cArray[i] != ')') continue;
            --n3;
        }
        int[] nArray = new int[n4];
        int n5 = n + 4;
        for (int i = 0; i < n4 - 1; ++i) {
            int n6 = n5;
            while (cArray[n6] != '\u1000') {
                ++n6;
            }
            nArray[i] = ExpressionSolver.solve(cArray, n5, n6);
            n5 = n6 + 1;
        }
        nArray[n4 - 1] = ExpressionSolver.solve(cArray, n5, n2 - 1);
        if (nArray.length > 1 && nArray[0] == -999 && nArray[1] == -999) {
            String string2 = new String(cArray, n + 4, n2 - n - 5);
            String string3 = string2.substring(0, string2.indexOf(4096));
            String string4 = string2.substring(string2.indexOf(4096) + 1);
            if (string.equals("equ")) {
                return string3.equals(string4) ? 1 : 0;
            }
            if (string.equals("neq")) {
                return string3.equals(string4) ? 0 : 1;
            }
        }
        if (string.equals("add")) {
            return nArray[0] + nArray[1];
        }
        if (string.equals("sub")) {
            return nArray[0] - nArray[1];
        }
        if (string.equals("mul")) {
            return nArray[0] * nArray[1];
        }
        if (string.equals("div")) {
            return nArray[0] / nArray[1];
        }
        if (string.equals("max")) {
            return Math.max(nArray[0], nArray[1]);
        }
        if (string.equals("min")) {
            return Math.min(nArray[0], nArray[1]);
        }
        if (string.equals("par")) {
            return nArray[0];
        }
        if (string.equals("abs")) {
            return Math.abs(nArray[0]);
        }
        if (string.equals("equ")) {
            return nArray[0] == nArray[1] ? 1 : 0;
        }
        if (string.equals("neq")) {
            return nArray[0] != nArray[1] ? 1 : 0;
        }
        if (string.equals("and")) {
            return nArray[0] > 0 && nArray[1] > 0 ? 1 : 0;
        }
        if (string.equals("orr")) {
            return nArray[0] > 0 || nArray[1] > 0 ? 1 : 0;
        }
        if (string.equals("grt")) {
            return nArray[0] > nArray[1] ? 1 : 0;
        }
        if (string.equals("les")) {
            return nArray[0] < nArray[1] ? 1 : 0;
        }
        return -999;
    }

    private static float solveFloat(char[] cArray, int n, int n2) throws Exception {
        if (Character.isDigit(cArray[n])) {
            try {
                return Float.parseFloat(new String(cArray, n, n2 - n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n + 3 >= cArray.length || cArray[n + 3] != '(') {
            return -999.0f;
        }
        String string = new String(cArray, n, 3);
        int n3 = 0;
        int n4 = 1;
        for (int i = n + 4; i < n2 - 1; ++i) {
            if (cArray[i] == ',') {
                if (n3 != 0) continue;
                cArray[i] = 4096;
                ++n4;
                continue;
            }
            if (cArray[i] == '(') {
                ++n3;
                continue;
            }
            if (cArray[i] != ')') continue;
            --n3;
        }
        float[] fArray = new float[n4];
        int n5 = n + 4;
        for (int i = 0; i < n4 - 1; ++i) {
            int n6 = n5;
            while (cArray[n6] != '\u1000') {
                ++n6;
            }
            fArray[i] = ExpressionSolver.solveFloat(cArray, n5, n6);
            n5 = n6 + 1;
        }
        fArray[n4 - 1] = ExpressionSolver.solveFloat(cArray, n5, n2 - 1);
        if (fArray.length > 1 && fArray[0] == -999.0f && fArray[1] == -999.0f) {
            String string2 = new String(cArray, n + 4, n2 - n - 5);
            String string3 = string2.substring(0, string2.indexOf(4096));
            String string4 = string2.substring(string2.indexOf(4096) + 1);
            if (string.equals("equ")) {
                return string3.equals(string4) ? 1 : 0;
            }
            if (string.equals("neq")) {
                return !string3.equals(string4) ? 1 : 0;
            }
        }
        if (string.equals("add")) {
            return fArray[0] + fArray[1];
        }
        if (string.equals("sub")) {
            return fArray[0] - fArray[1];
        }
        if (string.equals("mul")) {
            return fArray[0] * fArray[1];
        }
        if (string.equals("div")) {
            return fArray[0] / fArray[1];
        }
        if (string.equals("max")) {
            return Math.max(fArray[0], fArray[1]);
        }
        if (string.equals("min")) {
            return Math.min(fArray[0], fArray[1]);
        }
        if (string.equals("par")) {
            return fArray[0];
        }
        if (string.equals("abs")) {
            return Math.abs(fArray[0]);
        }
        if (string.equals("equ")) {
            return fArray[0] == fArray[1] ? 1 : 0;
        }
        if (string.equals("neq")) {
            return fArray[0] != fArray[1] ? 1 : 0;
        }
        if (string.equals("and")) {
            return fArray[0] > 0.0f && fArray[1] > 0.0f ? 1 : 0;
        }
        if (string.equals("orr")) {
            return fArray[0] > 0.0f || fArray[1] > 0.0f ? 1 : 0;
        }
        return -999.0f;
    }
}

