/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocaleMgr {
    private static LocaleMgr localeMgr = new LocaleMgr();

    public static String getExternalDefaultEncoding() {
        String string = System.getProperty("externalFileEncoding");
        if (string != null && !string.trim().equals("")) {
            return string;
        }
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("OS/390") || string2.startsWith("z/OS")) {
            String string3 = Locale.getDefault().getLanguage();
            String string4 = Locale.getDefault().getCountry();
            if (string3.equals("ja") || string4.equals("JP")) {
                return "Cp939";
            }
            return "Cp1047";
        }
        return "UTF-8";
    }

    public static String getLocaleSpecificPath(String string, Locale locale) {
        String string2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        char c = File.separatorChar;
        string = string.replace('\\', c).replace('/', c);
        String string3 = string.substring(0, string.lastIndexOf(c));
        String string4 = string.substring(string.lastIndexOf(c) + 1);
        String string5 = string4.substring(0, string4.lastIndexOf(46));
        String string6 = string4.substring(string4.lastIndexOf(46));
        String string7 = "_" + locale.toString() + "_";
        while (string7.length() > 0) {
            string7 = string7.substring(0, string7.lastIndexOf(95));
            string2 = string3 + c + string5 + string7 + string6;
            if (!new File(string2).exists()) continue;
            return string2;
        }
        string3 = string3 + c + "i18n";
        string7 = "_" + locale.toString() + "_";
        while (string7.length() > 0) {
            string7 = string7.substring(0, string7.lastIndexOf(95));
            string2 = string3 + c + string5 + string7 + string6;
            if (!new File(string2).exists()) continue;
            return string2;
        }
        return null;
    }

    public static URL getLocaleSpecificClasspathFile(String string, Locale locale) {
        URL uRL;
        String string2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = string.substring(0, string.lastIndexOf(46));
        String string4 = string.substring(string.lastIndexOf(46));
        String string5 = "_" + locale.toString() + "_";
        while (string5.length() > 0) {
            string5 = string5.substring(0, string5.lastIndexOf(95));
            string2 = "/" + string3 + string5 + string4;
            uRL = localeMgr.getClass().getResource(string2);
            if (uRL == null) continue;
            return uRL;
        }
        string5 = "_" + locale.toString() + "_";
        while (string5.length() > 0) {
            string5 = string5.substring(0, string5.lastIndexOf(95));
            string2 = "/i18n/" + string3 + string5 + string4;
            uRL = localeMgr.getClass().getResource(string2);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    public static ResourceBundle getResourceBundle(String string, Locale locale) throws IOException {
        String string2 = LocaleMgr.getLocaleSpecificPath(string = string.substring(0, string.lastIndexOf(46)) + ".properties", locale);
        if (string2 == null) {
            return null;
        }
        return new PropertyResourceBundle(new FileInputStream(new File(string2)));
    }

    public static Locale getLocale(String string) {
        String[] stringArray = StringUtils.split(string, '_');
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            return new Locale(stringArray[0], "");
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }
}

