#include <stdio.h>
#include "a.out.h.pc"

extern long textoff, textaddr, textlen;
extern long dataoff, dataaddr, datalen;
extern long bssaddr, bsslen;
extern long symoff, symlen;
extern long entry;

void copy();

void cvtout(verbose)
int verbose;
{
    struct exec e;

    e.a_magic[0] = A_MAGIC0;
    e.a_magic[1] = A_MAGIC1;
    e.a_flags = A_EXEC;
    e.a_cpu = A_I80386;
    e.a_hdrlen = 32;
    e.a_unused = 0;
    e.a_version = 0;	/* what? */

    e.a_text = dataaddr;	/* includes blank seg maybe and seg rounding */
    e.a_data = datalen;
    e.a_bss = bsslen;
    e.a_no_entry = entry;
    e.a_total = e.a_text + e.a_data + e.a_bss + 64 * 1024;	/* ??? */
#ifdef DO_SYMS
    e.a_syms = symlen;
#else
    e.a_syms = 0;
#endif

    fwrite(&e, e.a_hdrlen, 1, stdout);
    if(verbose)
        fprintf(stderr, "%ld bytes of header starting at 0\n", e.a_hdrlen);

    fseek(stdin, textoff, 0);
    fseek(stdout, A_TEXTPOS(e) + textaddr, 0);
    copy(textlen);
    if(verbose)
        fprintf(stderr, "%ld bytes of text starting at %ld\n",
	        textlen, A_TEXTPOS(e) + textaddr);

    fseek(stdin, dataoff, 0);
    fseek(stdout, A_DATAPOS(e), 0);
    copy(datalen);
    if(verbose)
        fprintf(stderr, "%ld bytes of data starting at %ld\n",
	        datalen, A_DATAPOS(e));

#ifdef DO_SYMS
    fseek(stdin, symoff, 0);
    copy(symlen);
    if(verbose)
        fprintf(stderr, "%ld bytes of symbols\n", symlen);
#endif
}

void copy(len)
long len;
{
    static char buf[1024];
    int n;

    while(len > 0)
    {
	n = len > sizeof(buf) ? sizeof(buf) : len;
	if(fread(buf, 1, n, stdin) != n)
	{
	    fprintf(stderr, "error reading input\n");
	    exit(1);
	}
	fwrite(buf, 1, n, stdout);
	len -= n;
    }
}

